/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.flink.FlinkCatalogTestBase;
import org.apache.iceberg.flink.FlinkTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFlinkHiveCatalog
extends FlinkTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testCreateCatalogWithWarehouseLocation() throws IOException {
        HashMap props = Maps.newHashMap();
        props.put("type", "iceberg");
        props.put("catalog-type", "hive");
        props.put("uri", FlinkCatalogTestBase.getURI(hiveConf));
        File warehouseDir = this.tempFolder.newFolder();
        props.put("warehouse", "file://" + warehouseDir.getAbsolutePath());
        this.checkSQLQuery(props, warehouseDir);
    }

    @Test
    public void testCreateCatalogWithHiveConfDir() throws IOException {
        File hiveConfDir = this.tempFolder.newFolder();
        File hiveSiteXML = new File(hiveConfDir, "hive-site.xml");
        File warehouseDir = this.tempFolder.newFolder();
        try (FileOutputStream fos = new FileOutputStream(hiveSiteXML);){
            Configuration newConf = new Configuration((Configuration)hiveConf);
            newConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, "file://" + warehouseDir.getAbsolutePath());
            newConf.writeXml((OutputStream)fos);
        }
        Assert.assertTrue((String)"hive-site.xml should be created now.", (boolean)Files.exists(hiveSiteXML.toPath(), new LinkOption[0]));
        HashMap props = Maps.newHashMap();
        props.put("type", "iceberg");
        props.put("catalog-type", "hive");
        props.put("uri", FlinkCatalogTestBase.getURI(hiveConf));
        props.put("hive-conf-dir", hiveConfDir.getAbsolutePath());
        this.checkSQLQuery(props, warehouseDir);
    }

    private void checkSQLQuery(Map<String, String> catalogProperties, File warehouseDir) throws IOException {
        this.sql("CREATE CATALOG test_catalog WITH %s", FlinkCatalogTestBase.toWithClause(catalogProperties));
        this.sql("USE CATALOG test_catalog", new Object[0]);
        this.sql("CREATE DATABASE test_db", new Object[0]);
        this.sql("USE test_db", new Object[0]);
        this.sql("CREATE TABLE test_table(c1 INT, c2 STRING)", new Object[0]);
        this.sql("INSERT INTO test_table SELECT 1, 'a'", new Object[0]);
        Path databasePath = warehouseDir.toPath().resolve("test_db.db");
        Assert.assertTrue((String)"Database path should exist", (boolean)Files.exists(databasePath, new LinkOption[0]));
        Path tablePath = databasePath.resolve("test_table");
        Assert.assertTrue((String)"Table path should exist", (boolean)Files.exists(tablePath, new LinkOption[0]));
        Path dataPath = tablePath.resolve("data");
        Assert.assertTrue((String)"Table data path should exist", (boolean)Files.exists(dataPath, new LinkOption[0]));
        Assert.assertEquals((String)"Should have a .crc file and a .parquet file", (long)2L, (long)Files.list(dataPath).count());
        this.sql("DROP TABLE test_table", new Object[0]);
        this.sql("DROP DATABASE test_db", new Object[0]);
        this.dropCatalog("test_catalog", false);
    }
}

