/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataConverter;
import org.apache.iceberg.flink.data.RowDataUtil;
import org.apache.iceberg.flink.source.FlinkInputFormat;
import org.apache.iceberg.flink.source.FlinkInputSplit;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;

public class TestHelpers {
    private TestHelpers() {
    }

    public static <T> T roundTripKryoSerialize(Class<T> clazz, T table) throws IOException {
        KryoSerializer kryo = new KryoSerializer(clazz, new ExecutionConfig());
        DataOutputSerializer outputView = new DataOutputSerializer(1024);
        kryo.serialize(table, (DataOutputView)outputView);
        DataInputDeserializer inputView = new DataInputDeserializer(outputView.getCopyOfBuffer());
        return (T)kryo.deserialize((DataInputView)inputView);
    }

    public static RowData copyRowData(RowData from, RowType rowType) {
        TypeSerializer[] fieldSerializers = (TypeSerializer[])rowType.getChildren().stream().map(type -> InternalSerializers.create((LogicalType)type)).toArray(TypeSerializer[]::new);
        return RowDataUtil.clone((RowData)from, null, (RowType)rowType, (TypeSerializer[])fieldSerializers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRowData(FlinkInputFormat input, Consumer<RowData> visitor) throws IOException {
        for (FlinkInputSplit s : input.createInputSplits(0)) {
            input.open(s);
            try {
                while (!input.reachedEnd()) {
                    RowData row = input.nextRecord(null);
                    visitor.accept(row);
                }
            }
            finally {
                input.close();
            }
        }
    }

    public static List<RowData> readRowData(FlinkInputFormat inputFormat, RowType rowType) throws IOException {
        ArrayList results = Lists.newArrayList();
        TestHelpers.readRowData(inputFormat, (RowData row) -> results.add(TestHelpers.copyRowData(row, rowType)));
        return results;
    }

    public static List<Row> readRows(FlinkInputFormat inputFormat, RowType rowType) throws IOException {
        return TestHelpers.convertRowDataToRow(TestHelpers.readRowData(inputFormat, rowType), rowType);
    }

    public static List<Row> convertRowDataToRow(List<RowData> rowDataList, RowType rowType) {
        DataStructureConverter converter = DataStructureConverters.getConverter((DataType)TypeConversions.fromLogicalToDataType((LogicalType)rowType));
        return rowDataList.stream().map(arg_0 -> ((DataStructureConverter)converter).toExternal(arg_0)).map(Row.class::cast).collect(Collectors.toList());
    }

    public static void assertRecords(List<Row> results, List<Record> expectedRecords, Schema schema) {
        ArrayList expected = Lists.newArrayList();
        DataStructureConverter converter = DataStructureConverters.getConverter((DataType)TypeConversions.fromLogicalToDataType((LogicalType)FlinkSchemaUtil.convert((Schema)schema)));
        expectedRecords.forEach(r -> expected.add((Row)converter.toExternal((Object)RowDataConverter.convert(schema, r))));
        TestHelpers.assertRows(results, expected);
    }

    public static void assertRows(List<RowData> results, List<RowData> expected, RowType rowType) {
        TestHelpers.assertRows(TestHelpers.convertRowDataToRow(results, rowType), TestHelpers.convertRowDataToRow(expected, rowType));
    }

    public static void assertRows(List<Row> results, List<Row> expected) {
        Assertions.assertThat(results).containsExactlyInAnyOrderElementsOf(expected);
    }

    public static void assertRowData(Schema schema, StructLike expected, RowData actual) {
        TestHelpers.assertRowData(schema.asStruct(), (LogicalType)FlinkSchemaUtil.convert((Schema)schema), expected, actual);
    }

    public static void assertRowData(Types.StructType structType, LogicalType rowType, StructLike expectedRecord, RowData actualRowData) {
        if (expectedRecord == null && actualRowData == null) {
            return;
        }
        Assert.assertTrue((String)"expected Record and actual RowData should be both null or not null", (expectedRecord != null && actualRowData != null ? 1 : 0) != 0);
        ArrayList types = Lists.newArrayList();
        for (Types.NestedField field : structType.fields()) {
            types.add(field.type());
        }
        for (int i = 0; i < types.size(); ++i) {
            LogicalType logicalType = ((RowType)rowType).getTypeAt(i);
            Object expected = expectedRecord.get(i, Object.class);
            Object actual = actualRowData.isNullAt(i) ? null : RowData.createFieldGetter((LogicalType)logicalType, (int)i).getFieldOrNull(actualRowData);
            TestHelpers.assertEquals((Type)types.get(i), logicalType, expected, actual);
        }
    }

    private static void assertEquals(Type type, LogicalType logicalType, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertTrue((String)"expected and actual should be both null or not null", (expected != null && actual != null ? 1 : 0) != 0);
        switch (type.typeId()) {
            case BOOLEAN: {
                Assert.assertEquals((String)"boolean value should be equal", (Object)expected, (Object)actual);
                break;
            }
            case INTEGER: {
                Assert.assertEquals((String)"int value should be equal", (Object)expected, (Object)actual);
                break;
            }
            case LONG: {
                Assert.assertEquals((String)"long value should be equal", (Object)expected, (Object)actual);
                break;
            }
            case FLOAT: {
                Assert.assertEquals((String)"float value should be equal", (Object)expected, (Object)actual);
                break;
            }
            case DOUBLE: {
                Assert.assertEquals((String)"double value should be equal", (Object)expected, (Object)actual);
                break;
            }
            case STRING: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a CharSequence", new Object[0])).isInstanceOf(CharSequence.class);
                Assert.assertEquals((String)"string should be equal", (Object)String.valueOf(expected), (Object)actual.toString());
                break;
            }
            case DATE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Date", new Object[0])).isInstanceOf(LocalDate.class);
                LocalDate date = DateTimeUtil.dateFromDays((int)((Integer)actual));
                Assert.assertEquals((String)"date should be equal", (Object)expected, (Object)date);
                break;
            }
            case TIME: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalTime", new Object[0])).isInstanceOf(LocalTime.class);
                int milliseconds = (int)(((LocalTime)expected).toNanoOfDay() / 1000000L);
                Assert.assertEquals((String)"time millis should be equal", (Object)milliseconds, (Object)actual);
                break;
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a OffsetDataTime", new Object[0])).isInstanceOf(OffsetDateTime.class);
                    OffsetDateTime ts = (OffsetDateTime)expected;
                    Assert.assertEquals((String)"OffsetDataTime should be equal", (Object)ts.toLocalDateTime(), (Object)((TimestampData)actual).toLocalDateTime());
                    break;
                }
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalDataTime", new Object[0])).isInstanceOf(LocalDateTime.class);
                LocalDateTime ts = (LocalDateTime)expected;
                Assert.assertEquals((String)"LocalDataTime should be equal", (Object)ts, (Object)((TimestampData)actual).toLocalDateTime());
                break;
            }
            case BINARY: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a ByteBuffer", new Object[0])).isInstanceOf(ByteBuffer.class);
                Assert.assertEquals((String)"binary should be equal", (Object)expected, (Object)ByteBuffer.wrap((byte[])actual));
                break;
            }
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                BigDecimal bd = (BigDecimal)expected;
                Assert.assertEquals((String)"decimal value should be equal", (Object)bd, (Object)((DecimalData)actual).toBigDecimal());
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(Collection.class);
                Collection expectedArrayData = (Collection)expected;
                ArrayData actualArrayData = (ArrayData)actual;
                LogicalType elementType = ((ArrayType)logicalType).getElementType();
                Assert.assertEquals((String)"array length should be equal", (long)expectedArrayData.size(), (long)actualArrayData.size());
                TestHelpers.assertArrayValues(type.asListType().elementType(), elementType, expectedArrayData, actualArrayData);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Map", new Object[0])).isInstanceOf(Map.class);
                TestHelpers.assertMapValues(type.asMapType(), logicalType, (Map)expected, (MapData)actual);
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Record", new Object[0])).isInstanceOf(StructLike.class);
                TestHelpers.assertRowData(type.asStructType(), logicalType, (StructLike)expected, (RowData)actual);
                break;
            }
            case UUID: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a UUID", new Object[0])).isInstanceOf(UUID.class);
                ByteBuffer bb = ByteBuffer.wrap((byte[])actual);
                long firstLong = bb.getLong();
                long secondLong = bb.getLong();
                Assert.assertEquals((String)"UUID should be equal", (Object)expected.toString(), (Object)new UUID(firstLong, secondLong).toString());
                break;
            }
            case FIXED: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"binary should be equal", (byte[])((byte[])expected), (byte[])((byte[])actual));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }

    public static void assertEquals(Schema schema, List<GenericData.Record> records, List<Row> rows) {
        Streams.forEachPair(records.stream(), rows.stream(), (record, row) -> TestHelpers.assertEquals(schema, record, row));
    }

    public static void assertEquals(Schema schema, GenericData.Record record, Row row) {
        List fields = schema.asStruct().fields();
        Assert.assertEquals((long)fields.size(), (long)record.getSchema().getFields().size());
        Assert.assertEquals((long)fields.size(), (long)row.getArity());
        RowType rowType = FlinkSchemaUtil.convert((Schema)schema);
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = record.get(i);
            Object actualValue = row.getField(i);
            LogicalType logicalType = rowType.getTypeAt(i);
            TestHelpers.assertAvroEquals(fieldType, logicalType, expectedValue, actualValue);
        }
    }

    private static void assertEquals(Types.StructType struct, GenericData.Record record, Row row) {
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = record.get(i);
            Object actualValue = row.getField(i);
            TestHelpers.assertAvroEquals(fieldType, null, expectedValue, actualValue);
        }
    }

    private static void assertAvroEquals(Type type, LogicalType logicalType, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        Assert.assertTrue((String)"expected and actual should be both null or not null", (expected != null && actual != null ? 1 : 0) != 0);
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a " + type.typeId().javaClass(), new Object[0])).isInstanceOf(type.typeId().javaClass());
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should expect a " + type.typeId().javaClass(), new Object[0])).isInstanceOf(type.typeId().javaClass());
                Assert.assertEquals((String)(type.typeId() + " value should be equal"), (Object)expected, (Object)actual);
                break;
            }
            case STRING: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a CharSequence", new Object[0])).isInstanceOf(CharSequence.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Should expect a CharSequence", new Object[0])).isInstanceOf(CharSequence.class);
                Assert.assertEquals((String)"string should be equal", (Object)expected.toString(), (Object)actual.toString());
                break;
            }
            case DATE: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Date", new Object[0])).isInstanceOf(LocalDate.class);
                LocalDate date = DateTimeUtil.dateFromDays((int)((Integer)actual));
                Assert.assertEquals((String)"date should be equal", (Object)expected, (Object)date);
                break;
            }
            case TIME: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalTime", new Object[0])).isInstanceOf(LocalTime.class);
                int milliseconds = (int)(((LocalTime)expected).toNanoOfDay() / 1000000L);
                Assert.assertEquals((String)"time millis should be equal", (Object)milliseconds, (Object)actual);
                break;
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a OffsetDataTime", new Object[0])).isInstanceOf(OffsetDateTime.class);
                    OffsetDateTime ts = (OffsetDateTime)expected;
                    Assert.assertEquals((String)"OffsetDataTime should be equal", (Object)ts.toLocalDateTime(), (Object)((TimestampData)actual).toLocalDateTime());
                    break;
                }
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a LocalDataTime", new Object[0])).isInstanceOf(LocalDateTime.class);
                LocalDateTime ts = (LocalDateTime)expected;
                Assert.assertEquals((String)"LocalDataTime should be equal", (Object)ts, (Object)((TimestampData)actual).toLocalDateTime());
                break;
            }
            case BINARY: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a ByteBuffer", new Object[0])).isInstanceOf(ByteBuffer.class);
                Assert.assertEquals((String)"binary should be equal", (Object)expected, (Object)ByteBuffer.wrap((byte[])actual));
                break;
            }
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a BigDecimal", new Object[0])).isInstanceOf(BigDecimal.class);
                BigDecimal bd = (BigDecimal)expected;
                Assert.assertEquals((String)"decimal value should be equal", (Object)bd, (Object)((DecimalData)actual).toBigDecimal());
                break;
            }
            case LIST: {
                ArrayData actualArrayData;
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Collection", new Object[0])).isInstanceOf(Collection.class);
                Collection expectedArrayData = (Collection)expected;
                try {
                    actualArrayData = (ArrayData)actual;
                }
                catch (ClassCastException e) {
                    actualArrayData = new GenericArrayData((Object[])actual);
                }
                LogicalType elementType = ((ArrayType)logicalType).getElementType();
                Assert.assertEquals((String)"array length should be equal", (long)expectedArrayData.size(), (long)actualArrayData.size());
                TestHelpers.assertArrayValues(type.asListType().elementType(), elementType, expectedArrayData, actualArrayData);
                break;
            }
            case MAP: {
                MapData actualMap;
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Map", new Object[0])).isInstanceOf(Map.class);
                try {
                    actualMap = (MapData)actual;
                }
                catch (ClassCastException e) {
                    actualMap = new GenericMapData((Map)actual);
                }
                TestHelpers.assertMapValues(type.asMapType(), logicalType, (Map)expected, actualMap);
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a Record", new Object[0])).isInstanceOf(GenericData.Record.class);
                TestHelpers.assertEquals(type.asNestedType().asStructType(), (GenericData.Record)expected, (Row)actual);
                break;
            }
            case UUID: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect a UUID", new Object[0])).isInstanceOf(UUID.class);
                ByteBuffer bb = ByteBuffer.wrap((byte[])actual);
                long firstLong = bb.getLong();
                long secondLong = bb.getLong();
                Assert.assertEquals((String)"UUID should be equal", (Object)expected.toString(), (Object)new UUID(firstLong, secondLong).toString());
                break;
            }
            case FIXED: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Should expect byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"binary should be equal", (byte[])((byte[])expected), (byte[])((byte[])actual));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }

    private static void assertArrayValues(Type type, LogicalType logicalType, Collection<?> expectedArray, ArrayData actualArray) {
        ArrayList expectedElements = Lists.newArrayList(expectedArray);
        for (int i = 0; i < expectedArray.size(); ++i) {
            if (expectedElements.get(i) == null) {
                Assert.assertTrue((boolean)actualArray.isNullAt(i));
                continue;
            }
            Object expected = expectedElements.get(i);
            TestHelpers.assertEquals(type, logicalType, expected, ArrayData.createElementGetter((LogicalType)logicalType).getElementOrNull(actualArray, i));
        }
    }

    private static void assertMapValues(Types.MapType mapType, LogicalType type, Map<?, ?> expected, MapData actual) {
        Assert.assertEquals((String)"map size should be equal", (long)expected.size(), (long)actual.size());
        ArrayData actualKeyArrayData = actual.keyArray();
        ArrayData actualValueArrayData = actual.valueArray();
        LogicalType actualKeyType = ((MapType)type).getKeyType();
        LogicalType actualValueType = ((MapType)type).getValueType();
        Type keyType = mapType.keyType();
        Type valueType = mapType.valueType();
        ArrayData.ElementGetter keyGetter = ArrayData.createElementGetter((LogicalType)actualKeyType);
        ArrayData.ElementGetter valueGetter = ArrayData.createElementGetter((LogicalType)actualValueType);
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            Object matchedActualKey = null;
            int matchedKeyIndex = 0;
            for (int i = 0; i < actual.size(); ++i) {
                try {
                    Object key = keyGetter.getElementOrNull(actualKeyArrayData, i);
                    TestHelpers.assertEquals(keyType, actualKeyType, entry.getKey(), key);
                    matchedActualKey = key;
                    matchedKeyIndex = i;
                    break;
                }
                catch (AssertionError assertionError) {
                    continue;
                }
            }
            Assert.assertNotNull((String)"Should have a matching key", matchedActualKey);
            int valueIndex = matchedKeyIndex;
            TestHelpers.assertEquals(valueType, actualValueType, entry.getValue(), valueGetter.getElementOrNull(actualValueArrayData, valueIndex));
        }
    }

    public static void assertEquals(ManifestFile expected, ManifestFile actual) {
        if (expected == actual) {
            return;
        }
        Assert.assertTrue((String)"Should not be null.", (expected != null && actual != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Path must match", (Object)expected.path(), (Object)actual.path());
        Assert.assertEquals((String)"Length must match", (long)expected.length(), (long)actual.length());
        Assert.assertEquals((String)"Spec id must match", (long)expected.partitionSpecId(), (long)actual.partitionSpecId());
        Assert.assertEquals((String)"ManifestContent must match", (Object)expected.content(), (Object)actual.content());
        Assert.assertEquals((String)"SequenceNumber must match", (long)expected.sequenceNumber(), (long)actual.sequenceNumber());
        Assert.assertEquals((String)"MinSequenceNumber must match", (long)expected.minSequenceNumber(), (long)actual.minSequenceNumber());
        Assert.assertEquals((String)"Snapshot id must match", (Object)expected.snapshotId(), (Object)actual.snapshotId());
        Assert.assertEquals((String)"Added files flag must match", (Object)expected.hasAddedFiles(), (Object)actual.hasAddedFiles());
        Assert.assertEquals((String)"Added files count must match", (Object)expected.addedFilesCount(), (Object)actual.addedFilesCount());
        Assert.assertEquals((String)"Added rows count must match", (Object)expected.addedRowsCount(), (Object)actual.addedRowsCount());
        Assert.assertEquals((String)"Existing files flag must match", (Object)expected.hasExistingFiles(), (Object)actual.hasExistingFiles());
        Assert.assertEquals((String)"Existing files count must match", (Object)expected.existingFilesCount(), (Object)actual.existingFilesCount());
        Assert.assertEquals((String)"Existing rows count must match", (Object)expected.existingRowsCount(), (Object)actual.existingRowsCount());
        Assert.assertEquals((String)"Deleted files flag must match", (Object)expected.hasDeletedFiles(), (Object)actual.hasDeletedFiles());
        Assert.assertEquals((String)"Deleted files count must match", (Object)expected.deletedFilesCount(), (Object)actual.deletedFilesCount());
        Assert.assertEquals((String)"Deleted rows count must match", (Object)expected.deletedRowsCount(), (Object)actual.deletedRowsCount());
        List expectedSummaries = expected.partitions();
        List actualSummaries = actual.partitions();
        Assert.assertEquals((String)"PartitionFieldSummary size does not match", (long)expectedSummaries.size(), (long)actualSummaries.size());
        for (int i = 0; i < expectedSummaries.size(); ++i) {
            Assert.assertEquals((String)"Null flag in partition must match", (Object)((ManifestFile.PartitionFieldSummary)expectedSummaries.get(i)).containsNull(), (Object)((ManifestFile.PartitionFieldSummary)actualSummaries.get(i)).containsNull());
            Assert.assertEquals((String)"NaN flag in partition must match", (Object)((ManifestFile.PartitionFieldSummary)expectedSummaries.get(i)).containsNaN(), (Object)((ManifestFile.PartitionFieldSummary)actualSummaries.get(i)).containsNaN());
            Assert.assertEquals((String)"Lower bounds in partition must match", (Object)((ManifestFile.PartitionFieldSummary)expectedSummaries.get(i)).lowerBound(), (Object)((ManifestFile.PartitionFieldSummary)actualSummaries.get(i)).lowerBound());
            Assert.assertEquals((String)"Upper bounds in partition must match", (Object)((ManifestFile.PartitionFieldSummary)expectedSummaries.get(i)).upperBound(), (Object)((ManifestFile.PartitionFieldSummary)actualSummaries.get(i)).upperBound());
        }
    }

    public static void assertEquals(ContentFile<?> expected, ContentFile<?> actual) {
        if (expected == actual) {
            return;
        }
        Assert.assertTrue((String)"Shouldn't be null.", (expected != null && actual != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"SpecId", (long)expected.specId(), (long)actual.specId());
        Assert.assertEquals((String)"Content", (Object)expected.content(), (Object)actual.content());
        Assert.assertEquals((String)"Path", (Object)expected.path(), (Object)actual.path());
        Assert.assertEquals((String)"Format", (Object)expected.format(), (Object)actual.format());
        Assert.assertEquals((String)"Partition size", (long)expected.partition().size(), (long)actual.partition().size());
        for (int i = 0; i < expected.partition().size(); ++i) {
            Assert.assertEquals((String)("Partition data at index " + i), (Object)expected.partition().get(i, Object.class), (Object)actual.partition().get(i, Object.class));
        }
        Assert.assertEquals((String)"Record count", (long)expected.recordCount(), (long)actual.recordCount());
        Assert.assertEquals((String)"File size in bytes", (long)expected.fileSizeInBytes(), (long)actual.fileSizeInBytes());
        Assert.assertEquals((String)"Column sizes", (Object)expected.columnSizes(), (Object)actual.columnSizes());
        Assert.assertEquals((String)"Value counts", (Object)expected.valueCounts(), (Object)actual.valueCounts());
        Assert.assertEquals((String)"Null value counts", (Object)expected.nullValueCounts(), (Object)actual.nullValueCounts());
        Assert.assertEquals((String)"Lower bounds", (Object)expected.lowerBounds(), (Object)actual.lowerBounds());
        Assert.assertEquals((String)"Upper bounds", (Object)expected.upperBounds(), (Object)actual.upperBounds());
        Assert.assertEquals((String)"Key metadata", (Object)expected.keyMetadata(), (Object)actual.keyMetadata());
        Assert.assertEquals((String)"Split offsets", (Object)expected.splitOffsets(), (Object)actual.splitOffsets());
        Assert.assertEquals((String)"Equality field id list", (Object)actual.equalityFieldIds(), (Object)expected.equalityFieldIds());
    }
}

