/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.RecordWrapperTest;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.data.RandomRowData;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.assertj.core.api.Assertions;
import org.junit.Assert;

public class TestRowDataWrapper
extends RecordWrapperTest {
    public void testTime() {
        this.generateAndValidate(new Schema(TIME.fields()), (message, expectedWrapper, actualWrapper) -> {
            for (int pos = 0; pos < TIME.fields().size(); ++pos) {
                Object actual;
                Object expected = expectedWrapper.get().get(pos, Object.class);
                if (expected == (actual = actualWrapper.get().get(pos, Object.class))) {
                    return;
                }
                Assertions.assertThat((Object)actual).isNotNull();
                Assertions.assertThat((Object)expected).isNotNull();
                int expectedMilliseconds = (int)((Long)expected / 1000000L);
                int actualMilliseconds = (int)((Long)actual / 1000000L);
                Assert.assertEquals((String)message, (long)expectedMilliseconds, (long)actualMilliseconds);
            }
        });
    }

    protected void generateAndValidate(Schema schema, RecordWrapperTest.AssertMethod assertMethod) {
        int numRecords = 100;
        List recordList = RandomGenericData.generate((Schema)schema, (int)numRecords, (long)101L);
        Iterable<RowData> rowDataList = RandomRowData.generate(schema, numRecords, 101L);
        InternalRecordWrapper recordWrapper = new InternalRecordWrapper(schema.asStruct());
        RowDataWrapper rowDataWrapper = new RowDataWrapper(FlinkSchemaUtil.convert((Schema)schema), schema.asStruct());
        Iterator actual = recordList.iterator();
        Iterator<RowData> expected = rowDataList.iterator();
        StructLikeWrapper actualWrapper = StructLikeWrapper.forType((Types.StructType)schema.asStruct());
        StructLikeWrapper expectedWrapper = StructLikeWrapper.forType((Types.StructType)schema.asStruct());
        for (int i = 0; i < numRecords; ++i) {
            Assert.assertTrue((String)"Should have more records", (boolean)actual.hasNext());
            Assert.assertTrue((String)"Should have more RowData", (boolean)expected.hasNext());
            InternalRecordWrapper recordStructLike = recordWrapper.wrap((StructLike)actual.next());
            RowDataWrapper rowDataStructLike = rowDataWrapper.wrap(expected.next());
            assertMethod.assertEquals("Should have expected StructLike values", actualWrapper.set((StructLike)recordStructLike), expectedWrapper.set((StructLike)rowDataStructLike));
        }
        Assert.assertFalse((String)"Shouldn't have more record", (boolean)actual.hasNext());
        Assert.assertFalse((String)"Shouldn't have more RowData", (boolean)expected.hasNext());
    }
}

