/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.data.FlinkParquetReaders;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.Test;

public class TestFlinkParquetReader
extends DataTest {
    private static final int NUM_RECORDS = 100;

    @Test
    public void testTwoLevelList() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"arraybytes", (Type)Types.ListType.ofRequired((int)3, (Type)Types.BinaryType.get())), Types.NestedField.optional((int)2, (String)"topbytes", (Type)Types.BinaryType.get())});
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        File testFile = this.temp.newFile();
        Assert.assertTrue((boolean)testFile.delete());
        ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)new Path(testFile.toURI())).withDataModel(GenericData.get()).withSchema(avroSchema).config("parquet.avro.add-list-element-records", "true")).config("parquet.avro.write-old-list-structure", "true")).build();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(avroSchema);
        ArrayList expectedByteList = Lists.newArrayList();
        byte[] expectedByte = new byte[]{0, 1};
        ByteBuffer expectedBinary = ByteBuffer.wrap(expectedByte);
        expectedByteList.add(expectedBinary);
        recordBuilder.set("arraybytes", (Object)expectedByteList);
        recordBuilder.set("topbytes", (Object)expectedBinary);
        GenericData.Record expectedRecord = recordBuilder.build();
        writer.write((Object)expectedRecord);
        writer.close();
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(type -> FlinkParquetReaders.buildReader((Schema)schema, (MessageType)type)).build();){
            CloseableIterator rows = reader.iterator();
            Assert.assertTrue((String)"Should have at least one row", (boolean)rows.hasNext());
            RowData rowData = (RowData)rows.next();
            Assert.assertArrayEquals((byte[])rowData.getArray(0).getBinary(0), (byte[])expectedByte);
            Assert.assertArrayEquals((byte[])rowData.getBinary(1), (byte[])expectedByte);
            Assert.assertFalse((String)"Should not have more than one row", (boolean)rows.hasNext());
        }
    }

    private void writeAndValidate(Iterable<Record> iterable, Schema schema) throws IOException {
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).createWriterFunc(GenericParquetWriter::buildWriter).build();){
            writer.addAll(iterable);
        }
        var5_5 = null;
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(type -> FlinkParquetReaders.buildReader((Schema)schema, (MessageType)type)).build();){
            Iterator<Record> expected = iterable.iterator();
            CloseableIterator rows = reader.iterator();
            RowType rowType = FlinkSchemaUtil.convert((Schema)schema);
            for (int i = 0; i < 100; ++i) {
                Assert.assertTrue((String)"Should have expected number of rows", (boolean)rows.hasNext());
                TestHelpers.assertRowData(schema.asStruct(), (LogicalType)rowType, (StructLike)expected.next(), (RowData)rows.next());
            }
            Assert.assertFalse((String)"Should not have extra rows", (boolean)rows.hasNext());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    protected void writeAndValidate(Schema schema) throws IOException {
        this.writeAndValidate(RandomGenericData.generate((Schema)schema, (int)100, (long)19981L), schema);
        this.writeAndValidate(RandomGenericData.generateDictionaryEncodableRecords((Schema)schema, (int)100, (long)21124L), schema);
        this.writeAndValidate(RandomGenericData.generateFallbackRecords((Schema)schema, (int)100, (long)21124L, (long)5L), schema);
    }
}

