/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.BucketUtil;

final class TestBucketPartitionerUtil {
    private TestBucketPartitionerUtil() {
    }

    static List<RowData> generateRowsForBucketIdRange(int numRowsPerBucket, int numBuckets) {
        ArrayList rows = Lists.newArrayListWithCapacity((int)(numBuckets * numRowsPerBucket));
        for (int i = 0; i < numRowsPerBucket; ++i) {
            for (int bucketId = 0; bucketId < numBuckets; ++bucketId) {
                String value = TestBucketPartitionerUtil.generateValueForBucketId(bucketId, numBuckets);
                rows.add(GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)value)}));
            }
        }
        return rows;
    }

    private static String generateValueForBucketId(int bucketId, int numBuckets) {
        String uuid;
        while (TestBucketPartitionerUtil.computeBucketId(numBuckets, uuid = UUID.randomUUID().toString()) != bucketId) {
        }
        return uuid;
    }

    static int computeBucketId(int numBuckets, String value) {
        return (BucketUtil.hash((CharSequence)value) & Integer.MAX_VALUE) % numBuckets;
    }

    static enum TableSchemaType {
        ONE_BUCKET{

            @Override
            public int bucketPartitionColumnPosition() {
                return 0;
            }

            @Override
            public PartitionSpec getPartitionSpec(int numBuckets) {
                return PartitionSpec.builderFor((Schema)SimpleDataUtil.SCHEMA).bucket("data", numBuckets).build();
            }
        }
        ,
        IDENTITY_AND_BUCKET{

            @Override
            public int bucketPartitionColumnPosition() {
                return 1;
            }

            @Override
            public PartitionSpec getPartitionSpec(int numBuckets) {
                return PartitionSpec.builderFor((Schema)SimpleDataUtil.SCHEMA).identity("id").bucket("data", numBuckets).build();
            }
        }
        ,
        TWO_BUCKETS{

            @Override
            public int bucketPartitionColumnPosition() {
                return 1;
            }

            @Override
            public PartitionSpec getPartitionSpec(int numBuckets) {
                return PartitionSpec.builderFor((Schema)SimpleDataUtil.SCHEMA).bucket("id", numBuckets).bucket("data", numBuckets).build();
            }
        };


        public abstract int bucketPartitionColumnPosition();

        public abstract PartitionSpec getPartitionSpec(int var1);
    }
}

