/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.sink.RowDataTaskWriterFactory;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDeltaTaskWriter
extends TableTestBase {
    private static final int FORMAT_V2 = 2;
    private final FileFormat format;

    @Parameterized.Parameters(name="FileFormat = {0}")
    public static Object[][] parameters() {
        return new Object[][]{{"avro"}, {"orc"}, {"parquet"}};
    }

    public TestDeltaTaskWriter(String fileFormat) {
        super(2);
        this.format = FileFormat.fromString((String)fileFormat);
    }

    @Before
    public void setupTable() throws IOException {
        this.tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)this.tableDir.delete());
        this.metadataDir = new File(this.tableDir, "metadata");
    }

    private int idFieldId() {
        return this.table.schema().findField("id").fieldId();
    }

    private int dataFieldId() {
        return this.table.schema().findField("data").fieldId();
    }

    private void testCdcEvents(boolean partitioned) throws IOException {
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId()});
        TaskWriterFactory<RowData> taskWriterFactory = this.createTaskWriterFactory(equalityFieldIds);
        taskWriterFactory.initialize(1, 1);
        TaskWriter writer = taskWriterFactory.create();
        writer.write((Object)SimpleDataUtil.createInsert(1, "aaa"));
        writer.write((Object)SimpleDataUtil.createInsert(2, "bbb"));
        writer.write((Object)SimpleDataUtil.createInsert(3, "ccc"));
        writer.write((Object)SimpleDataUtil.createUpdateBefore(2, "bbb"));
        writer.write((Object)SimpleDataUtil.createUpdateAfter(2, "ddd"));
        writer.write((Object)SimpleDataUtil.createUpdateBefore(1, "aaa"));
        writer.write((Object)SimpleDataUtil.createUpdateAfter(1, "eee"));
        writer.write((Object)SimpleDataUtil.createInsert(4, "fff"));
        writer.write((Object)SimpleDataUtil.createInsert(5, "ggg"));
        writer.write((Object)SimpleDataUtil.createDelete(3, "ccc"));
        WriteResult result = writer.complete();
        Assert.assertEquals((long)(partitioned ? 7L : 1L), (long)result.dataFiles().length);
        Assert.assertEquals((long)(partitioned ? 3L : 1L), (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records.", (Object)this.expectedRowSet(SimpleDataUtil.createRecord(1, "eee"), SimpleDataUtil.createRecord(2, "ddd"), SimpleDataUtil.createRecord(4, "fff"), SimpleDataUtil.createRecord(5, "ggg")), (Object)this.actualRowSet("*"));
        writer = taskWriterFactory.create();
        writer.write((Object)SimpleDataUtil.createUpdateBefore(2, "ddd"));
        writer.write((Object)SimpleDataUtil.createUpdateAfter(6, "hhh"));
        writer.write((Object)SimpleDataUtil.createUpdateBefore(5, "ggg"));
        writer.write((Object)SimpleDataUtil.createUpdateAfter(5, "iii"));
        writer.write((Object)SimpleDataUtil.createDelete(4, "fff"));
        result = writer.complete();
        Assert.assertEquals((long)(partitioned ? 2L : 1L), (long)result.dataFiles().length);
        Assert.assertEquals((long)(partitioned ? 3L : 1L), (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet(SimpleDataUtil.createRecord(1, "eee"), SimpleDataUtil.createRecord(5, "iii"), SimpleDataUtil.createRecord(6, "hhh")), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testUnpartitioned() throws IOException {
        this.createAndInitTable(false);
        this.testCdcEvents(false);
    }

    @Test
    public void testPartitioned() throws IOException {
        this.createAndInitTable(true);
        this.testCdcEvents(true);
    }

    private void testWritePureEqDeletes(boolean partitioned) throws IOException {
        this.createAndInitTable(partitioned);
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId()});
        TaskWriterFactory<RowData> taskWriterFactory = this.createTaskWriterFactory(equalityFieldIds);
        taskWriterFactory.initialize(1, 1);
        TaskWriter writer = taskWriterFactory.create();
        writer.write((Object)SimpleDataUtil.createDelete(1, "aaa"));
        writer.write((Object)SimpleDataUtil.createDelete(2, "bbb"));
        writer.write((Object)SimpleDataUtil.createDelete(3, "ccc"));
        WriteResult result = writer.complete();
        Assert.assertEquals((long)0L, (long)result.dataFiles().length);
        Assert.assertEquals((long)(partitioned ? 3L : 1L), (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have no record", (Object)this.expectedRowSet(new Record[0]), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testUnpartitionedPureEqDeletes() throws IOException {
        this.testWritePureEqDeletes(false);
    }

    @Test
    public void testPartitionedPureEqDeletes() throws IOException {
        this.testWritePureEqDeletes(true);
    }

    private void testAbort(boolean partitioned) throws IOException {
        this.createAndInitTable(partitioned);
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId()});
        TaskWriterFactory<RowData> taskWriterFactory = this.createTaskWriterFactory(equalityFieldIds);
        taskWriterFactory.initialize(1, 1);
        TaskWriter writer = taskWriterFactory.create();
        for (int i = 0; i < 8000; i += 2) {
            writer.write((Object)SimpleDataUtil.createUpdateBefore(i + 1, "aaa"));
            writer.write((Object)SimpleDataUtil.createUpdateAfter(i + 1, "aaa"));
            writer.write((Object)SimpleDataUtil.createUpdateBefore(i + 2, "bbb"));
            writer.write((Object)SimpleDataUtil.createUpdateAfter(i + 2, "bbb"));
        }
        List files = Files.walk(Paths.get(this.tableDir.getPath(), "data"), new FileVisitOption[0]).filter(p -> p.toFile().isFile()).filter(p -> !p.toString().endsWith(".crc")).collect(Collectors.toList());
        Assert.assertEquals((String)("Should have expected file count, but files are: " + files), (long)(partitioned ? 4L : 2L), (long)files.size());
        writer.abort();
        for (Path file : files) {
            Assert.assertFalse((boolean)Files.exists(file, new LinkOption[0]));
        }
    }

    @Test
    public void testUnpartitionedAbort() throws IOException {
        this.testAbort(false);
    }

    @Test
    public void testPartitionedAbort() throws IOException {
        this.testAbort(true);
    }

    @Test
    public void testPartitionedTableWithDataAsKey() throws IOException {
        this.createAndInitTable(true);
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{this.dataFieldId()});
        TaskWriterFactory<RowData> taskWriterFactory = this.createTaskWriterFactory(equalityFieldIds);
        taskWriterFactory.initialize(1, 1);
        TaskWriter writer = taskWriterFactory.create();
        writer.write((Object)SimpleDataUtil.createInsert(1, "aaa"));
        writer.write((Object)SimpleDataUtil.createInsert(2, "aaa"));
        writer.write((Object)SimpleDataUtil.createInsert(3, "bbb"));
        writer.write((Object)SimpleDataUtil.createInsert(4, "ccc"));
        WriteResult result = writer.complete();
        Assert.assertEquals((long)3L, (long)result.dataFiles().length);
        Assert.assertEquals((long)1L, (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet(SimpleDataUtil.createRecord(2, "aaa"), SimpleDataUtil.createRecord(3, "bbb"), SimpleDataUtil.createRecord(4, "ccc")), (Object)this.actualRowSet("*"));
        writer = taskWriterFactory.create();
        writer.write((Object)SimpleDataUtil.createInsert(5, "aaa"));
        writer.write((Object)SimpleDataUtil.createInsert(6, "bbb"));
        writer.write((Object)SimpleDataUtil.createDelete(7, "ccc"));
        result = writer.complete();
        Assert.assertEquals((long)2L, (long)result.dataFiles().length);
        Assert.assertEquals((long)1L, (long)result.deleteFiles().length);
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet(SimpleDataUtil.createRecord(2, "aaa"), SimpleDataUtil.createRecord(5, "aaa"), SimpleDataUtil.createRecord(3, "bbb"), SimpleDataUtil.createRecord(6, "bbb")), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testPartitionedTableWithDataAndIdAsKey() throws IOException {
        this.createAndInitTable(true);
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{this.dataFieldId(), this.idFieldId()});
        TaskWriterFactory<RowData> taskWriterFactory = this.createTaskWriterFactory(equalityFieldIds);
        taskWriterFactory.initialize(1, 1);
        TaskWriter writer = taskWriterFactory.create();
        writer.write((Object)SimpleDataUtil.createInsert(1, "aaa"));
        writer.write((Object)SimpleDataUtil.createInsert(2, "aaa"));
        writer.write((Object)SimpleDataUtil.createDelete(2, "aaa"));
        WriteResult result = writer.complete();
        Assert.assertEquals((long)1L, (long)result.dataFiles().length);
        Assert.assertEquals((long)1L, (long)result.deleteFiles().length);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new FileContent[]{FileContent.POSITION_DELETES}), (Object)Sets.newHashSet((Object[])new FileContent[]{result.deleteFiles()[0].content()}));
        this.commitTransaction(result);
        Assert.assertEquals((String)"Should have expected records", (Object)this.expectedRowSet(SimpleDataUtil.createRecord(1, "aaa")), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testEqualityColumnOnCustomPrecisionTSColumn() throws IOException {
        Schema tableSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)4, (String)"ts", (Type)Types.TimestampType.withZone())});
        RowType flinkType = new RowType(false, (List)ImmutableList.of((Object)new RowType.RowField("id", (LogicalType)new IntType()), (Object)new RowType.RowField("ts", (LogicalType)new LocalZonedTimestampType(3))));
        this.table = this.create(tableSchema, PartitionSpec.unpartitioned());
        this.initTable(this.table);
        ImmutableList equalityIds = ImmutableList.of((Object)this.table.schema().findField("ts").fieldId());
        TaskWriterFactory<RowData> taskWriterFactory = this.createTaskWriterFactory(flinkType, (List<Integer>)equalityIds);
        taskWriterFactory.initialize(1, 1);
        TaskWriter writer = taskWriterFactory.create();
        RowDataSerializer serializer = new RowDataSerializer(flinkType);
        OffsetDateTime start = OffsetDateTime.now();
        writer.write((Object)serializer.toBinaryRow((RowData)GenericRowData.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, TimestampData.fromInstant((Instant)start.toInstant())})));
        writer.write((Object)serializer.toBinaryRow((RowData)GenericRowData.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2, TimestampData.fromInstant((Instant)start.plusSeconds(1L).toInstant())})));
        writer.write((Object)serializer.toBinaryRow((RowData)GenericRowData.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{2, TimestampData.fromInstant((Instant)start.plusSeconds(1L).toInstant())})));
        WriteResult result = writer.complete();
        Assertions.assertThat((int)result.dataFiles().length).isEqualTo(1);
        Assertions.assertThat((int)result.deleteFiles().length).isEqualTo(2);
        Assertions.assertThat((Collection)Arrays.stream(result.deleteFiles()).map(ContentFile::content).collect(Collectors.toSet())).isEqualTo((Object)Sets.newHashSet((Object[])new FileContent[]{FileContent.POSITION_DELETES, FileContent.EQUALITY_DELETES}));
        this.commitTransaction(result);
        GenericRecord expectedRecord = GenericRecord.create((Schema)tableSchema);
        expectedRecord.setField("id", (Object)1);
        int cutPrecisionNano = start.getNano() / 1000000 * 1000000;
        expectedRecord.setField("ts", (Object)start.withNano(cutPrecisionNano));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.expectedRowSet(new Record[]{expectedRecord}));
    }

    private void commitTransaction(WriteResult result) {
        RowDelta rowDelta = this.table.newRowDelta();
        Arrays.stream(result.dataFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        Arrays.stream(result.deleteFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.validateDeletedFiles().validateDataFilesExist((Iterable)Lists.newArrayList((Object[])result.referencedDataFiles())).commit();
    }

    private StructLikeSet expectedRowSet(Record ... records) {
        return SimpleDataUtil.expectedRowSet((Table)this.table, records);
    }

    private StructLikeSet actualRowSet(String ... columns) throws IOException {
        return SimpleDataUtil.actualRowSet((Table)this.table, columns);
    }

    private TaskWriterFactory<RowData> createTaskWriterFactory(List<Integer> equalityFieldIds) {
        return new RowDataTaskWriterFactory(SerializableTable.copyOf((Table)this.table), FlinkSchemaUtil.convert((Schema)this.table.schema()), 0x8000000L, this.format, this.table.properties(), equalityFieldIds, false);
    }

    private TaskWriterFactory<RowData> createTaskWriterFactory(RowType flinkType, List<Integer> equalityFieldIds) {
        return new RowDataTaskWriterFactory(SerializableTable.copyOf((Table)this.table), flinkType, 0x8000000L, this.format, this.table.properties(), equalityFieldIds, true);
    }

    private void createAndInitTable(boolean partitioned) {
        this.table = partitioned ? this.create(SCHEMA, PartitionSpec.builderFor((Schema)SCHEMA).identity("data").build()) : this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.initTable(this.table);
    }

    private void initTable(TestTables.TestTable testTable) {
        testTable.updateProperties().set("write.parquet.row-group-size-bytes", String.valueOf(8192)).defaultFormat(this.format).commit();
    }
}

