/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.sink.FlinkAppenderFactory;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.TestAppenderFactory;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.StructLikeSet;

public class TestFlinkAppenderFactory
extends TestAppenderFactory<RowData> {
    private final RowType rowType = FlinkSchemaUtil.convert((Schema)SCHEMA);

    public TestFlinkAppenderFactory(String fileFormat, boolean partitioned) {
        super(fileFormat, partitioned);
    }

    protected FileAppenderFactory<RowData> createAppenderFactory(List<Integer> equalityFieldIds, Schema eqDeleteSchema, Schema posDeleteRowSchema) {
        return new FlinkAppenderFactory((Table)this.table, this.table.schema(), this.rowType, this.table.properties(), this.table.spec(), ArrayUtil.toIntArray(equalityFieldIds), eqDeleteSchema, posDeleteRowSchema);
    }

    protected RowData createRow(Integer id, String data) {
        return SimpleDataUtil.createRowData(id, data);
    }

    protected StructLikeSet expectedRowSet(Iterable<RowData> rows) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        for (RowData row : rows) {
            RowDataWrapper wrapper = new RowDataWrapper(this.rowType, this.table.schema().asStruct());
            set.add((StructLike)wrapper.wrap(row));
        }
        return set;
    }
}

