/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.types.Row;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.flink.HadoopCatalogResource;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.sink.FlinkSink;
import org.apache.iceberg.flink.sink.TestFlinkIcebergSinkBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFlinkIcebergSinkBranch
extends TestFlinkIcebergSinkBase {
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = MiniClusterResource.createWithClassloaderCheckDisabled();
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    @Rule
    public final HadoopCatalogResource catalogResource = new HadoopCatalogResource(TEMPORARY_FOLDER, "default", "t");
    private final String branch;
    private TableLoader tableLoader;

    @Parameterized.Parameters(name="formatVersion = {0}, branch = {1}")
    public static Object[] parameters() {
        return new Object[]{"main", "testBranch"};
    }

    public TestFlinkIcebergSinkBranch(String branch) {
        this.branch = branch;
    }

    @Before
    public void before() throws IOException {
        this.table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, SimpleDataUtil.SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)FileFormat.AVRO.name(), (Object)"format-version", (Object)"1"));
        this.env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)MiniClusterResource.DISABLE_CLASSLOADER_CHECK_CONFIG).enableCheckpointing(100L);
        this.tableLoader = this.catalogResource.tableLoader();
    }

    @Test
    public void testWriteRowWithTableSchema() throws Exception {
        this.testWriteRow(SimpleDataUtil.FLINK_SCHEMA, DistributionMode.NONE);
        this.verifyOtherBranchUnmodified();
    }

    private void testWriteRow(TableSchema tableSchema, DistributionMode distributionMode) throws Exception {
        List<Row> rows = this.createRows("");
        DataStreamSource dataStream = this.env.addSource(this.createBoundedSource(rows), ROW_TYPE_INFO);
        FlinkSink.forRow((DataStream)dataStream, (TableSchema)SimpleDataUtil.FLINK_SCHEMA).table(this.table).tableLoader(this.tableLoader).tableSchema(tableSchema).toBranch(this.branch).distributionMode(distributionMode).append();
        this.env.execute("Test Iceberg DataStream.");
        SimpleDataUtil.assertTableRows(this.table, this.convertToRowData(rows), this.branch);
        SimpleDataUtil.assertTableRows(this.table, (List<RowData>)ImmutableList.of(), this.branch.equals("main") ? "test-branch" : "main");
        this.verifyOtherBranchUnmodified();
    }

    private void verifyOtherBranchUnmodified() {
        String otherBranch;
        String string = otherBranch = this.branch.equals("main") ? "test-branch" : "main";
        if (otherBranch.equals("main")) {
            Assert.assertNull((Object)this.table.currentSnapshot());
        }
        Assert.assertTrue((this.table.snapshot(otherBranch) == null ? 1 : 0) != 0);
    }
}

