/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.data.RandomRowData;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestRowDataPartitionKey {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"boolType", (Type)Types.BooleanType.get()), Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"longType", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"dateType", (Type)Types.DateType.get()), Types.NestedField.required((int)4, (String)"timeType", (Type)Types.TimeType.get()), Types.NestedField.required((int)5, (String)"stringType", (Type)Types.StringType.get()), Types.NestedField.required((int)6, (String)"timestampWithoutZone", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)7, (String)"timestampWithZone", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)8, (String)"fixedType", (Type)Types.FixedType.ofLength((int)5)), Types.NestedField.required((int)9, (String)"uuidType", (Type)Types.UUIDType.get()), Types.NestedField.required((int)10, (String)"binaryType", (Type)Types.BinaryType.get()), Types.NestedField.required((int)11, (String)"decimalType1", (Type)Types.DecimalType.of((int)18, (int)3)), Types.NestedField.required((int)12, (String)"decimalType2", (Type)Types.DecimalType.of((int)10, (int)5)), Types.NestedField.required((int)13, (String)"decimalType3", (Type)Types.DecimalType.of((int)38, (int)19)), Types.NestedField.required((int)14, (String)"floatType", (Type)Types.FloatType.get()), Types.NestedField.required((int)15, (String)"doubleType", (Type)Types.DoubleType.get())});
    private static final List<String> SUPPORTED_PRIMITIVES = SCHEMA.asStruct().fields().stream().map(Types.NestedField::name).collect(Collectors.toList());
    private static final Schema NESTED_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"structType", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"innerStringType", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"innerIntegerType", (Type)Types.IntegerType.get())}))});

    @Test
    public void testNullPartitionValue() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)schema).identity("data").build();
        ArrayList rows = Lists.newArrayList((Object[])new RowData[]{GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"a")}), GenericRowData.of((Object[])new Object[]{2, StringData.fromString((String)"b")}), GenericRowData.of((Object[])new Object[]{3, null})});
        RowDataWrapper rowWrapper = new RowDataWrapper(FlinkSchemaUtil.convert((Schema)schema), schema.asStruct());
        for (RowData row : rows) {
            PartitionKey partitionKey = new PartitionKey(spec, schema);
            partitionKey.partition((StructLike)rowWrapper.wrap(row));
            Assert.assertEquals((long)partitionKey.size(), (long)1L);
            String expectedStr = row.isNullAt(1) ? null : row.getString(1).toString();
            Assert.assertEquals((Object)expectedStr, (Object)partitionKey.get(0, String.class));
        }
    }

    @Test
    public void testPartitionWithOneNestedField() {
        RowDataWrapper rowWrapper = new RowDataWrapper(FlinkSchemaUtil.convert((Schema)NESTED_SCHEMA), NESTED_SCHEMA.asStruct());
        List records = RandomGenericData.generate((Schema)NESTED_SCHEMA, (int)10, (long)1991L);
        ArrayList rows = Lists.newArrayList(RandomRowData.convert(NESTED_SCHEMA, records));
        PartitionSpec spec1 = PartitionSpec.builderFor((Schema)NESTED_SCHEMA).identity("structType.innerStringType").build();
        PartitionSpec spec2 = PartitionSpec.builderFor((Schema)NESTED_SCHEMA).identity("structType.innerIntegerType").build();
        for (int i = 0; i < rows.size(); ++i) {
            RowData row = (RowData)rows.get(i);
            Record record = (Record)((Record)records.get(i)).get(0);
            PartitionKey partitionKey1 = new PartitionKey(spec1, NESTED_SCHEMA);
            partitionKey1.partition((StructLike)rowWrapper.wrap(row));
            Assert.assertEquals((long)partitionKey1.size(), (long)1L);
            Assert.assertEquals((Object)record.get(0), (Object)partitionKey1.get(0, String.class));
            PartitionKey partitionKey2 = new PartitionKey(spec2, NESTED_SCHEMA);
            partitionKey2.partition((StructLike)rowWrapper.wrap(row));
            Assert.assertEquals((long)partitionKey2.size(), (long)1L);
            Assert.assertEquals((Object)record.get(1), (Object)partitionKey2.get(0, Integer.class));
        }
    }

    @Test
    public void testPartitionMultipleNestedField() {
        RowDataWrapper rowWrapper = new RowDataWrapper(FlinkSchemaUtil.convert((Schema)NESTED_SCHEMA), NESTED_SCHEMA.asStruct());
        List records = RandomGenericData.generate((Schema)NESTED_SCHEMA, (int)10, (long)1992L);
        ArrayList rows = Lists.newArrayList(RandomRowData.convert(NESTED_SCHEMA, records));
        PartitionSpec spec1 = PartitionSpec.builderFor((Schema)NESTED_SCHEMA).identity("structType.innerIntegerType").identity("structType.innerStringType").build();
        PartitionSpec spec2 = PartitionSpec.builderFor((Schema)NESTED_SCHEMA).identity("structType.innerStringType").identity("structType.innerIntegerType").build();
        PartitionKey pk1 = new PartitionKey(spec1, NESTED_SCHEMA);
        PartitionKey pk2 = new PartitionKey(spec2, NESTED_SCHEMA);
        for (int i = 0; i < rows.size(); ++i) {
            RowData row = (RowData)rows.get(i);
            Record record = (Record)((Record)records.get(i)).get(0);
            pk1.partition((StructLike)rowWrapper.wrap(row));
            Assert.assertEquals((long)2L, (long)pk1.size());
            Assert.assertEquals((Object)record.get(1), (Object)pk1.get(0, Integer.class));
            Assert.assertEquals((Object)record.get(0), (Object)pk1.get(1, String.class));
            pk2.partition((StructLike)rowWrapper.wrap(row));
            Assert.assertEquals((long)2L, (long)pk2.size());
            Assert.assertEquals((Object)record.get(0), (Object)pk2.get(0, String.class));
            Assert.assertEquals((Object)record.get(1), (Object)pk2.get(1, Integer.class));
        }
    }

    @Test
    public void testPartitionValueTypes() {
        RowType rowType = FlinkSchemaUtil.convert((Schema)SCHEMA);
        RowDataWrapper rowWrapper = new RowDataWrapper(rowType, SCHEMA.asStruct());
        InternalRecordWrapper recordWrapper = new InternalRecordWrapper(SCHEMA.asStruct());
        List records = RandomGenericData.generate((Schema)SCHEMA, (int)10, (long)1993L);
        ArrayList rows = Lists.newArrayList(RandomRowData.convert(SCHEMA, records));
        for (String column : SUPPORTED_PRIMITIVES) {
            PartitionSpec spec = PartitionSpec.builderFor((Schema)SCHEMA).identity(column).build();
            Class[] javaClasses = spec.javaClasses();
            PartitionKey pk = new PartitionKey(spec, SCHEMA);
            PartitionKey expectedPK = new PartitionKey(spec, SCHEMA);
            for (int j = 0; j < rows.size(); ++j) {
                RowData row = (RowData)rows.get(j);
                Record record = (Record)records.get(j);
                pk.partition((StructLike)rowWrapper.wrap(row));
                expectedPK.partition((StructLike)recordWrapper.wrap((StructLike)record));
                Assert.assertEquals((String)("Partition with column " + column + " should have one field."), (long)1L, (long)pk.size());
                if (column.equals("timeType")) {
                    Assert.assertEquals((String)("Partition with column " + column + " should have the expected values"), (long)((Long)expectedPK.get(0, Long.class) / 1000L), (long)((Long)pk.get(0, Long.class) / 1000L));
                    continue;
                }
                Assert.assertEquals((String)("Partition with column " + column + " should have the expected values"), (Object)expectedPK.get(0, javaClasses[0]), (Object)pk.get(0, javaClasses[0]));
            }
        }
    }

    @Test
    public void testNestedPartitionValues() {
        Schema nestedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1001, (String)"nested", (Type)SCHEMA.asStruct())});
        RowType rowType = FlinkSchemaUtil.convert((Schema)nestedSchema);
        RowDataWrapper rowWrapper = new RowDataWrapper(rowType, nestedSchema.asStruct());
        InternalRecordWrapper recordWrapper = new InternalRecordWrapper(nestedSchema.asStruct());
        List records = RandomGenericData.generate((Schema)nestedSchema, (int)10, (long)1994L);
        ArrayList rows = Lists.newArrayList(RandomRowData.convert(nestedSchema, records));
        for (String supportedPrimitive : SUPPORTED_PRIMITIVES) {
            String column = String.format("nested.%s", supportedPrimitive);
            PartitionSpec spec = PartitionSpec.builderFor((Schema)nestedSchema).identity(column).build();
            Class[] javaClasses = spec.javaClasses();
            PartitionKey pk = new PartitionKey(spec, nestedSchema);
            PartitionKey expectedPK = new PartitionKey(spec, nestedSchema);
            for (int j = 0; j < rows.size(); ++j) {
                pk.partition((StructLike)rowWrapper.wrap((RowData)rows.get(j)));
                expectedPK.partition((StructLike)recordWrapper.wrap((StructLike)records.get(j)));
                Assert.assertEquals((String)("Partition with nested column " + column + " should have one field."), (long)1L, (long)pk.size());
                if (column.equals("nested.timeType")) {
                    Assert.assertEquals((String)("Partition with nested column " + column + " should have the expected values."), (long)((Long)expectedPK.get(0, Long.class) / 1000L), (long)((Long)pk.get(0, Long.class) / 1000L));
                    continue;
                }
                Assert.assertEquals((String)("Partition with nested column " + column + " should have the expected values."), (Object)expectedPK.get(0, javaClasses[0]), (Object)pk.get(0, javaClasses[0]));
            }
        }
    }
}

