/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.data.RandomRowData;
import org.apache.iceberg.flink.sink.RowDataTaskWriterFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTaskWriters {
    private static final Configuration CONF = new Configuration();
    private static final long TARGET_FILE_SIZE = 0x8000000L;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private final FileFormat format;
    private final boolean partitioned;
    private Table table;

    @Parameterized.Parameters(name="format = {0}, partitioned = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{"avro", true}, {"avro", false}, {"orc", true}, {"orc", false}, {"parquet", true}, {"parquet", false}};
    }

    public TestTaskWriters(String format, boolean partitioned) {
        this.format = FileFormat.fromString((String)format);
        this.partitioned = partitioned;
    }

    @Before
    public void before() throws IOException {
        File folder = this.tempFolder.newFolder();
        ImmutableMap props = ImmutableMap.of((Object)"write.format.default", (Object)this.format.name());
        this.table = SimpleDataUtil.createTable(folder.getAbsolutePath(), (Map<String, String>)props, this.partitioned);
    }

    @Test
    public void testWriteZeroRecord() throws IOException {
        try (TaskWriter<RowData> taskWriter = this.createTaskWriter(0x8000000L);){
            taskWriter.close();
            DataFile[] dataFiles = taskWriter.dataFiles();
            Assert.assertNotNull((Object)dataFiles);
            Assert.assertEquals((long)0L, (long)dataFiles.length);
            taskWriter.close();
            dataFiles = taskWriter.dataFiles();
            Assert.assertNotNull((Object)dataFiles);
            Assert.assertEquals((long)0L, (long)dataFiles.length);
        }
    }

    @Test
    public void testCloseTwice() throws IOException {
        try (TaskWriter<RowData> taskWriter = this.createTaskWriter(0x8000000L);){
            taskWriter.write((Object)SimpleDataUtil.createRowData(1, "hello"));
            taskWriter.write((Object)SimpleDataUtil.createRowData(2, "world"));
            taskWriter.close();
            taskWriter.close();
            int expectedFiles = this.partitioned ? 2 : 1;
            DataFile[] dataFiles = taskWriter.dataFiles();
            Assert.assertEquals((long)expectedFiles, (long)dataFiles.length);
            FileSystem fs = FileSystem.get((Configuration)CONF);
            for (DataFile dataFile : dataFiles) {
                Assert.assertTrue((boolean)fs.exists(new Path(dataFile.path().toString())));
            }
        }
    }

    @Test
    public void testAbort() throws IOException {
        try (TaskWriter<RowData> taskWriter = this.createTaskWriter(0x8000000L);){
            taskWriter.write((Object)SimpleDataUtil.createRowData(1, "hello"));
            taskWriter.write((Object)SimpleDataUtil.createRowData(2, "world"));
            taskWriter.abort();
            DataFile[] dataFiles = taskWriter.dataFiles();
            int expectedFiles = this.partitioned ? 2 : 1;
            Assert.assertEquals((long)expectedFiles, (long)dataFiles.length);
            FileSystem fs = FileSystem.get((Configuration)CONF);
            for (DataFile dataFile : dataFiles) {
                Assert.assertFalse((boolean)fs.exists(new Path(dataFile.path().toString())));
            }
        }
    }

    @Test
    public void testCompleteFiles() throws IOException {
        try (TaskWriter<RowData> taskWriter = this.createTaskWriter(0x8000000L);){
            taskWriter.write((Object)SimpleDataUtil.createRowData(1, "a"));
            taskWriter.write((Object)SimpleDataUtil.createRowData(2, "b"));
            taskWriter.write((Object)SimpleDataUtil.createRowData(3, "c"));
            taskWriter.write((Object)SimpleDataUtil.createRowData(4, "d"));
            DataFile[] dataFiles = taskWriter.dataFiles();
            int expectedFiles = this.partitioned ? 4 : 1;
            Assert.assertEquals((long)expectedFiles, (long)dataFiles.length);
            dataFiles = taskWriter.dataFiles();
            Assert.assertEquals((long)expectedFiles, (long)dataFiles.length);
            FileSystem fs = FileSystem.get((Configuration)CONF);
            for (DataFile dataFile : dataFiles) {
                Assert.assertTrue((boolean)fs.exists(new Path(dataFile.path().toString())));
            }
            AppendFiles appendFiles = this.table.newAppend();
            for (DataFile dataFile : dataFiles) {
                appendFiles.appendFile(dataFile);
            }
            appendFiles.commit();
            SimpleDataUtil.assertTableRecords(this.table, (List<Record>)Lists.newArrayList((Object[])new Record[]{SimpleDataUtil.createRecord(1, "a"), SimpleDataUtil.createRecord(2, "b"), SimpleDataUtil.createRecord(3, "c"), SimpleDataUtil.createRecord(4, "d")}));
        }
    }

    @Test
    public void testRollingWithTargetFileSize() throws IOException {
        try (TaskWriter<RowData> taskWriter = this.createTaskWriter(4L);){
            ArrayList rows = Lists.newArrayListWithCapacity((int)8000);
            ArrayList records = Lists.newArrayListWithCapacity((int)8000);
            for (int i = 0; i < 2000; ++i) {
                for (String data : new String[]{"a", "b", "c", "d"}) {
                    rows.add(SimpleDataUtil.createRowData(i, data));
                    records.add(SimpleDataUtil.createRecord(i, data));
                }
            }
            for (RowData row : rows) {
                taskWriter.write((Object)row);
            }
            DataFile[] dataFiles = taskWriter.dataFiles();
            Assert.assertEquals((long)8L, (long)dataFiles.length);
            AppendFiles appendFiles = this.table.newAppend();
            for (DataFile dataFile : dataFiles) {
                appendFiles.appendFile(dataFile);
            }
            appendFiles.commit();
            SimpleDataUtil.assertTableRecords(this.table, (List<Record>)records);
        }
    }

    @Test
    public void testRandomData() throws IOException {
        try (TaskWriter<RowData> taskWriter = this.createTaskWriter(0x8000000L);){
            Iterable<RowData> rows = RandomRowData.generate(SimpleDataUtil.SCHEMA, 100, 1996L);
            for (RowData row : rows) {
                taskWriter.write((Object)row);
            }
            taskWriter.close();
            DataFile[] dataFiles = taskWriter.dataFiles();
            AppendFiles appendFiles = this.table.newAppend();
            for (DataFile dataFile : dataFiles) {
                appendFiles.appendFile(dataFile);
            }
            appendFiles.commit();
            SimpleDataUtil.assertTableRows(this.table, Lists.newArrayList(rows));
        }
    }

    private TaskWriter<RowData> createTaskWriter(long targetFileSize) {
        RowDataTaskWriterFactory taskWriterFactory = new RowDataTaskWriterFactory(SerializableTable.copyOf((Table)this.table), (RowType)SimpleDataUtil.FLINK_SCHEMA.toRowDataType().getLogicalType(), targetFileSize, this.format, this.table.properties(), null, false);
        taskWriterFactory.initialize(1, 1);
        return taskWriterFactory.create();
    }
}

