/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatisticsSerializer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestAggregatedStatistics {
    @Test
    public void mergeDataStatisticTest() {
        GenericRowData rowDataA = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"a")});
        GenericRowData rowDataB = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"b")});
        AggregatedStatistics aggregatedStatistics = new AggregatedStatistics(1L, MapDataStatisticsSerializer.fromKeySerializer((TypeSerializer)new RowDataSerializer(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}))));
        MapDataStatistics mapDataStatistics1 = new MapDataStatistics();
        mapDataStatistics1.add((RowData)rowDataA);
        mapDataStatistics1.add((RowData)rowDataA);
        mapDataStatistics1.add((RowData)rowDataB);
        aggregatedStatistics.mergeDataStatistic("testOperator", 1L, (DataStatistics)mapDataStatistics1);
        MapDataStatistics mapDataStatistics2 = new MapDataStatistics();
        mapDataStatistics2.add((RowData)rowDataA);
        aggregatedStatistics.mergeDataStatistic("testOperator", 1L, (DataStatistics)mapDataStatistics2);
        Assertions.assertThat((Long)((Long)((Map)aggregatedStatistics.dataStatistics().statistics()).get(rowDataA))).isEqualTo((Long)mapDataStatistics1.statistics().get(rowDataA) + (Long)mapDataStatistics2.statistics().get(rowDataA));
        Assertions.assertThat((Long)((Long)((Map)aggregatedStatistics.dataStatistics().statistics()).get(rowDataB))).isEqualTo((Long)mapDataStatistics1.statistics().get(rowDataB) + mapDataStatistics2.statistics().getOrDefault(rowDataB, 0L));
    }
}

