/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.source.FlinkSplitPlanner;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.ThreadPools;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;

public class SplitHelpers {
    private SplitHelpers() {
    }

    public static List<IcebergSourceSplit> createSplitsFromTransientHadoopTable(TemporaryFolder temporaryFolder, int fileCount, int filesPerSplit) throws Exception {
        return SplitHelpers.createSplitsFromTransientHadoopTable(temporaryFolder, fileCount, filesPerSplit, "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IcebergSourceSplit> createSplitsFromTransientHadoopTable(TemporaryFolder temporaryFolder, int fileCount, int filesPerSplit, String version) throws Exception {
        File warehouseFile = temporaryFolder.newFolder();
        Assert.assertTrue((boolean)warehouseFile.delete());
        String warehouse = "file:" + warehouseFile;
        Configuration hadoopConf = new Configuration();
        HadoopCatalog catalog = new HadoopCatalog(hadoopConf, warehouse);
        ImmutableMap properties = ImmutableMap.of((Object)"format-version", (Object)version);
        try {
            Table table = catalog.createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA, PartitionSpec.unpartitioned(), null, (Map)properties);
            GenericAppenderHelper dataAppender = new GenericAppenderHelper(table, FileFormat.PARQUET, temporaryFolder);
            for (int i = 0; i < fileCount; ++i) {
                List records = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)i);
                dataAppender.appendToTable(records);
            }
            ScanContext scanContext = ScanContext.builder().build();
            List splits = FlinkSplitPlanner.planIcebergSourceSplits((Table)table, (ScanContext)scanContext, (ExecutorService)ThreadPools.getWorkerPool());
            List<IcebergSourceSplit> list = splits.stream().flatMap(split -> {
                List filesList = Lists.partition((List)Lists.newArrayList((Iterable)split.task().files()), (int)filesPerSplit);
                return filesList.stream().map(files -> new BaseCombinedScanTask(files)).map(combinedScanTask -> IcebergSourceSplit.fromCombinedScanTask((CombinedScanTask)combinedScanTask));
            }).collect(Collectors.toList());
            return list;
        }
        finally {
            catalog.dropTable(TestFixtures.TABLE_IDENTIFIER);
            catalog.close();
        }
    }
}

