/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.types.Row;
import org.apache.iceberg.flink.source.BoundedTableFactory;
import org.apache.iceberg.flink.source.ChangeLogTableTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.junit.Assert;
import org.junit.Test;

public class TestBoundedTableFactory
extends ChangeLogTableTestBase {
    @Test
    public void testEmptyDataSet() {
        String table = this.name.getMethodName();
        ImmutableList emptyDataSet = ImmutableList.of();
        String dataId = BoundedTableFactory.registerDataSet((List<List<Row>>)emptyDataSet);
        this.sql("CREATE TABLE %s(id INT, data STRING) WITH ('connector'='BoundedSource', 'data-id'='%s')", table, dataId);
        Assert.assertEquals((String)"Should have caught empty change log set.", (Object)ImmutableList.of(), this.sql("SELECT * FROM %s", table));
    }

    @Test
    public void testBoundedTableFactory() {
        String table = this.name.getMethodName();
        ImmutableList dataSet = ImmutableList.of((Object)ImmutableList.of((Object)TestBoundedTableFactory.insertRow(1, "aaa"), (Object)TestBoundedTableFactory.deleteRow(1, "aaa"), (Object)TestBoundedTableFactory.insertRow(1, "bbb"), (Object)TestBoundedTableFactory.insertRow(2, "aaa"), (Object)TestBoundedTableFactory.deleteRow(2, "aaa"), (Object)TestBoundedTableFactory.insertRow(2, "bbb")), (Object)ImmutableList.of((Object)TestBoundedTableFactory.updateBeforeRow(2, "bbb"), (Object)TestBoundedTableFactory.updateAfterRow(2, "ccc"), (Object)TestBoundedTableFactory.deleteRow(2, "ccc"), (Object)TestBoundedTableFactory.insertRow(2, "ddd")), (Object)ImmutableList.of((Object)TestBoundedTableFactory.deleteRow(1, "bbb"), (Object)TestBoundedTableFactory.insertRow(1, "ccc"), (Object)TestBoundedTableFactory.deleteRow(1, "ccc"), (Object)TestBoundedTableFactory.insertRow(1, "ddd")));
        String dataId = BoundedTableFactory.registerDataSet((List<List<Row>>)dataSet);
        this.sql("CREATE TABLE %s(id INT, data STRING) WITH ('connector'='BoundedSource', 'data-id'='%s')", table, dataId);
        List rowSet = dataSet.stream().flatMap(Streams::stream).collect(Collectors.toList());
        Assert.assertEquals((String)"Should have the expected change log events.", rowSet, this.sql("SELECT * FROM %s", table));
        Assert.assertEquals((String)"Should have the expected change log events", rowSet.stream().filter(r -> Objects.equals(r.getField(1), "aaa")).collect(Collectors.toList()), this.sql("SELECT * FROM %s WHERE data='aaa'", table));
    }
}

