/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.source.FlinkInputFormat;
import org.apache.iceberg.flink.source.FlinkSource;
import org.apache.iceberg.flink.source.TestFlinkSource;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.Assume;
import org.junit.Test;

public class TestFlinkInputFormat
extends TestFlinkSource {
    public TestFlinkInputFormat(String fileFormat) {
        super(fileFormat);
    }

    @Override
    protected List<Row> run(FlinkSource.Builder formatBuilder, Map<String, String> sqlOptions, String sqlFilter, String ... sqlSelectedFields) throws Exception {
        return this.runFormat(formatBuilder.tableLoader(this.tableLoader()).buildFormat());
    }

    @Test
    public void testNestedProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)2, (String)"nested", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"f1", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"f2", (Type)Types.StringType.get()), Types.NestedField.required((int)5, (String)"f3", (Type)Types.LongType.get())})), Types.NestedField.required((int)6, (String)"id", (Type)Types.LongType.get())});
        Table table = this.catalogResource.catalog().createTable(TableIdentifier.of((String[])new String[]{"default", "t"}), schema);
        List writeRecords = RandomGenericData.generate((Schema)schema, (int)2, (long)0L);
        new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER).appendToTable(writeRecords);
        TableSchema projectedSchema = TableSchema.builder().field("nested", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f2", (DataType)DataTypes.STRING())})).field("data", DataTypes.STRING()).build();
        List<Row> result = this.runFormat(FlinkSource.forRowData().tableLoader(this.tableLoader()).project(projectedSchema).buildFormat());
        ArrayList expected = Lists.newArrayList();
        for (Record record : writeRecords) {
            Row nested = Row.of((Object[])new Object[]{((Record)record.get(1)).get(1)});
            expected.add(Row.of((Object[])new Object[]{nested, record.get(0)}));
        }
        TestHelpers.assertRows(result, expected);
    }

    @Test
    public void testBasicProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"time", (Type)Types.TimestampType.withZone())});
        Table table = this.catalogResource.catalog().createTable(TableIdentifier.of((String[])new String[]{"default", "t"}), writeSchema);
        List writeRecords = RandomGenericData.generate((Schema)writeSchema, (int)2, (long)0L);
        new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER).appendToTable(writeRecords);
        TableSchema projectedSchema = TableSchema.builder().field("id", DataTypes.BIGINT()).field("data", DataTypes.STRING()).build();
        List<Row> result = this.runFormat(FlinkSource.forRowData().tableLoader(this.tableLoader()).project(projectedSchema).buildFormat());
        ArrayList expected = Lists.newArrayList();
        for (Record record : writeRecords) {
            expected.add(Row.of((Object[])new Object[]{record.get(0), record.get(1)}));
        }
        TestHelpers.assertRows(result, expected);
    }

    @Test
    public void testReadPartitionColumn() throws Exception {
        Assume.assumeTrue((String)"Temporary skip ORC", (FileFormat.ORC != this.fileFormat ? 1 : 0) != 0);
        Schema nestedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"struct", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"innerId", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"innerName", (Type)Types.StringType.get())}))});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)nestedSchema).identity("struct.innerName").build();
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, nestedSchema, spec);
        List records = RandomGenericData.generate((Schema)nestedSchema, (int)10, (long)0L);
        GenericAppenderHelper appender = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        for (Record record : records) {
            TestHelpers.Row partition = TestHelpers.Row.of((Object[])new Object[]{((Record)record.get(1, Record.class)).get(1)});
            appender.appendToTable((StructLike)partition, Collections.singletonList(record));
        }
        TableSchema projectedSchema = TableSchema.builder().field("struct", DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"innerName", (DataType)DataTypes.STRING())})).build();
        List<Row> result = this.runFormat(FlinkSource.forRowData().tableLoader(this.tableLoader()).project(projectedSchema).buildFormat());
        ArrayList expected = Lists.newArrayList();
        for (Record record : records) {
            Row nested = Row.of((Object[])new Object[]{((Record)record.get(1)).get(1)});
            expected.add(Row.of((Object[])new Object[]{nested}));
        }
        TestHelpers.assertRows(result, expected);
    }

    private List<Row> runFormat(FlinkInputFormat inputFormat) throws IOException {
        RowType rowType = FlinkSchemaUtil.convert((Schema)inputFormat.projectedSchema());
        return TestHelpers.readRows(inputFormat, rowType);
    }
}

