/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.source.FlinkInputFormat;
import org.apache.iceberg.flink.source.FlinkSource;
import org.apache.iceberg.flink.source.TestFlinkReaderDeletesBase;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;

public class TestFlinkInputFormatReaderDeletes
extends TestFlinkReaderDeletesBase {
    public TestFlinkInputFormatReaderDeletes(FileFormat inputFormat) {
        super(inputFormat);
    }

    protected StructLikeSet rowSet(String tableName, Table testTable, String ... columns) throws IOException {
        Schema projected = testTable.schema().select(columns);
        RowType rowType = FlinkSchemaUtil.convert((Schema)projected);
        HashMap properties = Maps.newHashMap();
        properties.put("warehouse", hiveConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
        properties.put("uri", hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname));
        properties.put("clients", Integer.toString(hiveConf.getInt("iceberg.hive.client-pool-size", 5)));
        CatalogLoader hiveCatalogLoader = CatalogLoader.hive((String)catalog.name(), (Configuration)hiveConf, (Map)properties);
        FlinkInputFormat inputFormat = FlinkSource.forRowData().tableLoader(TableLoader.fromCatalog((CatalogLoader)hiveCatalogLoader, (TableIdentifier)TableIdentifier.of((String[])new String[]{"default", tableName}))).project(FlinkSchemaUtil.toSchema((RowType)rowType)).buildFormat();
        StructLikeSet set = StructLikeSet.create((Types.StructType)projected.asStruct());
        TestHelpers.readRowData(inputFormat, rowType).forEach(rowData -> {
            RowDataWrapper wrapper = new RowDataWrapper(rowType, projected.asStruct());
            set.add((StructLike)wrapper.wrap(rowData));
        });
        return set;
    }
}

