/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestMergingMetrics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.HadoopTableResource;
import org.apache.iceberg.flink.RowDataConverter;
import org.apache.iceberg.flink.sink.FlinkAppenderFactory;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class TestFlinkMergingMetrics
extends TestMergingMetrics<RowData> {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    @Rule
    public final HadoopTableResource tableResource = new HadoopTableResource(TEMP_FOLDER, "test_db", "test_table", SCHEMA);

    public TestFlinkMergingMetrics(FileFormat fileFormat) {
        super(fileFormat);
    }

    protected FileAppender<RowData> writeAndGetAppender(List<Record> records) throws IOException {
        FileAppender appender;
        RowType flinkSchema = FlinkSchemaUtil.convert((Schema)SCHEMA);
        try (FileAppender fileAppender = appender = new FlinkAppenderFactory(this.tableResource.table(), SCHEMA, flinkSchema, (Map)ImmutableMap.of(), PartitionSpec.unpartitioned(), null, null, null).newAppender(Files.localOutput((File)this.temp.newFile()), this.fileFormat);){
            records.stream().map(r -> RowDataConverter.convert(SCHEMA, r)).forEach(arg_0 -> ((FileAppender)fileAppender).add(arg_0));
        }
        return appender;
    }
}

