/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericData;
import org.apache.commons.collections.ListUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.flink.FlinkCatalogTestBase;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestFlinkMetaDataTable
extends FlinkCatalogTestBase {
    private static final String TABLE_NAME = "test_table";
    private final FileFormat format = FileFormat.AVRO;
    private static final TemporaryFolder TEMP = new TemporaryFolder();
    private final boolean isPartition;

    public TestFlinkMetaDataTable(String catalogName, Namespace baseNamespace, Boolean isPartition) {
        super(catalogName, baseNamespace);
        this.isPartition = isPartition;
    }

    @Parameterized.Parameters(name="catalogName={0}, baseNamespace={1}, isPartition={2}")
    public static Iterable<Object[]> parameters() {
        ArrayList parameters = Lists.newArrayList();
        for (Boolean isPartition : new Boolean[]{true, false}) {
            String catalogName = "testhadoop";
            Namespace baseNamespace = Namespace.of((String[])new String[]{"default"});
            parameters.add(new Object[]{catalogName, baseNamespace, isPartition});
        }
        return parameters;
    }

    @Override
    protected TableEnvironment getTableEnv() {
        Configuration configuration = super.getTableEnv().getConfig().getConfiguration();
        configuration.set(CoreOptions.DEFAULT_PARALLELISM, (Object)1);
        return super.getTableEnv();
    }

    @Override
    @Before
    public void before() {
        super.before();
        this.sql("USE CATALOG %s", this.catalogName);
        this.sql("CREATE DATABASE %s", this.flinkDatabase);
        this.sql("USE %s", "db");
        if (this.isPartition) {
            this.sql("CREATE TABLE %s (id INT, data VARCHAR,d DOUBLE) PARTITIONED BY (data) WITH ('format-version'='2', 'write.format.default'='%s')", TABLE_NAME, this.format.name());
            this.sql("INSERT INTO %s VALUES (1,'a',10),(2,'a',20)", TABLE_NAME);
            this.sql("INSERT INTO %s VALUES (1,'b',10),(2,'b',20)", TABLE_NAME);
        } else {
            this.sql("CREATE TABLE %s (id INT, data VARCHAR,d DOUBLE) WITH ('format-version'='2', 'write.format.default'='%s')", TABLE_NAME, this.format.name());
            this.sql("INSERT INTO %s VALUES (1,'iceberg',10),(2,'b',20),(3,CAST(NULL AS VARCHAR),30)", TABLE_NAME);
            this.sql("INSERT INTO %s VALUES (4,'iceberg',10)", TABLE_NAME);
        }
    }

    @Override
    @After
    public void clean() {
        this.sql("DROP TABLE IF EXISTS %s.%s", this.flinkDatabase, TABLE_NAME);
        this.sql("DROP DATABASE IF EXISTS %s", this.flinkDatabase);
        super.clean();
    }

    @Test
    public void testSnapshots() {
        String sql = String.format("SELECT * FROM %s$snapshots ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Iterator snapshots = table.snapshots().iterator();
        for (Row row : result) {
            Snapshot next = (Snapshot)snapshots.next();
            Assert.assertEquals((String)"Should have expected timestamp", (long)((Instant)row.getField(0)).toEpochMilli(), (long)next.timestampMillis());
            Assert.assertEquals((String)"Should have expected snapshot id", (Object)next.snapshotId(), (Object)row.getField(1));
            Assert.assertEquals((String)"Should have expected parent id", (Object)next.parentId(), (Object)row.getField(2));
            Assert.assertEquals((String)"Should have expected operation", (Object)next.operation(), (Object)row.getField(3));
            Assert.assertEquals((String)"Should have expected manifest list location", (Object)row.getField(4), (Object)next.manifestListLocation());
            Assert.assertEquals((String)"Should have expected summary", (Object)next.summary(), (Object)row.getField(5));
        }
    }

    @Test
    public void testHistory() {
        String sql = String.format("SELECT * FROM %s$history ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Iterator snapshots = table.snapshots().iterator();
        for (Row row : result) {
            Snapshot next = (Snapshot)snapshots.next();
            Assert.assertEquals((String)"Should have expected made_current_at", (long)((Instant)row.getField(0)).toEpochMilli(), (long)next.timestampMillis());
            Assert.assertEquals((String)"Should have expected snapshot id", (Object)next.snapshotId(), (Object)row.getField(1));
            Assert.assertEquals((String)"Should have expected parent id", (Object)next.parentId(), (Object)row.getField(2));
            Assert.assertEquals((String)"Should have expected is current ancestor", (Object)SnapshotUtil.isAncestorOf((Table)table, (long)table.currentSnapshot().snapshotId(), (long)next.snapshotId()), (Object)row.getField(3));
        }
    }

    @Test
    public void testManifests() {
        String sql = String.format("SELECT * FROM %s$manifests ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        for (int i = 0; i < result.size(); ++i) {
            Row row = result.get(i);
            ManifestFile manifestFile = expectedDataManifests.get(i);
            Assert.assertEquals((String)"Should have expected content", (Object)manifestFile.content().id(), (Object)row.getField(0));
            Assert.assertEquals((String)"Should have expected path", (Object)manifestFile.path(), (Object)row.getField(1));
            Assert.assertEquals((String)"Should have expected length", (Object)manifestFile.length(), (Object)row.getField(2));
            Assert.assertEquals((String)"Should have expected partition_spec_id", (Object)manifestFile.partitionSpecId(), (Object)row.getField(3));
            Assert.assertEquals((String)"Should have expected added_snapshot_id", (Object)manifestFile.snapshotId(), (Object)row.getField(4));
            Assert.assertEquals((String)"Should have expected added_data_files_count", (Object)manifestFile.addedFilesCount(), (Object)row.getField(5));
            Assert.assertEquals((String)"Should have expected existing_data_files_count", (Object)manifestFile.existingFilesCount(), (Object)row.getField(6));
            Assert.assertEquals((String)"Should have expected deleted_data_files_count", (Object)manifestFile.deletedFilesCount(), (Object)row.getField(7));
        }
    }

    @Test
    public void testAllManifests() {
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        String sql = String.format("SELECT * FROM %s$all_manifests ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        List<ManifestFile> expectedDataManifests = this.allDataManifests(table);
        Assert.assertEquals((long)expectedDataManifests.size(), (long)result.size());
        for (int i = 0; i < result.size(); ++i) {
            Row row = result.get(i);
            ManifestFile manifestFile = expectedDataManifests.get(i);
            Assert.assertEquals((String)"Should have expected content", (Object)manifestFile.content().id(), (Object)row.getField(0));
            Assert.assertEquals((String)"Should have expected path", (Object)manifestFile.path(), (Object)row.getField(1));
            Assert.assertEquals((String)"Should have expected length", (Object)manifestFile.length(), (Object)row.getField(2));
            Assert.assertEquals((String)"Should have expected partition_spec_id", (Object)manifestFile.partitionSpecId(), (Object)row.getField(3));
            Assert.assertEquals((String)"Should have expected added_snapshot_id", (Object)manifestFile.snapshotId(), (Object)row.getField(4));
            Assert.assertEquals((String)"Should have expected added_data_files_count", (Object)manifestFile.addedFilesCount(), (Object)row.getField(5));
            Assert.assertEquals((String)"Should have expected existing_data_files_count", (Object)manifestFile.existingFilesCount(), (Object)row.getField(6));
            Assert.assertEquals((String)"Should have expected deleted_data_files_count", (Object)manifestFile.deletedFilesCount(), (Object)row.getField(7));
        }
    }

    @Test
    public void testUnPartitionedTable() throws IOException {
        Assume.assumeFalse((boolean)this.isPartition);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Schema deleteRowSchema = table.schema().select(new String[]{"id"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("id", (Object)1)});
        TEMP.create();
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)TEMP.newFile()), (List)dataDeletes, (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes).commit();
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        List<ManifestFile> expectedDeleteManifests = this.deleteManifests(table);
        Assert.assertEquals((String)"Should have 2 data manifest", (long)2L, (long)expectedDataManifests.size());
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)expectedDeleteManifests.size());
        Schema entriesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"entries")).schema();
        Schema deleteFilesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"delete_files")).schema();
        List deleteColumns = deleteFilesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String deleteNames = deleteColumns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        deleteFilesTableSchema = deleteFilesTableSchema.select(deleteColumns);
        List<Row> actualDeleteFiles = this.sql("SELECT %s FROM %s$delete_files", deleteNames, TABLE_NAME);
        Assert.assertEquals((String)"Metadata table should return 1 delete file", (long)1L, (long)actualDeleteFiles.size());
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.EQUALITY_DELETES, entriesTableSchema, expectedDeleteManifests, null);
        Assert.assertEquals((String)"Should be 1 delete file manifest entry", (long)1L, (long)expectedDeleteFiles.size());
        TestHelpers.assertEquals(deleteFilesTableSchema, expectedDeleteFiles.get(0), actualDeleteFiles.get(0));
        Schema filesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"files")).schema();
        List columns = filesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String names = columns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        filesTableSchema = filesTableSchema.select(columns);
        List<Row> actualDataFiles = this.sql("SELECT %s FROM %s$data_files", names, TABLE_NAME);
        Assert.assertEquals((String)"Metadata table should return 2 data file", (long)2L, (long)actualDataFiles.size());
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        Assert.assertEquals((String)"Should be 2 data file manifest entry", (long)2L, (long)expectedDataFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedDataFiles.get(0), actualDataFiles.get(0));
        List<Row> actualFiles = this.sql("SELECT %s FROM %s$files ORDER BY content", names, TABLE_NAME);
        Assert.assertEquals((String)"Metadata table should return 3 files", (long)3L, (long)actualFiles.size());
        List expectedFiles = Stream.concat(expectedDataFiles.stream(), expectedDeleteFiles.stream()).collect(Collectors.toList());
        Assert.assertEquals((String)"Should have 3 files manifest entries", (long)3L, (long)expectedFiles.size());
        TestHelpers.assertEquals(filesTableSchema, (GenericData.Record)expectedFiles.get(0), actualFiles.get(0));
        TestHelpers.assertEquals(filesTableSchema, (GenericData.Record)expectedFiles.get(1), actualFiles.get(1));
    }

    @Test
    public void testPartitionedTable() throws Exception {
        Assume.assumeFalse((!this.isPartition ? 1 : 0) != 0);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Schema deleteRowSchema = table.schema().select(new String[]{"id", "data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        TEMP.create();
        HashMap deleteRow = Maps.newHashMap();
        deleteRow.put("id", 1);
        deleteRow.put("data", "a");
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)TEMP.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"a"}), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes).commit();
        deleteRow.put("data", "b");
        DeleteFile eqDeletes2 = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)TEMP.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"b"}), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes2).commit();
        Schema entriesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"entries")).schema();
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        List<ManifestFile> expectedDeleteManifests = this.deleteManifests(table);
        Assert.assertEquals((String)"Should have 2 data manifests", (long)2L, (long)expectedDataManifests.size());
        Assert.assertEquals((String)"Should have 2 delete manifests", (long)2L, (long)expectedDeleteManifests.size());
        Table deleteFilesTable = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"delete_files"));
        Schema filesTableSchema = deleteFilesTable.schema();
        List columns = filesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String names = columns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        filesTableSchema = filesTableSchema.select(columns);
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.EQUALITY_DELETES, entriesTableSchema, expectedDeleteManifests, "a");
        Assert.assertEquals((String)"Should have one delete file manifest entry", (long)1L, (long)expectedDeleteFiles.size());
        List<Row> actualDeleteFiles = this.sql("SELECT %s FROM %s$delete_files WHERE `partition`.`data`='a'", names, TABLE_NAME);
        Assert.assertEquals((String)"Metadata table should return one delete file", (long)1L, (long)actualDeleteFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedDeleteFiles.get(0), actualDeleteFiles.get(0));
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, "a");
        Assert.assertEquals((String)"Should have one data file manifest entry", (long)1L, (long)expectedDataFiles.size());
        List<Row> actualDataFiles = this.sql("SELECT %s FROM %s$data_files  WHERE `partition`.`data`='a'", names, TABLE_NAME);
        Assert.assertEquals((String)"Metadata table should return one data file", (long)1L, (long)actualDataFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedDataFiles.get(0), actualDataFiles.get(0));
        List<Row> actualPartitionsWithProjection = this.sql("SELECT file_count FROM %s$partitions ", TABLE_NAME);
        Assert.assertEquals((String)"Metadata table should return two partitions record", (long)2L, (long)actualPartitionsWithProjection.size());
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)1, (Object)actualPartitionsWithProjection.get(i).getField(0));
        }
        List expectedFiles = Stream.concat(expectedDataFiles.stream(), expectedDeleteFiles.stream()).collect(Collectors.toList());
        Assert.assertEquals((String)"Should have two file manifest entries", (long)2L, (long)expectedFiles.size());
        List<Row> actualFiles = this.sql("SELECT %s FROM %s$files WHERE `partition`.`data`='a' ORDER BY content", names, TABLE_NAME);
        Assert.assertEquals((String)"Metadata table should return two files", (long)2L, (long)actualFiles.size());
        TestHelpers.assertEquals(filesTableSchema, (GenericData.Record)expectedFiles.get(0), actualFiles.get(0));
        TestHelpers.assertEquals(filesTableSchema, (GenericData.Record)expectedFiles.get(1), actualFiles.get(1));
    }

    @Test
    public void testAllFilesUnpartitioned() throws Exception {
        Assume.assumeFalse((boolean)this.isPartition);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Schema deleteRowSchema = table.schema().select(new String[]{"id", "data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        TEMP.create();
        HashMap deleteRow = Maps.newHashMap();
        deleteRow.put("id", 1);
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)TEMP.newFile()), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes).commit();
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        Assert.assertEquals((String)"Should have 2 data manifest", (long)2L, (long)expectedDataManifests.size());
        List<ManifestFile> expectedDeleteManifests = this.deleteManifests(table);
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)expectedDeleteManifests.size());
        table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        Schema entriesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"entries")).schema();
        Schema filesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"all_data_files")).schema();
        List columns = filesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String names = columns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        filesTableSchema = filesTableSchema.select(columns);
        List<Row> actualDataFiles = this.sql("SELECT %s FROM %s$all_data_files order by record_count ", names, TABLE_NAME);
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, null);
        Assert.assertEquals((String)"Should be 2 data file manifest entry", (long)2L, (long)expectedDataFiles.size());
        Assert.assertEquals((String)"Metadata table should return 2 data file", (long)2L, (long)actualDataFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedDataFiles, actualDataFiles);
        List<Row> actualDeleteFiles = this.sql("SELECT %s FROM %s$all_delete_files", names, TABLE_NAME);
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.EQUALITY_DELETES, entriesTableSchema, expectedDeleteManifests, null);
        Assert.assertEquals((String)"Should be one delete file manifest entry", (long)1L, (long)expectedDeleteFiles.size());
        Assert.assertEquals((String)"Metadata table should return one delete file", (long)1L, (long)actualDeleteFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedDeleteFiles.get(0), actualDeleteFiles.get(0));
        List<Row> actualFiles = this.sql("SELECT %s FROM %s$all_files ORDER BY content, record_count asc", names, TABLE_NAME);
        List expectedFiles = ListUtils.union(expectedDataFiles, expectedDeleteFiles);
        expectedFiles.sort(Comparator.comparing(r -> (Integer)r.get("content")));
        Assert.assertEquals((String)"Metadata table should return 3 files", (long)3L, (long)actualFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedFiles, actualFiles);
    }

    @Test
    public void testAllFilesPartitioned() throws Exception {
        Assume.assumeFalse((!this.isPartition ? 1 : 0) != 0);
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Schema deleteRowSchema = table.schema().select(new String[]{"id"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        TEMP.create();
        HashMap deleteRow = Maps.newHashMap();
        deleteRow.put("id", 1);
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)TEMP.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"a"}), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        DeleteFile eqDeletes2 = FileHelpers.writeDeleteFile((Table)table, (OutputFile)Files.localOutput((File)TEMP.newFile()), (StructLike)TestHelpers.Row.of((Object[])new Object[]{"b"}), (List)Lists.newArrayList((Object[])new Record[]{dataDelete.copy((Map)deleteRow)}), (Schema)deleteRowSchema);
        table.newRowDelta().addDeletes(eqDeletes).addDeletes(eqDeletes2).commit();
        List<ManifestFile> expectedDataManifests = this.dataManifests(table);
        Assert.assertEquals((String)"Should have 2 data manifests", (long)2L, (long)expectedDataManifests.size());
        List<ManifestFile> expectedDeleteManifests = this.deleteManifests(table);
        Assert.assertEquals((String)"Should have 1 delete manifest", (long)1L, (long)expectedDeleteManifests.size());
        table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        Schema entriesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"entries")).schema();
        Schema filesTableSchema = MetadataTableUtils.createMetadataTableInstance((Table)table, (MetadataTableType)MetadataTableType.from((String)"all_data_files")).schema();
        List columns = filesTableSchema.columns().stream().map(Types.NestedField::name).filter(c -> !c.equals("readable_metrics")).collect(Collectors.toList());
        String names = columns.stream().map(n -> "`" + n + "`").collect(Collectors.joining(","));
        filesTableSchema = filesTableSchema.select(columns);
        List<Row> actualDataFiles = this.sql("SELECT %s FROM %s$all_data_files WHERE `partition`.`data`='a'", names, TABLE_NAME);
        List<GenericData.Record> expectedDataFiles = this.expectedEntries(table, FileContent.DATA, entriesTableSchema, expectedDataManifests, "a");
        Assert.assertEquals((String)"Should be one data file manifest entry", (long)1L, (long)expectedDataFiles.size());
        Assert.assertEquals((String)"Metadata table should return one data file", (long)1L, (long)actualDataFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedDataFiles.get(0), actualDataFiles.get(0));
        List<Row> actualDeleteFiles = this.sql("SELECT %s FROM %s$all_delete_files WHERE `partition`.`data`='a'", names, TABLE_NAME);
        List<GenericData.Record> expectedDeleteFiles = this.expectedEntries(table, FileContent.EQUALITY_DELETES, entriesTableSchema, expectedDeleteManifests, "a");
        Assert.assertEquals((String)"Should be one data file manifest entry", (long)1L, (long)expectedDeleteFiles.size());
        Assert.assertEquals((String)"Metadata table should return one data file", (long)1L, (long)actualDeleteFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedDeleteFiles.get(0), actualDeleteFiles.get(0));
        List<Row> actualFiles = this.sql("SELECT %s FROM %s$all_files WHERE `partition`.`data`='a' ORDER BY content", names, TABLE_NAME);
        List expectedFiles = ListUtils.union(expectedDataFiles, expectedDeleteFiles);
        expectedFiles.sort(Comparator.comparing(r -> (Integer)r.get("content")));
        Assert.assertEquals((String)"Metadata table should return two files", (long)2L, (long)actualFiles.size());
        TestHelpers.assertEquals(filesTableSchema, expectedFiles, actualFiles);
    }

    @Test
    public void testMetadataLogEntries() {
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        TableMetadata tableMetadata = ((HasTableOperations)table).operations().current();
        Snapshot currentSnapshot = tableMetadata.currentSnapshot();
        Snapshot parentSnapshot = table.snapshot(currentSnapshot.parentId().longValue());
        ArrayList metadataLogEntries = Lists.newArrayList((Iterable)tableMetadata.previousFiles());
        List<Row> metadataLogs = this.sql("SELECT * FROM %s$metadata_log_entries", TABLE_NAME);
        Assert.assertEquals((String)"metadataLogEntries table should return 3 row", (long)3L, (long)metadataLogs.size());
        Row metadataLog = metadataLogs.get(0);
        Assert.assertEquals((Object)Instant.ofEpochMilli(((TableMetadata.MetadataLogEntry)metadataLogEntries.get(0)).timestampMillis()), (Object)metadataLog.getField("timestamp"));
        Assert.assertEquals((Object)((TableMetadata.MetadataLogEntry)metadataLogEntries.get(0)).file(), (Object)metadataLog.getField("file"));
        Assert.assertNull((Object)metadataLog.getField("latest_snapshot_id"));
        Assert.assertNull((Object)metadataLog.getField("latest_schema_id"));
        Assert.assertNull((Object)metadataLog.getField("latest_sequence_number"));
        metadataLog = metadataLogs.get(1);
        Assert.assertEquals((Object)Instant.ofEpochMilli(((TableMetadata.MetadataLogEntry)metadataLogEntries.get(1)).timestampMillis()), (Object)metadataLog.getField("timestamp"));
        Assert.assertEquals((Object)((TableMetadata.MetadataLogEntry)metadataLogEntries.get(1)).file(), (Object)metadataLog.getField("file"));
        Assert.assertEquals((Object)parentSnapshot.snapshotId(), (Object)metadataLog.getField("latest_snapshot_id"));
        Assert.assertEquals((Object)parentSnapshot.schemaId(), (Object)metadataLog.getField("latest_schema_id"));
        Assert.assertEquals((Object)parentSnapshot.sequenceNumber(), (Object)metadataLog.getField("latest_sequence_number"));
        metadataLog = metadataLogs.get(2);
        Assert.assertEquals((Object)Instant.ofEpochMilli(currentSnapshot.timestampMillis()), (Object)metadataLog.getField("timestamp"));
        Assert.assertEquals((Object)tableMetadata.metadataFileLocation(), (Object)metadataLog.getField("file"));
        Assert.assertEquals((Object)currentSnapshot.snapshotId(), (Object)metadataLog.getField("latest_snapshot_id"));
        Assert.assertEquals((Object)currentSnapshot.schemaId(), (Object)metadataLog.getField("latest_schema_id"));
        Assert.assertEquals((Object)currentSnapshot.sequenceNumber(), (Object)metadataLog.getField("latest_sequence_number"));
        List<Row> metadataLogWithFilters = this.sql("SELECT * FROM %s$metadata_log_entries WHERE latest_snapshot_id = %s", TABLE_NAME, currentSnapshotId);
        Assert.assertEquals((String)"metadataLogEntries table should return 1 row", (long)1L, (long)metadataLogWithFilters.size());
        metadataLog = metadataLogWithFilters.get(0);
        Assert.assertEquals((Object)Instant.ofEpochMilli(tableMetadata.currentSnapshot().timestampMillis()), (Object)metadataLog.getField("timestamp"));
        Assert.assertEquals((Object)tableMetadata.metadataFileLocation(), (Object)metadataLog.getField("file"));
        Assert.assertEquals((Object)tableMetadata.currentSnapshot().snapshotId(), (Object)metadataLog.getField("latest_snapshot_id"));
        Assert.assertEquals((Object)tableMetadata.currentSnapshot().schemaId(), (Object)metadataLog.getField("latest_schema_id"));
        Assert.assertEquals((Object)tableMetadata.currentSnapshot().sequenceNumber(), (Object)metadataLog.getField("latest_sequence_number"));
        List metadataFiles = metadataLogEntries.stream().map(TableMetadata.MetadataLogEntry::file).collect(Collectors.toList());
        metadataFiles.add(tableMetadata.metadataFileLocation());
        List<Row> metadataLogWithProjection = this.sql("SELECT file FROM %s$metadata_log_entries", TABLE_NAME);
        Assert.assertEquals((String)"metadataLogEntries table should return 3 rows", (long)3L, (long)metadataLogWithProjection.size());
        for (int i = 0; i < metadataFiles.size(); ++i) {
            Assert.assertEquals(metadataFiles.get(i), (Object)metadataLogWithProjection.get(i).getField("file"));
        }
    }

    @Test
    public void testSnapshotReferencesMetatable() {
        Table table = this.validationCatalog.loadTable(TableIdentifier.of((Namespace)this.icebergNamespace, (String)TABLE_NAME));
        Long currentSnapshotId = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch("testBranch", currentSnapshotId.longValue()).setMaxRefAgeMs("testBranch", 10L).setMinSnapshotsToKeep("testBranch", 20).setMaxSnapshotAgeMs("testBranch", 30L).commit();
        table.manageSnapshots().createTag("testTag", currentSnapshotId.longValue()).setMaxRefAgeMs("testTag", 50L).commit();
        List<Row> references = this.sql("SELECT * FROM %s$refs", TABLE_NAME);
        Assert.assertEquals((String)"Refs table should return 3 rows", (long)3L, (long)references.size());
        List<Row> branches = this.sql("SELECT * FROM %s$refs WHERE type='BRANCH'", TABLE_NAME);
        Assert.assertEquals((String)"Refs table should return 2 branches", (long)2L, (long)branches.size());
        List<Row> tags = this.sql("SELECT * FROM %s$refs WHERE type='TAG'", TABLE_NAME);
        Assert.assertEquals((String)"Refs table should return 1 tag", (long)1L, (long)tags.size());
        List<Row> mainBranch = this.sql("SELECT * FROM %s$refs WHERE name='main' AND type='BRANCH'", TABLE_NAME);
        Assert.assertEquals((Object)"main", (Object)mainBranch.get(0).getFieldAs("name"));
        Assert.assertEquals((Object)"BRANCH", (Object)mainBranch.get(0).getFieldAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)mainBranch.get(0).getFieldAs("snapshot_id"));
        List<Row> testBranch = this.sql("SELECT * FROM  %s$refs WHERE name='testBranch' AND type='BRANCH'", TABLE_NAME);
        Assert.assertEquals((Object)"testBranch", (Object)testBranch.get(0).getFieldAs("name"));
        Assert.assertEquals((Object)"BRANCH", (Object)testBranch.get(0).getFieldAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)testBranch.get(0).getFieldAs("snapshot_id"));
        Assert.assertEquals((Object)10L, (Object)testBranch.get(0).getFieldAs("max_reference_age_in_ms"));
        Assert.assertEquals((Object)20, (Object)testBranch.get(0).getFieldAs("min_snapshots_to_keep"));
        Assert.assertEquals((Object)30L, (Object)testBranch.get(0).getFieldAs("max_snapshot_age_in_ms"));
        List<Row> testTag = this.sql("SELECT * FROM %s$refs WHERE name='testTag' AND type='TAG'", TABLE_NAME);
        Assert.assertEquals((Object)"testTag", (Object)testTag.get(0).getFieldAs("name"));
        Assert.assertEquals((Object)"TAG", (Object)testTag.get(0).getFieldAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)testTag.get(0).getFieldAs("snapshot_id"));
        Assert.assertEquals((Object)50L, (Object)testTag.get(0).getFieldAs("max_reference_age_in_ms"));
        List<Row> testTagProjection = this.sql("SELECT name,type,snapshot_id,max_reference_age_in_ms,min_snapshots_to_keep FROM %s$refs where type='TAG'", TABLE_NAME);
        Assert.assertEquals((Object)"testTag", (Object)testTagProjection.get(0).getFieldAs("name"));
        Assert.assertEquals((Object)"TAG", (Object)testTagProjection.get(0).getFieldAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)testTagProjection.get(0).getFieldAs("snapshot_id"));
        Assert.assertEquals((Object)50L, (Object)testTagProjection.get(0).getFieldAs("max_reference_age_in_ms"));
        Assert.assertNull((Object)testTagProjection.get(0).getFieldAs("min_snapshots_to_keep"));
        List<Row> mainBranchProjection = this.sql("SELECT name, type FROM %s$refs WHERE name='main' AND type = 'BRANCH'", TABLE_NAME);
        Assert.assertEquals((Object)"main", (Object)mainBranchProjection.get(0).getFieldAs("name"));
        Assert.assertEquals((Object)"BRANCH", (Object)mainBranchProjection.get(0).getFieldAs("type"));
        List<Row> testBranchProjection = this.sql("SELECT type, name, max_reference_age_in_ms, snapshot_id FROM %s$refs WHERE name='testBranch' AND type = 'BRANCH'", TABLE_NAME);
        Assert.assertEquals((Object)"testBranch", (Object)testBranchProjection.get(0).getFieldAs("name"));
        Assert.assertEquals((Object)"BRANCH", (Object)testBranchProjection.get(0).getFieldAs("type"));
        Assert.assertEquals((Object)currentSnapshotId, (Object)testBranchProjection.get(0).getFieldAs("snapshot_id"));
        Assert.assertEquals((Object)10L, (Object)testBranchProjection.get(0).getFieldAs("max_reference_age_in_ms"));
    }

    private List<GenericData.Record> expectedEntries(Table table, FileContent expectedContent, Schema entriesTableSchema, List<ManifestFile> manifestsToExplore, String partValue) throws IOException {
        ArrayList expected = Lists.newArrayList();
        for (ManifestFile manifest : manifestsToExplore) {
            InputFile in = table.io().newInputFile(manifest.path());
            AvroIterable rows = Avro.read((InputFile)in).project(entriesTableSchema).build();
            Throwable throwable = null;
            try {
                for (GenericData.Record record : rows) {
                    GenericData.Record file;
                    if ((Integer)record.get("status") >= 2 || !this.partitionMatch(file = (GenericData.Record)record.get("data_file"), partValue)) continue;
                    this.asMetadataRecord(file, expectedContent);
                    expected.add(file);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rows == null) continue;
                if (throwable != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                rows.close();
            }
        }
        return expected;
    }

    private void asMetadataRecord(GenericData.Record file, FileContent content) {
        file.put(0, (Object)content.id());
        file.put(3, (Object)0);
    }

    private boolean partitionMatch(GenericData.Record file, String partValue) {
        if (partValue == null) {
            return true;
        }
        GenericData.Record partition = (GenericData.Record)file.get(4);
        return partValue.equals(partition.get(0).toString());
    }

    private List<ManifestFile> dataManifests(Table table) {
        return table.currentSnapshot().dataManifests(table.io());
    }

    private List<ManifestFile> allDataManifests(Table table) {
        ArrayList manifests = Lists.newArrayList();
        for (Snapshot snapshot : table.snapshots()) {
            manifests.addAll(snapshot.dataManifests(table.io()));
        }
        return manifests;
    }

    private List<ManifestFile> deleteManifests(Table table) {
        return table.currentSnapshot().deleteManifests(table.io());
    }
}

