/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.types.Row;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.flink.HadoopCatalogResource;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestFlinkScan {
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = MiniClusterResource.createWithClassloaderCheckDisabled();
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    @Rule
    public final HadoopCatalogResource catalogResource = new HadoopCatalogResource(TEMPORARY_FOLDER, "default", "t");
    protected final FileFormat fileFormat;

    @Parameterized.Parameters(name="format={0}")
    public static Object[] parameters() {
        return new Object[]{"avro", "parquet", "orc"};
    }

    TestFlinkScan(String fileFormat) {
        this.fileFormat = FileFormat.fromString((String)fileFormat);
    }

    protected TableLoader tableLoader() {
        return this.catalogResource.tableLoader();
    }

    protected abstract List<Row> runWithProjection(String ... var1) throws Exception;

    protected abstract List<Row> runWithFilter(Expression var1, String var2, boolean var3) throws Exception;

    protected List<Row> runWithFilter(Expression filter, String sqlFilter) throws Exception {
        return this.runWithFilter(filter, sqlFilter, true);
    }

    protected abstract List<Row> runWithOptions(Map<String, String> var1) throws Exception;

    protected abstract List<Row> run() throws Exception;

    @Test
    public void testUnpartitionedTable() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA);
        List expectedRecords = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)0L);
        new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER).appendToTable(expectedRecords);
        TestHelpers.assertRecords(this.run(), expectedRecords, TestFixtures.SCHEMA);
    }

    @Test
    public void testPartitionedTable() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA, TestFixtures.SPEC);
        List expectedRecords = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        ((Record)expectedRecords.get(0)).set(2, (Object)"2020-03-20");
        new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER).appendToTable((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), expectedRecords);
        TestHelpers.assertRecords(this.run(), expectedRecords, TestFixtures.SCHEMA);
    }

    @Test
    public void testProjection() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA, TestFixtures.SPEC);
        List inputRecords = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER).appendToTable((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), inputRecords);
        TestFlinkScan.assertRows(this.runWithProjection("data"), Row.of((Object[])new Object[]{((Record)inputRecords.get(0)).get(0)}));
    }

    @Test
    public void testIdentityPartitionProjections() throws Exception {
        Schema logSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"dt", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"level", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"message", (Type)Types.StringType.get())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)logSchema).identity("dt").identity("level").build();
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, logSchema, spec);
        List inputRecords = RandomGenericData.generate((Schema)logSchema, (int)10, (long)0L);
        int idx = 0;
        AppendFiles append = table.newAppend();
        for (Record record : inputRecords) {
            record.set(1, (Object)("2020-03-2" + idx));
            record.set(2, (Object)Integer.toString(idx));
            append.appendFile(new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER).writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-2" + idx, Integer.toString(idx)}), (List)ImmutableList.of((Object)record)));
            ++idx;
        }
        append.commit();
        this.validateIdentityPartitionProjections(table, Collections.singletonList("dt"), inputRecords);
        this.validateIdentityPartitionProjections(table, Collections.singletonList("level"), inputRecords);
        this.validateIdentityPartitionProjections(table, Collections.singletonList("message"), inputRecords);
        this.validateIdentityPartitionProjections(table, Collections.singletonList("id"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("dt", "message"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("level", "message"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("dt", "level"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("message", "dt"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("message", "level"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("level", "dt"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("dt", "level", "message"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("level", "dt", "message"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("dt", "message", "level"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("level", "message", "dt"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("message", "dt", "level"), inputRecords);
        this.validateIdentityPartitionProjections(table, Arrays.asList("message", "level", "dt"), inputRecords);
    }

    private void validateIdentityPartitionProjections(Table table, List<String> projectedFields, List<Record> inputRecords) throws Exception {
        List<Row> rows = this.runWithProjection(projectedFields.toArray(new String[0]));
        for (int pos = 0; pos < inputRecords.size(); ++pos) {
            Record inputRecord = inputRecords.get(pos);
            Row actualRecord = rows.get(pos);
            for (int i = 0; i < projectedFields.size(); ++i) {
                String name = projectedFields.get(i);
                Assert.assertEquals((String)("Projected field " + name + " should match"), (Object)inputRecord.getField(name), (Object)actualRecord.getField(i));
            }
        }
    }

    @Test
    public void testSnapshotReads() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA);
        GenericAppenderHelper helper = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        List expectedRecords = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        helper.appendToTable(expectedRecords);
        long snapshotId = table.currentSnapshot().snapshotId();
        long timestampMillis = table.currentSnapshot().timestampMillis();
        TestFlinkScan.waitUntilAfter(timestampMillis);
        helper.appendToTable(RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L));
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.of((Object)"snapshot-id", (Object)Long.toString(snapshotId))), expectedRecords, TestFixtures.SCHEMA);
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.of((Object)"as-of-timestamp", (Object)Long.toString(timestampMillis))), expectedRecords, TestFixtures.SCHEMA);
    }

    @Test
    public void testTagReads() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA);
        GenericAppenderHelper helper = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        List expectedRecords1 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        helper.appendToTable(expectedRecords1);
        long snapshotId = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createTag("t1", snapshotId).commit();
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.of((Object)"tag", (Object)"t1")), expectedRecords1, TestFixtures.SCHEMA);
        List expectedRecords2 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        helper.appendToTable(expectedRecords2);
        snapshotId = table.currentSnapshot().snapshotId();
        table.manageSnapshots().replaceTag("t1", snapshotId).commit();
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.addAll(expectedRecords1);
        expectedRecords.addAll(expectedRecords2);
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.of((Object)"tag", (Object)"t1")), expectedRecords, TestFixtures.SCHEMA);
    }

    @Test
    public void testBranchReads() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA);
        GenericAppenderHelper helper = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        List expectedRecordsBase = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        helper.appendToTable(expectedRecordsBase);
        long snapshotId = table.currentSnapshot().snapshotId();
        String branchName = "b1";
        table.manageSnapshots().createBranch(branchName, snapshotId).commit();
        List expectedRecordsForBranch = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        helper.appendToTable(branchName, expectedRecordsForBranch);
        List expectedRecordsForMain = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        helper.appendToTable(expectedRecordsForMain);
        ArrayList branchExpectedRecords = Lists.newArrayList();
        branchExpectedRecords.addAll(expectedRecordsBase);
        branchExpectedRecords.addAll(expectedRecordsForBranch);
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.of((Object)"branch", (Object)branchName)), branchExpectedRecords, TestFixtures.SCHEMA);
        ArrayList mainExpectedRecords = Lists.newArrayList();
        mainExpectedRecords.addAll(expectedRecordsBase);
        mainExpectedRecords.addAll(expectedRecordsForMain);
        TestHelpers.assertRecords(this.run(), mainExpectedRecords, TestFixtures.SCHEMA);
    }

    @Test
    public void testIncrementalReadViaTag() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA);
        GenericAppenderHelper helper = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        List records1 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        helper.appendToTable(records1);
        long snapshotId1 = table.currentSnapshot().snapshotId();
        String startTag = "t1";
        table.manageSnapshots().createTag(startTag, snapshotId1).commit();
        List records2 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)1L);
        helper.appendToTable(records2);
        List records3 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)2L);
        helper.appendToTable(records3);
        long snapshotId3 = table.currentSnapshot().snapshotId();
        String endTag = "t2";
        table.manageSnapshots().createTag(endTag, snapshotId3).commit();
        helper.appendToTable(RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)3L));
        ArrayList expected = Lists.newArrayList();
        expected.addAll(records2);
        expected.addAll(records3);
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.builder().put((Object)"start-tag", (Object)startTag).put((Object)"end-tag", (Object)endTag).buildOrThrow()), expected, TestFixtures.SCHEMA);
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.builder().put((Object)"start-snapshot-id", (Object)Long.toString(snapshotId1)).put((Object)"end-tag", (Object)endTag).buildOrThrow()), expected, TestFixtures.SCHEMA);
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.builder().put((Object)"start-tag", (Object)startTag).put((Object)"end-snapshot-id", (Object)Long.toString(snapshotId3)).buildOrThrow()), expected, TestFixtures.SCHEMA);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runWithOptions((Map<String, String>)ImmutableMap.builder().put((Object)"start-tag", (Object)startTag).put((Object)"end-tag", (Object)endTag).put((Object)"start-snapshot-id", (Object)Long.toString(snapshotId1)).buildOrThrow())).isInstanceOf(Exception.class)).hasMessage("START_SNAPSHOT_ID and START_TAG cannot both be set.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runWithOptions((Map<String, String>)ImmutableMap.builder().put((Object)"start-tag", (Object)startTag).put((Object)"end-tag", (Object)endTag).put((Object)"end-snapshot-id", (Object)Long.toString(snapshotId3)).buildOrThrow())).isInstanceOf(Exception.class)).hasMessage("END_SNAPSHOT_ID and END_TAG cannot both be set.");
    }

    @Test
    public void testIncrementalRead() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA);
        GenericAppenderHelper helper = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        List records1 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)0L);
        helper.appendToTable(records1);
        long snapshotId1 = table.currentSnapshot().snapshotId();
        List records2 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)1L);
        helper.appendToTable(records2);
        List records3 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)2L);
        helper.appendToTable(records3);
        long snapshotId3 = table.currentSnapshot().snapshotId();
        helper.appendToTable(RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)1, (long)3L));
        ArrayList expected2 = Lists.newArrayList();
        expected2.addAll(records2);
        expected2.addAll(records3);
        TestHelpers.assertRecords(this.runWithOptions((Map<String, String>)ImmutableMap.builder().put((Object)"start-snapshot-id", (Object)Long.toString(snapshotId1)).put((Object)"end-snapshot-id", (Object)Long.toString(snapshotId3)).buildOrThrow()), expected2, TestFixtures.SCHEMA);
    }

    @Test
    public void testFilterExpPartition() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA, TestFixtures.SPEC);
        List expectedRecords = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)0L);
        ((Record)expectedRecords.get(0)).set(2, (Object)"2020-03-20");
        ((Record)expectedRecords.get(1)).set(2, (Object)"2020-03-20");
        GenericAppenderHelper helper = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        DataFile dataFile1 = helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), expectedRecords);
        DataFile dataFile2 = helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-21", 0}), RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)0L));
        helper.appendToTable(new DataFile[]{dataFile1, dataFile2});
        TestHelpers.assertRecords(this.runWithFilter((Expression)Expressions.equal((String)"dt", (Object)"2020-03-20"), "where dt='2020-03-20'", true), expectedRecords, TestFixtures.SCHEMA);
    }

    private void testFilterExp(Expression filter, String sqlFilter, boolean caseSensitive) throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA);
        List expectedRecords = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)3, (long)0L);
        ((Record)expectedRecords.get(0)).set(0, (Object)"a");
        ((Record)expectedRecords.get(1)).set(0, (Object)"b");
        ((Record)expectedRecords.get(2)).set(0, (Object)"c");
        GenericAppenderHelper helper = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        DataFile dataFile = helper.writeFile(expectedRecords);
        helper.appendToTable(new DataFile[]{dataFile});
        List<Row> actual = this.runWithFilter((Expression)Expressions.greaterThanOrEqual((String)"data", (Object)"b"), "where data>='b'", true);
        TestHelpers.assertRecords(actual, expectedRecords.subList(1, 3), TestFixtures.SCHEMA);
    }

    @Test
    public void testFilterExp() throws Exception {
        this.testFilterExp((Expression)Expressions.greaterThanOrEqual((String)"data", (Object)"b"), "where data>='b'", true);
    }

    @Test
    public void testFilterExpCaseInsensitive() throws Exception {
        this.testFilterExp((Expression)Expressions.greaterThanOrEqual((String)"DATA", (Object)"b"), "where data>='b'", false);
    }

    @Test
    public void testPartitionTypes() throws Exception {
        Schema typesSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"decimal", (Type)Types.DecimalType.of((int)38, (int)18)), Types.NestedField.optional((int)3, (String)"str", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"binary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)5, (String)"date", (Type)Types.DateType.get()), Types.NestedField.optional((int)6, (String)"time", (Type)Types.TimeType.get()), Types.NestedField.optional((int)7, (String)"timestamp", (Type)Types.TimestampType.withoutZone())});
        PartitionSpec spec = PartitionSpec.builderFor((Schema)typesSchema).identity("decimal").identity("str").identity("binary").identity("date").identity("time").identity("timestamp").build();
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, typesSchema, spec);
        List records = RandomGenericData.generate((Schema)typesSchema, (int)10, (long)0L);
        GenericAppenderHelper appender = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        for (Record record : records) {
            TestHelpers.Row partition = TestHelpers.Row.of((Object[])new Object[]{record.get(1), record.get(2), record.get(3), record.get(4) == null ? null : Integer.valueOf(DateTimeUtil.daysFromDate((LocalDate)((LocalDate)record.get(4)))), record.get(5) == null ? null : Long.valueOf(DateTimeUtil.microsFromTime((LocalTime)((LocalTime)record.get(5)))), record.get(6) == null ? null : Long.valueOf(DateTimeUtil.microsFromTimestamp((LocalDateTime)((LocalDateTime)record.get(6))))});
            appender.appendToTable((StructLike)partition, Collections.singletonList(record));
        }
        TestHelpers.assertRecords(this.run(), records, typesSchema);
    }

    @Test
    public void testCustomizedFlinkDataTypes() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"map", (Type)Types.MapType.ofRequired((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.StringType.get())), Types.NestedField.required((int)4, (String)"arr", (Type)Types.ListType.ofRequired((int)5, (Type)Types.StringType.get()))});
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, schema);
        List records = RandomGenericData.generate((Schema)schema, (int)10, (long)0L);
        GenericAppenderHelper helper = new GenericAppenderHelper(table, this.fileFormat, TEMPORARY_FOLDER);
        helper.appendToTable(records);
        TestHelpers.assertRecords(this.run(), records, schema);
    }

    private static void assertRows(List<Row> results, Row ... expected) {
        TestHelpers.assertRows(results, Arrays.asList(expected));
    }

    private static void waitUntilAfter(long timestampMillis) {
        long current = System.currentTimeMillis();
        while (current <= timestampMillis) {
            current = System.currentTimeMillis();
        }
    }
}

