/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.types.Row;
import org.apache.iceberg.flink.source.FlinkSource;
import org.apache.iceberg.flink.source.SqlHelpers;
import org.apache.iceberg.flink.source.TestFlinkSource;
import org.junit.Before;

public class TestFlinkScanSql
extends TestFlinkSource {
    private volatile TableEnvironment tEnv;

    public TestFlinkScanSql(String fileFormat) {
        super(fileFormat);
    }

    @Before
    public void before() throws IOException {
        SqlHelpers.sql(this.getTableEnv(), "create catalog iceberg_catalog with ('type'='iceberg', 'catalog-type'='hadoop', 'warehouse'='%s')", this.catalogResource.warehouse());
        SqlHelpers.sql(this.getTableEnv(), "use catalog iceberg_catalog", new Object[0]);
        this.getTableEnv().getConfig().getConfiguration().set(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableEnvironment getTableEnv() {
        if (this.tEnv == null) {
            TestFlinkScanSql testFlinkScanSql = this;
            synchronized (testFlinkScanSql) {
                if (this.tEnv == null) {
                    this.tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
                }
            }
        }
        return this.tEnv;
    }

    @Override
    protected List<Row> run(FlinkSource.Builder formatBuilder, Map<String, String> sqlOptions, String sqlFilter, String ... sqlSelectedFields) {
        String select = String.join((CharSequence)",", sqlSelectedFields);
        String optionStr = SqlHelpers.sqlOptionsToString(sqlOptions);
        return SqlHelpers.sql(this.getTableEnv(), "select %s from t %s %s", select, optionStr, sqlFilter);
    }
}

