/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.types.Row;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.source.SqlHelpers;
import org.apache.iceberg.flink.source.TestSqlBase;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.Test;

public class TestFlinkSourceSql
extends TestSqlBase {
    @Override
    public void before() throws IOException {
        SqlHelpers.sql(this.getTableEnv(), "create catalog iceberg_catalog with ('type'='iceberg', 'catalog-type'='hadoop', 'warehouse'='%s')", this.catalogResource.warehouse());
        SqlHelpers.sql(this.getTableEnv(), "use catalog iceberg_catalog", new Object[0]);
        this.getTableEnv().getConfig().getConfiguration().set(TableConfigOptions.TABLE_DYNAMIC_TABLE_OPTIONS_ENABLED, (Object)true);
    }

    @Test
    public void testInferParallelismWithGlobalSetting() throws IOException {
        Configuration cfg = this.getTableEnv().getConfig().getConfiguration();
        cfg.set(PipelineOptions.MAX_PARALLELISM, (Object)1);
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA, null);
        GenericAppenderHelper helper = new GenericAppenderHelper(table, FileFormat.PARQUET, TEMPORARY_FOLDER);
        ArrayList expectedRecords = Lists.newArrayList();
        long maxFileLen = 0L;
        for (int i = 0; i < 5; ++i) {
            List records = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)i);
            DataFile dataFile = helper.writeFile(null, records);
            helper.appendToTable(new DataFile[]{dataFile});
            expectedRecords.addAll(records);
            maxFileLen = Math.max(dataFile.fileSizeInBytes(), maxFileLen);
        }
        SqlHelpers.sql(this.getTableEnv(), "ALTER TABLE t SET ('read.split.open-file-cost'='1', 'read.split.target-size'='%s')", maxFileLen);
        List<Row> results = this.run(Maps.newHashMap(), "", "*");
        TestHelpers.assertRecords(results, expectedRecords, TestFixtures.SCHEMA);
    }
}

