/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.flink.FlinkTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFlinkTableSource
extends FlinkTestBase {
    private static final String CATALOG_NAME = "test_catalog";
    private static final String DATABASE_NAME = "test_db";
    private static final String TABLE_NAME = "test_table";
    private final FileFormat format = FileFormat.AVRO;
    private static String warehouse;
    private int scanEventCount = 0;
    private ScanEvent lastScanEvent = null;

    public TestFlinkTableSource() {
        Listeners.register(event -> {
            ++this.scanEventCount;
            this.lastScanEvent = event;
        }, ScanEvent.class);
    }

    @Override
    protected TableEnvironment getTableEnv() {
        super.getTableEnv().getConfig().getConfiguration().set(CoreOptions.DEFAULT_PARALLELISM, (Object)1);
        return super.getTableEnv();
    }

    @BeforeClass
    public static void createWarehouse() throws IOException {
        File warehouseFile = TEMPORARY_FOLDER.newFolder();
        Assert.assertTrue((String)"The warehouse should be deleted", (boolean)warehouseFile.delete());
        warehouse = "file:" + warehouseFile;
    }

    @Before
    public void before() {
        this.sql("CREATE CATALOG %s WITH ('type'='iceberg', 'catalog-type'='hadoop', 'warehouse'='%s')", CATALOG_NAME, warehouse);
        this.sql("USE CATALOG %s", CATALOG_NAME);
        this.sql("CREATE DATABASE %s", DATABASE_NAME);
        this.sql("USE %s", DATABASE_NAME);
        this.sql("CREATE TABLE %s (id INT, data VARCHAR,d DOUBLE) WITH ('write.format.default'='%s')", TABLE_NAME, this.format.name());
        this.sql("INSERT INTO %s VALUES (1,'iceberg',10),(2,'b',20),(3,CAST(NULL AS VARCHAR),30)", TABLE_NAME);
        this.scanEventCount = 0;
        this.lastScanEvent = null;
    }

    @After
    public void clean() {
        this.sql("DROP TABLE IF EXISTS %s.%s", DATABASE_NAME, TABLE_NAME);
        this.sql("DROP DATABASE IF EXISTS %s", DATABASE_NAME);
        this.dropCatalog(CATALOG_NAME, true);
    }

    @Test
    public void testLimitPushDown() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s LIMIT -1", TABLE_NAME)).isInstanceOf(SqlParserException.class)).hasMessageStartingWith("SQL parse failed.");
        Assert.assertEquals((String)"Should have 0 record", (long)0L, (long)this.sql("SELECT * FROM %s LIMIT 0", TABLE_NAME).size());
        String sqlLimitExceed = String.format("SELECT * FROM %s LIMIT 4", TABLE_NAME);
        List<Row> resultExceed = this.sql(sqlLimitExceed, new Object[0]);
        Assert.assertEquals((String)"Should have 3 records", (long)3L, (long)resultExceed.size());
        ArrayList expectedList = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0}), Row.of((Object[])new Object[]{3, null, 30.0})});
        this.assertSameElements(expectedList, resultExceed);
        String querySql = String.format("SELECT * FROM %s LIMIT 1", TABLE_NAME);
        String explain = this.getTableEnv().explainSql(querySql, new ExplainDetail[0]);
        String expectedExplain = "limit=[1]";
        Assert.assertTrue((String)"Explain should contain LimitPushDown", (boolean)explain.contains(expectedExplain));
        List<Row> result = this.sql(querySql, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)result.size());
        Assertions.assertThat(result).containsAnyElementsOf((Iterable)expectedList);
        String sqlMixed = String.format("SELECT * FROM %s WHERE id = 1 LIMIT 2", TABLE_NAME);
        List<Row> mixedResult = this.sql(sqlMixed, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)mixedResult.size());
        Assert.assertEquals((String)"Should produce the expected records", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)mixedResult.get(0));
    }

    @Test
    public void testNoFilterPushDown() {
        String sql = String.format("SELECT * FROM %s ", TABLE_NAME);
        List<Row> result = this.sql(sql, new Object[0]);
        ArrayList expectedRecords = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0}), Row.of((Object[])new Object[]{3, null, 30.0})});
        this.assertSameElements(expectedRecords, result);
        Assert.assertEquals((String)"Should not push down a filter", (Object)Expressions.alwaysTrue(), (Object)this.lastScanEvent.filter());
    }

    @Test
    public void testFilterPushDownEqual() {
        String sqlLiteralRight = String.format("SELECT * FROM %s WHERE id = 1 ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") == 1";
        List<Row> result = this.sql(sqlLiteralRight, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)result.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownEqualNull() {
        String sqlEqualNull = String.format("SELECT * FROM %s WHERE data = NULL ", TABLE_NAME);
        List<Row> result = this.sql(sqlEqualNull, new Object[0]);
        Assert.assertEquals((String)"Should have 0 record", (long)0L, (long)result.size());
        Assert.assertNull((String)"Should not push down a filter", (Object)this.lastScanEvent);
    }

    @Test
    public void testFilterPushDownEqualLiteralOnLeft() {
        String sqlLiteralLeft = String.format("SELECT * FROM %s WHERE 1 = id ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") == 1";
        List<Row> resultLeft = this.sql(sqlLiteralLeft, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLeft.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)resultLeft.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownNoEqual() {
        String sqlNE = String.format("SELECT * FROM %s WHERE id <> 1 ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") != 1";
        List<Row> resultNE = this.sql(sqlNE, new Object[0]);
        Assert.assertEquals((String)"Should have 2 records", (long)2L, (long)resultNE.size());
        ArrayList expectedNE = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "b", 20.0}), Row.of((Object[])new Object[]{3, null, 30.0})});
        this.assertSameElements(expectedNE, resultNE);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownNoEqualNull() {
        String sqlNotEqualNull = String.format("SELECT * FROM %s WHERE data <> NULL ", TABLE_NAME);
        List<Row> resultNE = this.sql(sqlNotEqualNull, new Object[0]);
        Assert.assertEquals((String)"Should have 0 records", (long)0L, (long)resultNE.size());
        Assert.assertNull((String)"Should not push down a filter", (Object)this.lastScanEvent);
    }

    @Test
    public void testFilterPushDownAnd() {
        String sqlAnd = String.format("SELECT * FROM %s WHERE id = 1 AND data = 'iceberg' ", TABLE_NAME);
        List<Row> resultAnd = this.sql(sqlAnd, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultAnd.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)resultAnd.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        String expected = "(ref(name=\"id\") == 1 and ref(name=\"data\") == \"iceberg\")";
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expected, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownOr() {
        String sqlOr = String.format("SELECT * FROM %s WHERE id = 1 OR data = 'b' ", TABLE_NAME);
        String expectedFilter = "(ref(name=\"id\") == 1 or ref(name=\"data\") == \"b\")";
        List<Row> resultOr = this.sql(sqlOr, new Object[0]);
        Assert.assertEquals((String)"Should have 2 record", (long)2L, (long)resultOr.size());
        ArrayList expectedOR = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0})});
        this.assertSameElements(expectedOR, resultOr);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownGreaterThan() {
        String sqlGT = String.format("SELECT * FROM %s WHERE id > 1 ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") > 1";
        List<Row> resultGT = this.sql(sqlGT, new Object[0]);
        Assert.assertEquals((String)"Should have 2 record", (long)2L, (long)resultGT.size());
        ArrayList expectedGT = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "b", 20.0}), Row.of((Object[])new Object[]{3, null, 30.0})});
        this.assertSameElements(expectedGT, resultGT);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownGreaterThanNull() {
        String sqlGT = String.format("SELECT * FROM %s WHERE data > null ", TABLE_NAME);
        List<Row> resultGT = this.sql(sqlGT, new Object[0]);
        Assert.assertEquals((String)"Should have 0 record", (long)0L, (long)resultGT.size());
        Assert.assertNull((String)"Should not push down a filter", (Object)this.lastScanEvent);
    }

    @Test
    public void testFilterPushDownGreaterThanLiteralOnLeft() {
        String sqlGT = String.format("SELECT * FROM %s WHERE 3 > id ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") < 3";
        List<Row> resultGT = this.sql(sqlGT, new Object[0]);
        Assert.assertEquals((String)"Should have 2 records", (long)2L, (long)resultGT.size());
        ArrayList expectedGT = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0})});
        this.assertSameElements(expectedGT, resultGT);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownGreaterThanEqual() {
        String sqlGTE = String.format("SELECT * FROM %s WHERE id >= 2 ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") >= 2";
        List<Row> resultGTE = this.sql(sqlGTE, new Object[0]);
        Assert.assertEquals((String)"Should have 2 records", (long)2L, (long)resultGTE.size());
        ArrayList expectedGTE = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "b", 20.0}), Row.of((Object[])new Object[]{3, null, 30.0})});
        this.assertSameElements(expectedGTE, resultGTE);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownGreaterThanEqualNull() {
        String sqlGTE = String.format("SELECT * FROM %s WHERE data >= null ", TABLE_NAME);
        List<Row> resultGT = this.sql(sqlGTE, new Object[0]);
        Assert.assertEquals((String)"Should have 0 record", (long)0L, (long)resultGT.size());
        Assert.assertNull((String)"Should not push down a filter", (Object)this.lastScanEvent);
    }

    @Test
    public void testFilterPushDownGreaterThanEqualLiteralOnLeft() {
        String sqlGTE = String.format("SELECT * FROM %s WHERE 2 >= id ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") <= 2";
        List<Row> resultGTE = this.sql(sqlGTE, new Object[0]);
        Assert.assertEquals((String)"Should have 2 records", (long)2L, (long)resultGTE.size());
        ArrayList expectedGTE = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0})});
        this.assertSameElements(expectedGTE, resultGTE);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownLessThan() {
        String sqlLT = String.format("SELECT * FROM %s WHERE id < 2 ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") < 2";
        List<Row> resultLT = this.sql(sqlLT, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLT.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)resultLT.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownLessThanNull() {
        String sqlLT = String.format("SELECT * FROM %s WHERE data < null ", TABLE_NAME);
        List<Row> resultGT = this.sql(sqlLT, new Object[0]);
        Assert.assertEquals((String)"Should have 0 record", (long)0L, (long)resultGT.size());
        Assert.assertNull((String)"Should not push down a filter", (Object)this.lastScanEvent);
    }

    @Test
    public void testFilterPushDownLessThanLiteralOnLeft() {
        String sqlLT = String.format("SELECT * FROM %s WHERE 2 < id ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") > 2";
        List<Row> resultLT = this.sql(sqlLT, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLT.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{3, null, 30.0}), (Object)resultLT.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownLessThanEqual() {
        String sqlLTE = String.format("SELECT * FROM %s WHERE id <= 1 ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") <= 1";
        List<Row> resultLTE = this.sql(sqlLTE, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLTE.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)resultLTE.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownLessThanEqualNull() {
        String sqlLTE = String.format("SELECT * FROM %s WHERE data <= null ", TABLE_NAME);
        List<Row> resultGT = this.sql(sqlLTE, new Object[0]);
        Assert.assertEquals((String)"Should have 0 record", (long)0L, (long)resultGT.size());
        Assert.assertNull((String)"Should not push down a filter", (Object)this.lastScanEvent);
    }

    @Test
    public void testFilterPushDownLessThanEqualLiteralOnLeft() {
        String sqlLTE = String.format("SELECT * FROM %s WHERE 3 <= id  ", TABLE_NAME);
        String expectedFilter = "ref(name=\"id\") >= 3";
        List<Row> resultLTE = this.sql(sqlLTE, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLTE.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{3, null, 30.0}), (Object)resultLTE.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownIn() {
        String sqlIN = String.format("SELECT * FROM %s WHERE id IN (1,2) ", TABLE_NAME);
        String expectedFilter = "(ref(name=\"id\") == 1 or ref(name=\"id\") == 2)";
        List<Row> resultIN = this.sql(sqlIN, new Object[0]);
        Assert.assertEquals((String)"Should have 2 records", (long)2L, (long)resultIN.size());
        ArrayList expectedIN = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0})});
        this.assertSameElements(expectedIN, resultIN);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownInNull() {
        String sqlInNull = String.format("SELECT * FROM %s WHERE data IN ('iceberg',NULL) ", TABLE_NAME);
        List<Row> result = this.sql(sqlInNull, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)result.get(0));
        String expectedScan = "ref(name=\"data\") == \"iceberg\"";
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedScan, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownNotIn() {
        String sqlNotIn = String.format("SELECT * FROM %s WHERE id NOT IN (3,2) ", TABLE_NAME);
        List<Row> resultNotIn = this.sql(sqlNotIn, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultNotIn.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)resultNotIn.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        String expectedScan = "(ref(name=\"id\") != 2 and ref(name=\"id\") != 3)";
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedScan, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownNotInNull() {
        String sqlNotInNull = String.format("SELECT * FROM %s WHERE id NOT IN (1,2,NULL) ", TABLE_NAME);
        List<Row> resultGT = this.sql(sqlNotInNull, new Object[0]);
        Assert.assertEquals((String)"Should have 0 record", (long)0L, (long)resultGT.size());
        Assert.assertNull((String)"As the predicate pushdown filter out all rows, Flink did not create scan plan, so it doesn't publish any ScanEvent.", (Object)this.lastScanEvent);
    }

    @Test
    public void testFilterPushDownIsNotNull() {
        String sqlNotNull = String.format("SELECT * FROM %s WHERE data IS NOT NULL", TABLE_NAME);
        String expectedFilter = "not_null(ref(name=\"data\"))";
        List<Row> resultNotNull = this.sql(sqlNotNull, new Object[0]);
        Assert.assertEquals((String)"Should have 2 record", (long)2L, (long)resultNotNull.size());
        ArrayList expected = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0})});
        this.assertSameElements(expected, resultNotNull);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownIsNull() {
        String sqlNull = String.format("SELECT * FROM %s WHERE data IS  NULL", TABLE_NAME);
        String expectedFilter = "is_null(ref(name=\"data\"))";
        List<Row> resultNull = this.sql(sqlNull, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultNull.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{3, null, 30.0}), (Object)resultNull.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownNot() {
        String sqlNot = String.format("SELECT * FROM %s WHERE NOT (id = 1 OR id = 2 ) ", TABLE_NAME);
        List<Row> resultNot = this.sql(sqlNot, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultNot.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{3, null, 30.0}), (Object)resultNot.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        String expectedFilter = "(ref(name=\"id\") != 1 and ref(name=\"id\") != 2)";
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownBetween() {
        String sqlBetween = String.format("SELECT * FROM %s WHERE id BETWEEN 1 AND 2 ", TABLE_NAME);
        List<Row> resultBetween = this.sql(sqlBetween, new Object[0]);
        Assert.assertEquals((String)"Should have 2 record", (long)2L, (long)resultBetween.size());
        ArrayList expectedBetween = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0})});
        this.assertSameElements(expectedBetween, resultBetween);
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        String expected = "(ref(name=\"id\") >= 1 and ref(name=\"id\") <= 2)";
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expected, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownNotBetween() {
        String sqlNotBetween = String.format("SELECT * FROM %s WHERE id  NOT BETWEEN 2 AND 3 ", TABLE_NAME);
        String expectedFilter = "(ref(name=\"id\") < 2 or ref(name=\"id\") > 3)";
        List<Row> resultNotBetween = this.sql(sqlNotBetween, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultNotBetween.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)resultNotBetween.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterPushDownLike() {
        String expectedFilter = "ref(name=\"data\") startsWith \"\"ice\"\"";
        String sqlLike = "SELECT * FROM test_table WHERE data LIKE 'ice%%' ";
        List<Row> resultLike = this.sql(sqlLike, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLike.size());
        Assert.assertEquals((String)"The like result should produce the expected record", (Object)Row.of((Object[])new Object[]{1, "iceberg", 10.0}), (Object)resultLike.get(0));
        Assert.assertEquals((String)"Should create only one scan", (long)1L, (long)this.scanEventCount);
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedFilter, (Object)this.lastScanEvent.filter().toString());
        sqlLike = "SELECT * FROM  test_table  WHERE data LIKE '%%' ";
        resultLike = this.sql(sqlLike, new Object[0]);
        Assert.assertEquals((String)"Should have 2 records", (long)2L, (long)resultLike.size());
        ArrayList expectedRecords = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0})});
        this.assertSameElements(expectedRecords, resultLike);
        String expectedScan = "not_null(ref(name=\"data\"))";
        Assert.assertEquals((String)"Should contain the push down filter", (Object)expectedScan, (Object)this.lastScanEvent.filter().toString());
    }

    @Test
    public void testFilterNotPushDownLike() {
        Row expectRecord = Row.of((Object[])new Object[]{1, "iceberg", 10.0});
        String sqlNoPushDown = "SELECT * FROM test_table WHERE data LIKE '%%i' ";
        List<Row> resultLike = this.sql(sqlNoPushDown, new Object[0]);
        Assert.assertEquals((String)"Should have 0 record", (long)0L, (long)resultLike.size());
        Assert.assertEquals((String)"Should not push down a filter", (Object)Expressions.alwaysTrue(), (Object)this.lastScanEvent.filter());
        sqlNoPushDown = "SELECT * FROM test_table WHERE data LIKE '%%i%%' ";
        resultLike = this.sql(sqlNoPushDown, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLike.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)expectRecord, (Object)resultLike.get(0));
        Assert.assertEquals((String)"Should not push down a filter", (Object)Expressions.alwaysTrue(), (Object)this.lastScanEvent.filter());
        sqlNoPushDown = "SELECT * FROM  test_table  WHERE data LIKE '%%ice%%g' ";
        resultLike = this.sql(sqlNoPushDown, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLike.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)expectRecord, (Object)resultLike.get(0));
        Assert.assertEquals((String)"Should not push down a filter", (Object)Expressions.alwaysTrue(), (Object)this.lastScanEvent.filter());
        sqlNoPushDown = "SELECT * FROM  test_table  WHERE data LIKE 'iceber_' ";
        resultLike = this.sql(sqlNoPushDown, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLike.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)expectRecord, (Object)resultLike.get(0));
        Assert.assertEquals((String)"Should not push down a filter", (Object)Expressions.alwaysTrue(), (Object)this.lastScanEvent.filter());
        sqlNoPushDown = "SELECT * FROM  test_table  WHERE data LIKE 'i%%g' ";
        resultLike = this.sql(sqlNoPushDown, new Object[0]);
        Assert.assertEquals((String)"Should have 1 record", (long)1L, (long)resultLike.size());
        Assert.assertEquals((String)"Should produce the expected record", (Object)expectRecord, (Object)resultLike.get(0));
        Assert.assertEquals((String)"Should not push down a filter", (Object)Expressions.alwaysTrue(), (Object)this.lastScanEvent.filter());
    }

    @Test
    public void testFilterPushDown2Literal() {
        String sql2Literal = String.format("SELECT * FROM %s WHERE 1 > 0 ", TABLE_NAME);
        List<Row> result = this.sql(sql2Literal, new Object[0]);
        ArrayList expectedRecords = Lists.newArrayList((Object[])new Row[]{Row.of((Object[])new Object[]{1, "iceberg", 10.0}), Row.of((Object[])new Object[]{2, "b", 20.0}), Row.of((Object[])new Object[]{3, null, 30.0})});
        this.assertSameElements(expectedRecords, result);
        Assert.assertEquals((String)"Should not push down a filter", (Object)Expressions.alwaysTrue(), (Object)this.lastScanEvent.filter());
    }

    @Test
    public void testSqlParseNaN() {
    }
}

