/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.util.CloseableIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.source.IcebergSource;
import org.apache.iceberg.flink.source.TestFlinkReaderDeletesBase;
import org.apache.iceberg.flink.source.assigner.SimpleSplitAssignerFactory;
import org.apache.iceberg.flink.source.assigner.SplitAssignerFactory;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class TestIcebergSourceReaderDeletes
extends TestFlinkReaderDeletesBase {
    private static final int PARALLELISM = 4;
    @ClassRule
    public static final TemporaryFolder TMP_FOLDER = new TemporaryFolder();
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).build());

    public TestIcebergSourceReaderDeletes(FileFormat inputFormat) {
        super(inputFormat);
    }

    protected StructLikeSet rowSet(String tableName, Table testTable, String ... columns) throws IOException {
        Schema projected = testTable.schema().select(columns);
        RowType rowType = FlinkSchemaUtil.convert((Schema)projected);
        HashMap properties = Maps.newHashMap();
        properties.put("warehouse", hiveConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
        properties.put("uri", hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname));
        properties.put("clients", Integer.toString(hiveConf.getInt("iceberg.hive.client-pool-size", 5)));
        CatalogLoader hiveCatalogLoader = CatalogLoader.hive((String)catalog.name(), (Configuration)hiveConf, (Map)properties);
        TableLoader hiveTableLoader = TableLoader.fromCatalog((CatalogLoader)hiveCatalogLoader, (TableIdentifier)TableIdentifier.of((String[])new String[]{"default", tableName}));
        hiveTableLoader.open();
        Throwable throwable = null;
        try (TableLoader tableLoader = hiveTableLoader;){
            StructLikeSet structLikeSet;
            block15: {
                StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
                env.setParallelism(1);
                DataStreamSource stream = env.fromSource((Source)IcebergSource.builder().tableLoader(tableLoader).assignerFactory((SplitAssignerFactory)new SimpleSplitAssignerFactory()).project(projected).build(), WatermarkStrategy.noWatermarks(), "testBasicRead", TypeInformation.of(RowData.class));
                CloseableIterator iter = stream.executeAndCollect();
                Throwable throwable2 = null;
                try {
                    ArrayList rowDataList = Lists.newArrayList((Iterator)iter);
                    StructLikeSet set = StructLikeSet.create((Types.StructType)projected.asStruct());
                    rowDataList.forEach(rowData -> {
                        RowDataWrapper wrapper = new RowDataWrapper(rowType, projected.asStruct());
                        set.add((StructLike)wrapper.wrap(rowData));
                    });
                    structLikeSet = set;
                    if (iter == null) break block15;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (iter != null) {
                                    TestIcebergSourceReaderDeletes.$closeResource(throwable2, (AutoCloseable)iter);
                                }
                                throw throwable4;
                            }
                        }
                        catch (Exception e) {
                            throw new IOException("Failed to collect result", e);
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                TestIcebergSourceReaderDeletes.$closeResource(throwable2, (AutoCloseable)iter);
            }
            return structLikeSet;
        }
    }
}

