/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.types.Row;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.HadoopCatalogResource;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.TableLoader;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.source.FlinkSource;
import org.apache.iceberg.flink.source.SourceUtil;
import org.apache.iceberg.flink.source.SqlHelpers;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class TestSqlBase {
    @ClassRule
    public static final MiniClusterWithClientResource MINI_CLUSTER_RESOURCE = MiniClusterResource.createWithClassloaderCheckDisabled();
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    @Rule
    public final HadoopCatalogResource catalogResource = new HadoopCatalogResource(TEMPORARY_FOLDER, "default", "t");
    private volatile TableEnvironment tEnv;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableEnvironment getTableEnv() {
        if (this.tEnv == null) {
            TestSqlBase testSqlBase = this;
            synchronized (testSqlBase) {
                if (this.tEnv == null) {
                    this.tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
                }
            }
        }
        return this.tEnv;
    }

    @Before
    public abstract void before() throws IOException;

    @Test
    public void testResiduals() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA, TestFixtures.SPEC);
        List writeRecords = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)0L);
        ((Record)writeRecords.get(0)).set(1, (Object)123L);
        ((Record)writeRecords.get(0)).set(2, (Object)"2020-03-20");
        ((Record)writeRecords.get(1)).set(1, (Object)456L);
        ((Record)writeRecords.get(1)).set(2, (Object)"2020-03-20");
        GenericAppenderHelper helper = new GenericAppenderHelper(table, FileFormat.PARQUET, TEMPORARY_FOLDER);
        ArrayList expectedRecords = Lists.newArrayList();
        expectedRecords.add((Record)writeRecords.get(0));
        DataFile dataFile1 = helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), writeRecords);
        DataFile dataFile2 = helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-21", 0}), RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)0L));
        helper.appendToTable(new DataFile[]{dataFile1, dataFile2});
        TestHelpers.assertRecords(this.run(Maps.newHashMap(), "where dt='2020-03-20' and id=123", "*"), expectedRecords, TestFixtures.SCHEMA);
    }

    @Test
    public void testExposeLocality() throws Exception {
        Table table = this.catalogResource.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA, TestFixtures.SPEC);
        TableLoader tableLoader = TableLoader.fromHadoopTable((String)table.location());
        List expectedRecords = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)10, (long)0L);
        expectedRecords.forEach(expectedRecord -> expectedRecord.set(2, (Object)"2020-03-20"));
        GenericAppenderHelper helper = new GenericAppenderHelper(table, FileFormat.PARQUET, TEMPORARY_FOLDER);
        DataFile dataFile = helper.writeFile((StructLike)TestHelpers.Row.of((Object[])new Object[]{"2020-03-20", 0}), expectedRecords);
        helper.appendToTable(new DataFile[]{dataFile});
        Configuration tableConf = this.getTableEnv().getConfig().getConfiguration();
        tableConf.setBoolean(FlinkConfigOptions.TABLE_EXEC_ICEBERG_EXPOSE_SPLIT_LOCALITY_INFO.key(), false);
        List<Row> results = SqlHelpers.sql(this.getTableEnv(), "select * from t", new Object[0]);
        TestHelpers.assertRecords(results, expectedRecords, TestFixtures.SCHEMA);
        tableConf.setBoolean(FlinkConfigOptions.TABLE_EXEC_ICEBERG_EXPOSE_SPLIT_LOCALITY_INFO.key(), true);
        FlinkSource.Builder builder = FlinkSource.forRowData().tableLoader(tableLoader).table(table);
        Assert.assertFalse((String)"Expose split locality info should be false.", (boolean)SourceUtil.isLocalityEnabled((Table)table, (ReadableConfig)tableConf, (Boolean)true));
        results = this.run(Maps.newHashMap(), "where dt='2020-03-20'", "*");
        TestHelpers.assertRecords(results, expectedRecords, TestFixtures.SCHEMA);
    }

    protected List<Row> run(Map<String, String> options, String sqlFilter, String ... sqlSelectedFields) {
        String select = String.join((CharSequence)",", sqlSelectedFields);
        String optionStr = SqlHelpers.sqlOptionsToString(options);
        return SqlHelpers.sql(this.getTableEnv(), "select %s from t %s %s", select, optionStr, sqlFilter);
    }
}

