/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.assigner;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.flink.source.SplitHelpers;
import org.apache.iceberg.flink.source.assigner.GetSplitResult;
import org.apache.iceberg.flink.source.assigner.SplitAssigner;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class SplitAssignerTestBase {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @Test
    public void testEmptyInitialization() {
        SplitAssigner assigner = this.splitAssigner();
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
    }

    @Test
    public void testStaticEnumeratorSequence() throws Exception {
        SplitAssigner assigner = this.splitAssigner();
        assigner.onDiscoveredSplits(SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 4, 1));
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertSnapshot(assigner, 1);
        assigner.onUnassignedSplits(SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 1, 1));
        this.assertSnapshot(assigner, 2);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
        this.assertSnapshot(assigner, 0);
    }

    @Test
    public void testContinuousEnumeratorSequence() throws Exception {
        SplitAssigner assigner = this.splitAssigner();
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
        List<IcebergSourceSplit> splits1 = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 1, 1);
        this.assertAvailableFuture(assigner, 1, () -> assigner.onDiscoveredSplits((Collection)splits1));
        List<IcebergSourceSplit> splits2 = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 1, 1);
        this.assertAvailableFuture(assigner, 1, () -> assigner.onUnassignedSplits((Collection)splits2));
        assigner.onDiscoveredSplits(SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 2, 1));
        this.assertSnapshot(assigner, 2);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
        this.assertSnapshot(assigner, 0);
    }

    private void assertAvailableFuture(SplitAssigner assigner, int splitCount, Runnable addSplitsRunnable) {
        AtomicBoolean futureCompleted = new AtomicBoolean();
        CompletableFuture future = assigner.isAvailable();
        future.thenAccept(ignored -> futureCompleted.set(true));
        Assert.assertSame((Object)future, (Object)assigner.isAvailable());
        addSplitsRunnable.run();
        Assert.assertEquals((Object)true, (Object)futureCompleted.get());
        for (int i = 0; i < splitCount; ++i) {
            this.assertGetNext(assigner, GetSplitResult.Status.AVAILABLE);
        }
        this.assertGetNext(assigner, GetSplitResult.Status.UNAVAILABLE);
        this.assertSnapshot(assigner, 0);
    }

    protected void assertGetNext(SplitAssigner assigner, GetSplitResult.Status expectedStatus) {
        GetSplitResult result = assigner.getNext(null);
        Assert.assertEquals((Object)expectedStatus, (Object)result.status());
        switch (expectedStatus) {
            case AVAILABLE: {
                Assert.assertNotNull((Object)result.split());
                break;
            }
            case CONSTRAINED: 
            case UNAVAILABLE: {
                Assert.assertNull((Object)result.split());
                break;
            }
            default: {
                Assert.fail((String)("Unknown status: " + expectedStatus));
            }
        }
    }

    protected void assertSnapshot(SplitAssigner assigner, int splitCount) {
        Collection stateBeforeGet = assigner.state();
        Assert.assertEquals((long)splitCount, (long)stateBeforeGet.size());
    }

    protected abstract SplitAssigner splitAssigner();
}

