/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.flink.HadoopTableResource;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.StreamingStartingStrategy;
import org.apache.iceberg.flink.source.enumerator.ContinuousSplitPlannerImpl;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public class TestContinuousSplitPlannerImplStartStrategy {
    private static final FileFormat FILE_FORMAT = FileFormat.PARQUET;
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    public final HadoopTableResource tableResource = new HadoopTableResource(this.temporaryFolder, "default", "t", TestFixtures.SCHEMA);
    @Rule
    public final TestRule chain = RuleChain.outerRule((TestRule)this.temporaryFolder).around((TestRule)this.tableResource);
    private GenericAppenderHelper dataAppender;
    private Snapshot snapshot1;
    private Snapshot snapshot2;
    private Snapshot snapshot3;

    @Before
    public void before() throws IOException {
        this.dataAppender = new GenericAppenderHelper(this.tableResource.table(), FILE_FORMAT, this.temporaryFolder);
    }

    private void appendThreeSnapshots() throws IOException {
        List batch1 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)0L);
        this.dataAppender.appendToTable(batch1);
        this.snapshot1 = this.tableResource.table().currentSnapshot();
        List batch2 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)1L);
        this.dataAppender.appendToTable(batch2);
        this.snapshot2 = this.tableResource.table().currentSnapshot();
        List batch3 = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)2L);
        this.dataAppender.appendToTable(batch3);
        this.snapshot3 = this.tableResource.table().currentSnapshot();
    }

    @Test
    public void testTableScanThenIncrementalStrategy() throws IOException {
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL).build();
        Assert.assertFalse((boolean)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContext).isPresent());
        this.appendThreeSnapshots();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContext).get();
        Assert.assertEquals((long)this.snapshot3.snapshotId(), (long)startSnapshot.snapshotId());
    }

    @Test
    public void testForLatestSnapshotStrategy() throws IOException {
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_LATEST_SNAPSHOT).build();
        Assert.assertFalse((boolean)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContext).isPresent());
        this.appendThreeSnapshots();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContext).get();
        Assert.assertEquals((long)this.snapshot3.snapshotId(), (long)startSnapshot.snapshotId());
    }

    @Test
    public void testForEarliestSnapshotStrategy() throws IOException {
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_EARLIEST_SNAPSHOT).build();
        Assert.assertFalse((boolean)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContext).isPresent());
        this.appendThreeSnapshots();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContext).get();
        Assert.assertEquals((long)this.snapshot1.snapshotId(), (long)startSnapshot.snapshotId());
    }

    @Test
    public void testForSpecificSnapshotIdStrategy() throws IOException {
        ScanContext scanContextInvalidSnapshotId = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).startSnapshotId(Long.valueOf(1L)).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContextInvalidSnapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Start snapshot id not found in history: 1");
        this.appendThreeSnapshots();
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID).startSnapshotId(Long.valueOf(this.snapshot2.snapshotId())).build();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContext).get();
        Assert.assertEquals((long)this.snapshot2.snapshotId(), (long)startSnapshot.snapshotId());
    }

    @Test
    public void testForSpecificSnapshotTimestampStrategySnapshot2() throws IOException {
        ScanContext scanContextInvalidSnapshotTimestamp = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(1L)).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContextInvalidSnapshotTimestamp)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot find a snapshot after: ");
        this.appendThreeSnapshots();
        ScanContext scanContext = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(this.snapshot2.timestampMillis())).build();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)scanContext).get();
        Assert.assertEquals((long)this.snapshot2.snapshotId(), (long)startSnapshot.snapshotId());
    }

    @Test
    public void testForSpecificSnapshotTimestampStrategySnapshot2Minus1() throws IOException {
        this.appendThreeSnapshots();
        ScanContext config = ScanContext.builder().streaming(true).startingStrategy(StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_TIMESTAMP).startSnapshotTimestamp(Long.valueOf(this.snapshot2.timestampMillis() - 1L)).build();
        Snapshot startSnapshot = (Snapshot)ContinuousSplitPlannerImpl.startSnapshot((Table)this.tableResource.table(), (ScanContext)config).get();
        Assert.assertEquals((long)this.snapshot2.snapshotId(), (long)startSnapshot.snapshotId());
    }
}

