/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import org.apache.iceberg.flink.source.enumerator.EnumerationHistory;
import org.junit.Assert;
import org.junit.Test;

public class TestEnumerationHistory {
    private static final int MAX_HISTORY_SIZE = 3;
    private static final int FEW_PENDING_SPLITS = 2;
    private static final int TOO_MANY_PENDING_SPLITS = 100;

    @Test
    public void testEmptyHistory() {
        EnumerationHistory history = new EnumerationHistory(3);
        int[] expectedHistorySnapshot = new int[]{};
        this.testHistory(history, expectedHistorySnapshot);
    }

    @Test
    public void testNotFullHistory() {
        EnumerationHistory history = new EnumerationHistory(3);
        history.add(1);
        history.add(2);
        int[] expectedHistorySnapshot = new int[]{1, 2};
        this.testHistory(history, expectedHistorySnapshot);
    }

    @Test
    public void testExactFullHistory() {
        EnumerationHistory history = new EnumerationHistory(3);
        history.add(1);
        history.add(2);
        history.add(3);
        int[] expectedHistorySnapshot = new int[]{1, 2, 3};
        this.testHistory(history, expectedHistorySnapshot);
    }

    @Test
    public void testOneMoreThanFullHistory() {
        EnumerationHistory history = new EnumerationHistory(3);
        history.add(1);
        history.add(2);
        history.add(3);
        history.add(4);
        int[] expectedHistorySnapshot = new int[]{2, 3, 4};
        this.testHistory(history, expectedHistorySnapshot);
    }

    @Test
    public void testTwoMoreThanFullHistory() {
        EnumerationHistory history = new EnumerationHistory(3);
        history.add(1);
        history.add(2);
        history.add(3);
        history.add(4);
        history.add(5);
        int[] expectedHistorySnapshot = new int[]{3, 4, 5};
        this.testHistory(history, expectedHistorySnapshot);
    }

    @Test
    public void testThreeMoreThanFullHistory() {
        EnumerationHistory history = new EnumerationHistory(3);
        history.add(1);
        history.add(2);
        history.add(3);
        history.add(4);
        history.add(5);
        history.add(6);
        int[] expectedHistorySnapshot = new int[]{4, 5, 6};
        this.testHistory(history, expectedHistorySnapshot);
    }

    private void testHistory(EnumerationHistory history, int[] expectedHistorySnapshot) {
        Assert.assertFalse((boolean)history.shouldPauseSplitDiscovery(2));
        if (history.hasFullHistory()) {
            Assert.assertTrue((boolean)history.shouldPauseSplitDiscovery(100));
        } else {
            Assert.assertFalse((boolean)history.shouldPauseSplitDiscovery(100));
        }
        int[] historySnapshot = history.snapshot();
        Assert.assertArrayEquals((int[])expectedHistorySnapshot, (int[])historySnapshot);
        EnumerationHistory restoredHistory = new EnumerationHistory(3);
        restoredHistory.restore(historySnapshot);
        Assert.assertFalse((boolean)history.shouldPauseSplitDiscovery(2));
        if (history.hasFullHistory()) {
            Assert.assertTrue((boolean)history.shouldPauseSplitDiscovery(100));
        } else {
            Assert.assertFalse((boolean)history.shouldPauseSplitDiscovery(30));
        }
    }

    @Test
    public void testRestoreDifferentSize() {
        EnumerationHistory history = new EnumerationHistory(3);
        history.add(1);
        history.add(2);
        history.add(3);
        int[] historySnapshot = history.snapshot();
        EnumerationHistory smallerHistory = new EnumerationHistory(2);
        smallerHistory.restore(historySnapshot);
        int[] expectedRestoredHistorySnapshot = new int[]{2, 3};
        Assert.assertArrayEquals((int[])expectedRestoredHistorySnapshot, (int[])smallerHistory.snapshot());
        EnumerationHistory largerHisotry = new EnumerationHistory(4);
        largerHisotry.restore(historySnapshot);
        Assert.assertArrayEquals((int[])historySnapshot, (int[])largerHisotry.snapshot());
    }
}

