/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.iceberg.flink.source.SplitHelpers;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorPosition;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorState;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorStateSerializer;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitState;
import org.apache.iceberg.flink.source.split.IcebergSourceSplitStatus;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestIcebergEnumeratorStateSerializer {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    private final IcebergEnumeratorStateSerializer serializer = new IcebergEnumeratorStateSerializer(true);
    protected final int version;

    @Parameterized.Parameters(name="version={0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestIcebergEnumeratorStateSerializer(int version) {
        this.version = version;
    }

    @Test
    public void testEmptySnapshotIdAndPendingSplits() throws Exception {
        IcebergEnumeratorState enumeratorState = new IcebergEnumeratorState(Collections.emptyList());
        this.testSerializer(enumeratorState);
    }

    @Test
    public void testSomeSnapshotIdAndEmptyPendingSplits() throws Exception {
        IcebergEnumeratorPosition position = IcebergEnumeratorPosition.of((long)1L, (Long)System.currentTimeMillis());
        IcebergEnumeratorState enumeratorState = new IcebergEnumeratorState(position, Collections.emptyList());
        this.testSerializer(enumeratorState);
    }

    @Test
    public void testSomeSnapshotIdAndPendingSplits() throws Exception {
        IcebergEnumeratorPosition position = IcebergEnumeratorPosition.of((long)2L, (Long)System.currentTimeMillis());
        List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 3, 1);
        ArrayList pendingSplits = Lists.newArrayList();
        pendingSplits.add(new IcebergSourceSplitState(splits.get(0), IcebergSourceSplitStatus.UNASSIGNED));
        pendingSplits.add(new IcebergSourceSplitState(splits.get(1), IcebergSourceSplitStatus.ASSIGNED));
        pendingSplits.add(new IcebergSourceSplitState(splits.get(2), IcebergSourceSplitStatus.COMPLETED));
        IcebergEnumeratorState enumeratorState = new IcebergEnumeratorState(position, (Collection)pendingSplits);
        this.testSerializer(enumeratorState);
    }

    @Test
    public void testEnumerationSplitCountHistory() throws Exception {
        if (this.version == 2) {
            IcebergEnumeratorPosition position = IcebergEnumeratorPosition.of((long)2L, (Long)System.currentTimeMillis());
            List<IcebergSourceSplit> splits = SplitHelpers.createSplitsFromTransientHadoopTable(TEMPORARY_FOLDER, 3, 1);
            ArrayList pendingSplits = Lists.newArrayList();
            pendingSplits.add(new IcebergSourceSplitState(splits.get(0), IcebergSourceSplitStatus.UNASSIGNED));
            pendingSplits.add(new IcebergSourceSplitState(splits.get(1), IcebergSourceSplitStatus.ASSIGNED));
            pendingSplits.add(new IcebergSourceSplitState(splits.get(2), IcebergSourceSplitStatus.COMPLETED));
            int[] enumerationSplitCountHistory = new int[]{1, 2, 3};
            IcebergEnumeratorState enumeratorState = new IcebergEnumeratorState(position, (Collection)pendingSplits, enumerationSplitCountHistory);
            this.testSerializer(enumeratorState);
        }
    }

    private void testSerializer(IcebergEnumeratorState enumeratorState) throws IOException {
        byte[] result = this.version == 1 ? this.serializer.serializeV1(enumeratorState) : this.serializer.serialize(enumeratorState);
        IcebergEnumeratorState deserialized = this.serializer.deserialize(this.version, result);
        this.assertEnumeratorStateEquals(enumeratorState, deserialized);
    }

    private void assertEnumeratorStateEquals(IcebergEnumeratorState expected, IcebergEnumeratorState actual) {
        Assert.assertEquals((Object)expected.lastEnumeratedPosition(), (Object)actual.lastEnumeratedPosition());
        Assert.assertEquals((long)expected.pendingSplits().size(), (long)actual.pendingSplits().size());
        Iterator expectedIterator = expected.pendingSplits().iterator();
        Iterator actualIterator = actual.pendingSplits().iterator();
        for (int i = 0; i < expected.pendingSplits().size(); ++i) {
            IcebergSourceSplitState expectedSplitState = (IcebergSourceSplitState)expectedIterator.next();
            IcebergSourceSplitState actualSplitState = (IcebergSourceSplitState)actualIterator.next();
            Assert.assertEquals((Object)expectedSplitState.split().splitId(), (Object)actualSplitState.split().splitId());
            Assert.assertEquals((long)expectedSplitState.split().fileOffset(), (long)actualSplitState.split().fileOffset());
            Assert.assertEquals((long)expectedSplitState.split().recordOffset(), (long)actualSplitState.split().recordOffset());
            Assert.assertEquals((Object)expectedSplitState.status(), (Object)actualSplitState.status());
        }
        Assert.assertArrayEquals((int[])expected.enumerationSplitCountHistory(), (int[])actual.enumerationSplitCountHistory());
    }
}

