/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.flink.source.reader.ArrayBatchRecords;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.junit.Assert;
import org.junit.Test;

public class TestArrayBatchRecords {
    @Test
    public void testFullRange() {
        String[] elements = new String[]{"0", "1", "2", "3"};
        this.testArray(elements, elements.length, 2, 119L);
    }

    @Test
    public void testSubRange() {
        String[] elements = new String[]{"0", "1", "2", "3"};
        this.testArray(elements, 2, 0, 0L);
    }

    private void testArray(String[] elements, int numberOfRecords, int fileOffset, long startingRecordOffset) {
        String splitId = "iceberg_split_1";
        AtomicBoolean recycled = new AtomicBoolean();
        ArrayBatchRecords recordsWithSplitIds = ArrayBatchRecords.forRecords((String)splitId, ignored -> recycled.set(true), (Object[])elements, (int)numberOfRecords, (int)fileOffset, (long)startingRecordOffset);
        Assert.assertEquals((Object)splitId, (Object)recordsWithSplitIds.nextSplit());
        for (int i = 0; i < numberOfRecords; ++i) {
            RecordAndPosition recAndPos = recordsWithSplitIds.nextRecordFromSplit();
            Assert.assertEquals((Object)elements[i], (Object)recAndPos.record());
            Assert.assertEquals((long)fileOffset, (long)recAndPos.fileOffset());
            Assert.assertEquals((long)(startingRecordOffset + (long)i + 1L), (long)recAndPos.recordOffset());
        }
        Assert.assertNull((Object)recordsWithSplitIds.nextRecordFromSplit());
        Assert.assertNull((Object)recordsWithSplitIds.nextSplit());
        recordsWithSplitIds.recycle();
        Assert.assertTrue((boolean)recycled.get());
    }
}

