/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.iceberg.Schema;
import org.apache.iceberg.flink.FlinkFixupTypes;
import org.apache.iceberg.flink.FlinkTypeToType;
import org.apache.iceberg.flink.TypeToFlinkType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class FlinkSchemaUtil {
    private FlinkSchemaUtil() {
    }

    public static Schema convert(TableSchema schema) {
        LogicalType schemaType = schema.toRowDataType().getLogicalType();
        Preconditions.checkArgument((boolean)(schemaType instanceof RowType), (Object)"Schema logical type should be RowType.");
        RowType root = (RowType)schemaType;
        Type converted = (Type)root.accept((LogicalTypeVisitor)new FlinkTypeToType(root));
        Schema iSchema = new Schema(converted.asStructType().fields());
        return FlinkSchemaUtil.freshIdentifierFieldIds(iSchema, schema);
    }

    private static Schema freshIdentifierFieldIds(Schema iSchema, TableSchema schema) {
        HashSet identifierFieldIds = Sets.newHashSet();
        if (schema.getPrimaryKey().isPresent()) {
            for (String column : ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns()) {
                Types.NestedField field = iSchema.findField(column);
                Preconditions.checkNotNull((Object)field, (String)"Cannot find field ID for the primary key column %s in schema %s", (Object)column, (Object)iSchema);
                identifierFieldIds.add(field.fieldId());
            }
        }
        return new Schema(iSchema.schemaId(), iSchema.asStruct().fields(), (Set)identifierFieldIds);
    }

    public static Schema convert(Schema baseSchema, TableSchema flinkSchema) {
        Types.StructType struct = FlinkSchemaUtil.convert(flinkSchema).asStruct();
        Schema schema = TypeUtil.reassignIds((Schema)new Schema(struct.fields()), (Schema)baseSchema);
        schema = TypeUtil.reassignDoc((Schema)schema, (Schema)baseSchema);
        Schema fixedSchema = FlinkFixupTypes.fixup(schema, baseSchema);
        return FlinkSchemaUtil.freshIdentifierFieldIds(fixedSchema, flinkSchema);
    }

    public static RowType convert(Schema schema) {
        return (RowType)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new TypeToFlinkType());
    }

    public static LogicalType convert(Type type) {
        return (LogicalType)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new TypeToFlinkType());
    }

    public static Type convert(LogicalType flinkType) {
        return (Type)flinkType.accept((LogicalTypeVisitor)new FlinkTypeToType());
    }

    public static TableSchema toSchema(RowType rowType) {
        TableSchema.Builder builder = TableSchema.builder();
        for (RowType.RowField field : rowType.getFields()) {
            builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
        }
        return builder.build();
    }

    public static TableSchema toSchema(Schema schema) {
        TableSchema.Builder builder = TableSchema.builder();
        for (RowType.RowField field : FlinkSchemaUtil.convert(schema).getFields()) {
            builder.field(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)field.getType()));
        }
        Set identifierFieldIds = schema.identifierFieldIds();
        if (!identifierFieldIds.isEmpty()) {
            ArrayList columns = Lists.newArrayListWithExpectedSize((int)identifierFieldIds.size());
            for (Integer identifierFieldId : identifierFieldIds) {
                String columnName = schema.findColumnName(identifierFieldId.intValue());
                Preconditions.checkNotNull((Object)columnName, (String)"Cannot find field with id %s in schema %s", (Object)identifierFieldId, (Object)schema);
                columns.add(columnName);
            }
            builder.primaryKey(columns.toArray(new String[0]));
        }
        return builder.build();
    }
}

