/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.io.Decoder;
import org.apache.avro.util.Utf8;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;

public class FlinkValueReaders {
    private FlinkValueReaders() {
    }

    static ValueReader<StringData> strings() {
        return StringReader.INSTANCE;
    }

    static ValueReader<StringData> enums(List<String> symbols) {
        return new EnumReader(symbols);
    }

    static ValueReader<byte[]> uuids() {
        return ValueReaders.fixed((int)16);
    }

    static ValueReader<Integer> timeMicros() {
        return TimeMicrosReader.INSTANCE;
    }

    static ValueReader<TimestampData> timestampMills() {
        return TimestampMillsReader.INSTANCE;
    }

    static ValueReader<TimestampData> timestampMicros() {
        return TimestampMicrosReader.INSTANCE;
    }

    static ValueReader<DecimalData> decimal(ValueReader<byte[]> unscaledReader, int precision, int scale) {
        return new DecimalReader(unscaledReader, precision, scale);
    }

    static ValueReader<ArrayData> array(ValueReader<?> elementReader) {
        return new ArrayReader(elementReader);
    }

    static ValueReader<MapData> arrayMap(ValueReader<?> keyReader, ValueReader<?> valueReader) {
        return new ArrayMapReader(keyReader, valueReader);
    }

    static ValueReader<MapData> map(ValueReader<?> keyReader, ValueReader<?> valueReader) {
        return new MapReader(keyReader, valueReader);
    }

    static ValueReader<RowData> struct(List<ValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
        return new StructReader(readers, struct, idToConstant);
    }

    private static MapData kvArrayToMap(List<Object> keyList, List<Object> valueList) {
        HashMap map = Maps.newHashMap();
        Object[] keys = keyList.toArray();
        Object[] values = valueList.toArray();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return new GenericMapData((Map)map);
    }

    private static class StructReader
    extends ValueReaders.StructReader<RowData> {
        private final int numFields;

        private StructReader(List<ValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
            super(readers, struct, idToConstant);
            this.numFields = readers.size();
        }

        protected RowData reuseOrCreate(Object reuse) {
            if (reuse instanceof GenericRowData && ((GenericRowData)reuse).getArity() == this.numFields) {
                return (GenericRowData)reuse;
            }
            return new GenericRowData(this.numFields);
        }

        protected Object get(RowData struct, int pos) {
            return null;
        }

        protected void set(RowData struct, int pos, Object value) {
            ((GenericRowData)struct).setField(pos, value);
        }
    }

    private static class MapReader
    implements ValueReader<MapData> {
        private final ValueReader<?> keyReader;
        private final ValueReader<?> valueReader;
        private final List<Object> reusedKeyList = Lists.newArrayList();
        private final List<Object> reusedValueList = Lists.newArrayList();

        private MapReader(ValueReader<?> keyReader, ValueReader<?> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        public MapData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedKeyList.clear();
            this.reusedValueList.clear();
            long chunkLength = decoder.readMapStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedKeyList.add(this.keyReader.read(decoder, null));
                    this.reusedValueList.add(this.valueReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.mapNext();
            }
            return FlinkValueReaders.kvArrayToMap(this.reusedKeyList, this.reusedValueList);
        }
    }

    private static class ArrayMapReader
    implements ValueReader<MapData> {
        private final ValueReader<?> keyReader;
        private final ValueReader<?> valueReader;
        private final List<Object> reusedKeyList = Lists.newArrayList();
        private final List<Object> reusedValueList = Lists.newArrayList();

        private ArrayMapReader(ValueReader<?> keyReader, ValueReader<?> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        public MapData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedKeyList.clear();
            this.reusedValueList.clear();
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedKeyList.add(this.keyReader.read(decoder, null));
                    this.reusedValueList.add(this.valueReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
            return FlinkValueReaders.kvArrayToMap(this.reusedKeyList, this.reusedValueList);
        }
    }

    private static class ArrayReader
    implements ValueReader<ArrayData> {
        private final ValueReader<?> elementReader;
        private final List<Object> reusedList = Lists.newArrayList();

        private ArrayReader(ValueReader<?> elementReader) {
            this.elementReader = elementReader;
        }

        public GenericArrayData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedList.clear();
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedList.add(this.elementReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
            return new GenericArrayData(this.reusedList.toArray());
        }
    }

    private static class TimestampMicrosReader
    implements ValueReader<TimestampData> {
        private static final TimestampMicrosReader INSTANCE = new TimestampMicrosReader();

        private TimestampMicrosReader() {
        }

        public TimestampData read(Decoder decoder, Object reuse) throws IOException {
            long micros = decoder.readLong();
            long mills = micros / 1000L;
            int nanos = (int)(micros % 1000L) * 1000;
            if (nanos < 0) {
                nanos += 1000000;
                --mills;
            }
            return TimestampData.fromEpochMillis((long)mills, (int)nanos);
        }
    }

    private static class TimestampMillsReader
    implements ValueReader<TimestampData> {
        private static final TimestampMillsReader INSTANCE = new TimestampMillsReader();

        private TimestampMillsReader() {
        }

        public TimestampData read(Decoder decoder, Object reuse) throws IOException {
            return TimestampData.fromEpochMillis((long)decoder.readLong());
        }
    }

    private static class TimeMicrosReader
    implements ValueReader<Integer> {
        private static final TimeMicrosReader INSTANCE = new TimeMicrosReader();

        private TimeMicrosReader() {
        }

        public Integer read(Decoder decoder, Object reuse) throws IOException {
            long micros = decoder.readLong();
            return (int)(micros / 1000L);
        }
    }

    private static class DecimalReader
    implements ValueReader<DecimalData> {
        private final ValueReader<byte[]> bytesReader;
        private final int precision;
        private final int scale;

        private DecimalReader(ValueReader<byte[]> bytesReader, int precision, int scale) {
            this.bytesReader = bytesReader;
            this.precision = precision;
            this.scale = scale;
        }

        public DecimalData read(Decoder decoder, Object reuse) throws IOException {
            byte[] bytes = (byte[])this.bytesReader.read(decoder, null);
            return DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(new BigInteger(bytes), this.scale), (int)this.precision, (int)this.scale);
        }
    }

    private static class EnumReader
    implements ValueReader<StringData> {
        private final StringData[] symbols;

        private EnumReader(List<String> symbols) {
            this.symbols = new StringData[symbols.size()];
            for (int i = 0; i < this.symbols.length; ++i) {
                this.symbols[i] = StringData.fromBytes((byte[])symbols.get(i).getBytes(StandardCharsets.UTF_8));
            }
        }

        public StringData read(Decoder decoder, Object ignore) throws IOException {
            int index = decoder.readEnum();
            return this.symbols[index];
        }
    }

    private static class StringReader
    implements ValueReader<StringData> {
        private static final StringReader INSTANCE = new StringReader();

        private StringReader() {
        }

        public StringData read(Decoder decoder, Object reuse) throws IOException {
            Utf8 utf8 = null;
            if (reuse instanceof StringData) {
                utf8 = new Utf8(((StringData)reuse).toBytes());
            }
            Utf8 string = decoder.readString(utf8);
            return StringData.fromBytes((byte[])string.getBytes(), (int)0, (int)string.getByteLength());
        }
    }
}

