/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.util.FlinkCompatibilityUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;

public class FlinkAlterTableUtil {
    private FlinkAlterTableUtil() {
    }

    public static void commitChanges(Table table, String setLocation, String setSnapshotId, String pickSnapshotId, Map<String, String> setProperties) {
        FlinkAlterTableUtil.commitManageSnapshots(table, setSnapshotId, pickSnapshotId);
        Transaction transaction = table.newTransaction();
        if (setLocation != null) {
            transaction.updateLocation().setLocation(setLocation).commit();
        }
        if (!setProperties.isEmpty()) {
            UpdateProperties updateProperties = transaction.updateProperties();
            setProperties.forEach((k, v) -> {
                if (v == null) {
                    updateProperties.remove(k);
                } else {
                    updateProperties.set(k, v);
                }
            });
            updateProperties.commit();
        }
        transaction.commitTransaction();
    }

    public static void commitChanges(Table table, String setLocation, String setSnapshotId, String pickSnapshotId, List<TableChange> schemaChanges, List<TableChange> propertyChanges) {
        FlinkAlterTableUtil.commitManageSnapshots(table, setSnapshotId, pickSnapshotId);
        Transaction transaction = table.newTransaction();
        if (setLocation != null) {
            transaction.updateLocation().setLocation(setLocation).commit();
        }
        if (!schemaChanges.isEmpty()) {
            UpdateSchema updateSchema = transaction.updateSchema();
            FlinkAlterTableUtil.applySchemaChanges(updateSchema, schemaChanges);
            updateSchema.commit();
        }
        if (!propertyChanges.isEmpty()) {
            UpdateProperties updateProperties = transaction.updateProperties();
            FlinkAlterTableUtil.applyPropertyChanges(updateProperties, propertyChanges);
            updateProperties.commit();
        }
        transaction.commitTransaction();
    }

    public static void commitManageSnapshots(Table table, String setSnapshotId, String cherrypickSnapshotId) {
        long newSnapshotId;
        Preconditions.checkArgument((setSnapshotId == null || cherrypickSnapshotId == null ? 1 : 0) != 0, (Object)"Cannot set the current snapshot ID and cherry-pick snapshot changes");
        if (setSnapshotId != null) {
            newSnapshotId = Long.parseLong(setSnapshotId);
            table.manageSnapshots().setCurrentSnapshot(newSnapshotId).commit();
        }
        if (cherrypickSnapshotId != null) {
            newSnapshotId = Long.parseLong(cherrypickSnapshotId);
            table.manageSnapshots().cherrypick(newSnapshotId).commit();
        }
    }

    public static void applySchemaChanges(UpdateSchema pendingUpdate, List<TableChange> schemaChanges) {
        for (TableChange change : schemaChanges) {
            if (change instanceof TableChange.AddColumn) {
                TableChange.AddColumn addColumn = (TableChange.AddColumn)change;
                Column flinkColumn = addColumn.getColumn();
                Preconditions.checkArgument((boolean)FlinkCompatibilityUtil.isPhysicalColumn(flinkColumn), (String)"Unsupported table change: Adding computed column %s.", (Object)flinkColumn.getName());
                Type icebergType = FlinkSchemaUtil.convert(flinkColumn.getDataType().getLogicalType());
                if (flinkColumn.getDataType().getLogicalType().isNullable()) {
                    pendingUpdate.addColumn(flinkColumn.getName(), icebergType);
                    continue;
                }
                pendingUpdate.addRequiredColumn(flinkColumn.getName(), icebergType);
                continue;
            }
            if (change instanceof TableChange.ModifyColumn) {
                TableChange.ModifyColumn modifyColumn = (TableChange.ModifyColumn)change;
                FlinkAlterTableUtil.applyModifyColumn(pendingUpdate, modifyColumn);
                continue;
            }
            if (change instanceof TableChange.DropColumn) {
                TableChange.DropColumn dropColumn = (TableChange.DropColumn)change;
                pendingUpdate.deleteColumn(dropColumn.getColumnName());
                continue;
            }
            if (change instanceof TableChange.AddWatermark) {
                throw new UnsupportedOperationException("Unsupported table change: AddWatermark.");
            }
            if (change instanceof TableChange.ModifyWatermark) {
                throw new UnsupportedOperationException("Unsupported table change: ModifyWatermark.");
            }
            if (change instanceof TableChange.DropWatermark) {
                throw new UnsupportedOperationException("Unsupported table change: DropWatermark.");
            }
            if (change instanceof TableChange.AddUniqueConstraint) {
                TableChange.AddUniqueConstraint addPk = (TableChange.AddUniqueConstraint)change;
                FlinkAlterTableUtil.applyUniqueConstraint(pendingUpdate, addPk.getConstraint());
                continue;
            }
            if (change instanceof TableChange.ModifyUniqueConstraint) {
                TableChange.ModifyUniqueConstraint modifyPk = (TableChange.ModifyUniqueConstraint)change;
                FlinkAlterTableUtil.applyUniqueConstraint(pendingUpdate, modifyPk.getNewConstraint());
                continue;
            }
            if (change instanceof TableChange.DropConstraint) {
                throw new UnsupportedOperationException("Unsupported table change: DropConstraint.");
            }
            throw new UnsupportedOperationException("Cannot apply unknown table change: " + change);
        }
    }

    public static void applyPropertyChanges(UpdateProperties pendingUpdate, List<TableChange> propertyChanges) {
        for (TableChange change : propertyChanges) {
            if (change instanceof TableChange.SetOption) {
                TableChange.SetOption setOption = (TableChange.SetOption)change;
                pendingUpdate.set(setOption.getKey(), setOption.getValue());
                continue;
            }
            if (change instanceof TableChange.ResetOption) {
                TableChange.ResetOption resetOption = (TableChange.ResetOption)change;
                pendingUpdate.remove(resetOption.getKey());
                continue;
            }
            throw new UnsupportedOperationException("The given table change is not a property change: " + change);
        }
    }

    private static void applyModifyColumn(UpdateSchema pendingUpdate, TableChange.ModifyColumn modifyColumn) {
        if (modifyColumn instanceof TableChange.ModifyColumnName) {
            TableChange.ModifyColumnName modifyName = (TableChange.ModifyColumnName)modifyColumn;
            pendingUpdate.renameColumn(modifyName.getOldColumnName(), modifyName.getNewColumnName());
        } else if (modifyColumn instanceof TableChange.ModifyColumnPosition) {
            TableChange.ModifyColumnPosition modifyPosition = (TableChange.ModifyColumnPosition)modifyColumn;
            FlinkAlterTableUtil.applyModifyColumnPosition(pendingUpdate, modifyPosition);
        } else if (modifyColumn instanceof TableChange.ModifyPhysicalColumnType) {
            TableChange.ModifyPhysicalColumnType modifyType = (TableChange.ModifyPhysicalColumnType)modifyColumn;
            Type type = FlinkSchemaUtil.convert(modifyType.getNewType().getLogicalType());
            String columnName = modifyType.getOldColumn().getName();
            pendingUpdate.updateColumn(columnName, type.asPrimitiveType());
            if (modifyType.getNewColumn().getDataType().getLogicalType().isNullable()) {
                pendingUpdate.makeColumnOptional(columnName);
            } else {
                pendingUpdate.requireColumn(columnName);
            }
        } else if (modifyColumn instanceof TableChange.ModifyColumnComment) {
            TableChange.ModifyColumnComment modifyComment = (TableChange.ModifyColumnComment)modifyColumn;
            pendingUpdate.updateColumnDoc(modifyComment.getOldColumn().getName(), modifyComment.getNewComment());
        } else {
            throw new UnsupportedOperationException("Cannot apply unknown modify-column change: " + modifyColumn);
        }
    }

    private static void applyModifyColumnPosition(UpdateSchema pendingUpdate, TableChange.ModifyColumnPosition modifyColumnPosition) {
        TableChange.ColumnPosition newPosition = modifyColumnPosition.getNewPosition();
        if (newPosition instanceof TableChange.First) {
            pendingUpdate.moveFirst(modifyColumnPosition.getOldColumn().getName());
        } else if (newPosition instanceof TableChange.After) {
            TableChange.After after = (TableChange.After)newPosition;
            pendingUpdate.moveAfter(modifyColumnPosition.getOldColumn().getName(), after.column());
        } else {
            throw new UnsupportedOperationException("Cannot apply unknown modify-column-position change: " + modifyColumnPosition);
        }
    }

    private static void applyUniqueConstraint(UpdateSchema pendingUpdate, UniqueConstraint constraint) {
        switch (constraint.getType()) {
            case PRIMARY_KEY: {
                pendingUpdate.setIdentifierFields((Collection)constraint.getColumns());
                break;
            }
            case UNIQUE_KEY: {
                throw new UnsupportedOperationException("Unsupported table change: setting unique key constraints.");
            }
            default: {
                throw new UnsupportedOperationException("Cannot apply unknown unique constraint: " + constraint.getType().name());
            }
        }
    }
}

