/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.DateTimeUtil;

public class RowDataUtil {
    private RowDataUtil() {
    }

    public static Object convertConstant(Type type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)type;
                return DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)value), (int)decimal.precision(), (int)decimal.scale());
            }
            case STRING: {
                if (value instanceof Utf8) {
                    Utf8 utf8 = (Utf8)value;
                    return StringData.fromBytes((byte[])utf8.getBytes(), (int)0, (int)utf8.getByteLength());
                }
                return StringData.fromString((String)value.toString());
            }
            case FIXED: {
                if (value instanceof byte[]) {
                    return value;
                }
                if (value instanceof GenericData.Fixed) {
                    return ((GenericData.Fixed)value).bytes();
                }
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
            case BINARY: {
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
            case TIME: {
                return (int)((Long)value / 1000L);
            }
            case TIMESTAMP: {
                return TimestampData.fromLocalDateTime((LocalDateTime)DateTimeUtil.timestampFromMicros((long)((Long)value)));
            }
        }
        return value;
    }

    public static RowData clone(RowData from, RowData reuse, RowType rowType, TypeSerializer[] fieldSerializers) {
        GenericRowData ret = reuse instanceof GenericRowData ? (GenericRowData)reuse : new GenericRowData(from.getArity());
        ret.setRowKind(from.getRowKind());
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            if (!from.isNullAt(i)) {
                RowData.FieldGetter getter = RowData.createFieldGetter((LogicalType)rowType.getTypeAt(i), (int)i);
                ret.setField(i, fieldSerializers[i].copy(getter.getFieldOrNull(from)));
                continue;
            }
            ret.setField(i, null);
        }
        return ret;
    }
}

