/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.util.stream.IntStream;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.sink.BucketPartitionerUtil;

class BucketPartitionKeySelector
implements KeySelector<RowData, Integer> {
    private final Schema schema;
    private final PartitionKey partitionKey;
    private final RowType flinkSchema;
    private final int bucketFieldPosition;
    private transient RowDataWrapper rowDataWrapper;

    BucketPartitionKeySelector(PartitionSpec partitionSpec, Schema schema, RowType flinkSchema) {
        this.schema = schema;
        this.partitionKey = new PartitionKey(partitionSpec, schema);
        this.flinkSchema = flinkSchema;
        this.bucketFieldPosition = this.getBucketFieldPosition(partitionSpec);
    }

    private int getBucketFieldPosition(PartitionSpec partitionSpec) {
        int bucketFieldId = BucketPartitionerUtil.getBucketFieldId(partitionSpec);
        return IntStream.range(0, partitionSpec.fields().size()).filter(i -> ((PartitionField)partitionSpec.fields().get(i)).fieldId() == bucketFieldId).toArray()[0];
    }

    private RowDataWrapper lazyRowDataWrapper() {
        if (this.rowDataWrapper == null) {
            this.rowDataWrapper = new RowDataWrapper(this.flinkSchema, this.schema.asStruct());
        }
        return this.rowDataWrapper;
    }

    public Integer getKey(RowData rowData) {
        this.partitionKey.partition((StructLike)this.lazyRowDataWrapper().wrap(rowData));
        return (Integer)this.partitionKey.get(this.bucketFieldPosition, Integer.class);
    }
}

