/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.HadoopCatalogResource;
import org.junit.rules.TemporaryFolder;

public class HadoopTableResource
extends HadoopCatalogResource {
    private final Schema schema;
    private final PartitionSpec partitionSpec;
    private Table table;

    public HadoopTableResource(TemporaryFolder temporaryFolder, String database, String tableName, Schema schema) {
        this(temporaryFolder, database, tableName, schema, null);
    }

    public HadoopTableResource(TemporaryFolder temporaryFolder, String database, String tableName, Schema schema, PartitionSpec partitionSpec) {
        super(temporaryFolder, database, tableName);
        this.schema = schema;
        this.partitionSpec = partitionSpec;
    }

    @Override
    protected void before() throws Throwable {
        super.before();
        this.table = this.partitionSpec == null ? this.catalog.createTable(TableIdentifier.of((String[])new String[]{this.database, this.tableName}), this.schema) : this.catalog.createTable(TableIdentifier.of((String[])new String[]{this.database, this.tableName}), this.schema, this.partitionSpec);
        this.tableLoader.open();
    }

    public Table table() {
        return this.table;
    }
}

