/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.MiniFlinkClusterExtension;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.hive.TestHiveMetastore;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

public abstract class TestBase
extends TestBaseUtils {
    @RegisterExtension
    public static MiniClusterExtension miniClusterResource = MiniFlinkClusterExtension.createWithClassloaderCheckDisabled();
    @TempDir
    protected Path temporaryDirectory;
    private static TestHiveMetastore metastore = null;
    protected static HiveConf hiveConf = null;
    protected static HiveCatalog catalog = null;
    private volatile TableEnvironment tEnv = null;

    @BeforeAll
    public static void startMetastore() {
        metastore = new TestHiveMetastore();
        metastore.start();
        hiveConf = metastore.hiveConf();
        catalog = (HiveCatalog)CatalogUtil.loadCatalog((String)HiveCatalog.class.getName(), (String)"hive", (Map)ImmutableMap.of(), (Object)hiveConf);
    }

    @AfterAll
    public static void stopMetastore() throws Exception {
        metastore.stop();
        catalog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableEnvironment getTableEnv() {
        if (this.tEnv == null) {
            TestBase testBase = this;
            synchronized (testBase) {
                if (this.tEnv == null) {
                    EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
                    TableEnvironment env = TableEnvironment.create((EnvironmentSettings)settings);
                    env.getConfig().getConfiguration().set(FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM, (Object)false);
                    this.tEnv = env;
                }
            }
        }
        return this.tEnv;
    }

    protected static TableResult exec(TableEnvironment env, String query, Object ... args) {
        return env.executeSql(String.format(query, args));
    }

    protected TableResult exec(String query, Object ... args) {
        return TestBase.exec(this.getTableEnv(), query, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Row> sql(String query, Object ... args) {
        TableResult tableResult = this.exec(query, args);
        try (CloseableIterator iter = tableResult.collect();){
            ArrayList arrayList = Lists.newArrayList((Iterator)iter);
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to collect table result", e);
        }
    }

    protected void assertSameElements(Iterable<Row> expected, Iterable<Row> actual) {
        ((IterableAssert)Assertions.assertThat(actual).isNotNull()).containsExactlyInAnyOrderElementsOf(expected);
    }

    protected void assertSameElements(String message, Iterable<Row> expected, Iterable<Row> actual) {
        ((IterableAssert)((IterableAssert)Assertions.assertThat(actual).isNotNull()).as(message, new Object[0])).containsExactlyInAnyOrderElementsOf(expected);
    }

    protected void dropCatalog(String catalogName, boolean ifExists) {
        this.sql("USE CATALOG default_catalog", new Object[0]);
        this.sql("DROP CATALOG %s %s", ifExists ? "IF EXISTS" : "", catalogName);
    }
}

