/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.TestBase;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestCatalogLoader
extends TestBase {
    private static File warehouse = null;
    private static final TableIdentifier IDENTIFIER = TableIdentifier.of((String[])new String[]{"default", "my_table"});
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"f1", (Type)Types.StringType.get())});

    @BeforeAll
    public static void createWarehouse() throws IOException {
        warehouse = File.createTempFile("warehouse", null);
        Assertions.assertThat((boolean)warehouse.delete()).isTrue();
        hiveConf.set("my_key", "my_value");
    }

    @AfterAll
    public static void dropWarehouse() throws IOException {
        if (warehouse != null && warehouse.exists()) {
            Path warehousePath = new Path(warehouse.getAbsolutePath());
            FileSystem fs = warehousePath.getFileSystem((Configuration)hiveConf);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.delete(warehousePath, true)).as("Failed to delete " + warehousePath, new Object[0])).isTrue();
        }
    }

    @Test
    public void testHadoopCatalogLoader() throws IOException, ClassNotFoundException {
        HashMap properties = Maps.newHashMap();
        properties.put("warehouse", "file:" + warehouse);
        CatalogLoader loader = CatalogLoader.hadoop((String)"my_catalog", (Configuration)hiveConf, (Map)properties);
        TestCatalogLoader.validateCatalogLoader(loader);
    }

    @Test
    public void testHiveCatalogLoader() throws IOException, ClassNotFoundException {
        CatalogLoader loader = CatalogLoader.hive((String)"my_catalog", (Configuration)hiveConf, (Map)Maps.newHashMap());
        TestCatalogLoader.validateCatalogLoader(loader);
    }

    @Test
    public void testRESTCatalogLoader() {
        HashMap properties = Maps.newHashMap();
        properties.put("uri", "http://localhost/");
        CatalogLoader.rest((String)"my_catalog", (Configuration)hiveConf, (Map)Maps.newHashMap());
    }

    private static void validateCatalogLoader(CatalogLoader loader) throws IOException, ClassNotFoundException {
        Table table = TestCatalogLoader.javaSerAndDeSer(loader).loadCatalog().createTable(IDENTIFIER, SCHEMA);
        TestCatalogLoader.validateHadoopConf(table);
    }

    private static void validateHadoopConf(Table table) {
        FileIO io = table.io();
        ((ObjectAssert)Assertions.assertThat((Object)io).as("FileIO should be a HadoopFileIO", new Object[0])).isInstanceOf(HadoopFileIO.class);
        HadoopFileIO hadoopIO = (HadoopFileIO)io;
        Assertions.assertThat((Iterable)hadoopIO.conf()).contains((Object[])new Map.Entry[]{Assertions.entry((Object)"my_key", (Object)"my_value")});
    }

    private static <T> T javaSerAndDeSer(T object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(object);
        }
        var3_3 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            Object object2 = in.readObject();
            return (T)object2;
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }
}

