/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.iceberg.flink.TestBase;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public class TestFlinkAnonymousTable
extends TestBase {
    @Test
    public void testWriteAnonymousTable() throws Exception {
        File warehouseDir = Files.createTempDirectory(this.temporaryDirectory, "junit", new FileAttribute[0]).toFile();
        TableEnvironment tEnv = this.getTableEnv();
        Table table = tEnv.from(TableDescriptor.forConnector((String)"datagen").schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build()).option("number-of-rows", "3").build());
        TableDescriptor descriptor = TableDescriptor.forConnector((String)"iceberg").schema(Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.STRING()).build()).option("catalog-name", "hadoop_test").option("catalog-type", "hadoop").option("catalog-database", "test_db").option("catalog-table", "test").option("warehouse", warehouseDir.getAbsolutePath()).build();
        table.insertInto(descriptor).execute();
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((File)warehouseDir.toPath().resolve("test_db").resolve("test").toFile()).exists());
    }
}

