/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.iceberg.expressions.And;
import org.apache.iceberg.expressions.BoundLiteralPredicate;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Not;
import org.apache.iceberg.expressions.Or;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.flink.FlinkFilters;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.Pair;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestFlinkFilters {
    private static final TableSchema TABLE_SCHEMA = TableSchema.builder().field("field1", DataTypes.INT()).field("field2", DataTypes.BIGINT()).field("field3", DataTypes.FLOAT()).field("field4", DataTypes.DOUBLE()).field("field5", DataTypes.STRING()).field("field6", DataTypes.BOOLEAN()).field("field7", DataTypes.BINARY((int)2)).field("field8", DataTypes.DECIMAL((int)10, (int)2)).field("field9", DataTypes.DATE()).field("field10", DataTypes.TIME()).field("field11", DataTypes.TIMESTAMP()).field("field12", DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE()).build();
    private static final List<Pair<String, Object>> FIELD_VALUE_LIST = ImmutableList.of((Object)Pair.of((Object)"field1", (Object)1), (Object)Pair.of((Object)"field2", (Object)2L), (Object)Pair.of((Object)"field3", (Object)Float.valueOf(3.0f)), (Object)Pair.of((Object)"field4", (Object)4.0), (Object)Pair.of((Object)"field5", (Object)"iceberg"), (Object)Pair.of((Object)"field6", (Object)true), (Object)Pair.of((Object)"field7", (Object)new byte[]{97, 98}), (Object)Pair.of((Object)"field8", (Object)BigDecimal.valueOf(10.12)), (Object)Pair.of((Object)"field9", (Object)DateTimeUtil.daysFromDate((LocalDate)LocalDate.now())), (Object)Pair.of((Object)"field10", (Object)DateTimeUtil.microsFromTime((LocalTime)LocalTime.now())), (Object)Pair.of((Object)"field11", (Object)DateTimeUtil.microsFromTimestamp((LocalDateTime)LocalDateTime.now())), (Object)Pair.of((Object)"field12", (Object)DateTimeUtil.microsFromInstant((Instant)Instant.now())), (Object[])new Pair[0]);

    @Test
    public void testFlinkDataTypeEqual() {
        this.matchLiteral("field1", 1, 1);
        this.matchLiteral("field2", 10L, 10L);
        this.matchLiteral("field3", Float.valueOf(1.2f), Float.valueOf(1.2f));
        this.matchLiteral("field4", 3.4, 3.4);
        this.matchLiteral("field5", "abcd", "abcd");
        this.matchLiteral("field6", true, true);
        this.matchLiteral("field7", new byte[]{97, 98}, ByteBuffer.wrap(new byte[]{97, 98}));
        this.matchLiteral("field8", BigDecimal.valueOf(10.12), BigDecimal.valueOf(10.12));
        LocalDate date = LocalDate.parse("2020-12-23");
        this.matchLiteral("field9", date, DateTimeUtil.daysFromDate((LocalDate)date));
        LocalTime time = LocalTime.parse("12:13:14");
        this.matchLiteral("field10", time, DateTimeUtil.microsFromTime((LocalTime)time));
        LocalDateTime dateTime = LocalDateTime.parse("2020-12-23T12:13:14");
        this.matchLiteral("field11", dateTime, DateTimeUtil.microsFromTimestamp((LocalDateTime)dateTime));
        Instant instant = Instant.parse("2020-12-23T12:13:14.00Z");
        this.matchLiteral("field12", instant, DateTimeUtil.microsFromInstant((Instant)instant));
    }

    @Test
    public void testEquals() {
        for (Pair<String, Object> pair : FIELD_VALUE_LIST) {
            UnboundPredicate expected = Expressions.equal((String)((String)pair.first()), (Object)pair.second());
            Optional actual = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)((String)pair.first())).isEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)pair.second()))));
            Assertions.assertThat((Optional)actual).isPresent();
            this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
            Optional actual1 = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.lit((Object)pair.second()).isEqual((Object)org.apache.flink.table.api.Expressions.$((String)((String)pair.first())))));
            Assertions.assertThat((Optional)actual1).isPresent();
            this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual1.get());
        }
    }

    @Test
    public void testEqualsNaN() {
        UnboundPredicate expected = Expressions.isNaN((String)"field3");
        Optional actual = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)"field3").isEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)Float.valueOf(Float.NaN)))));
        Assertions.assertThat((Optional)actual).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
        Optional actual1 = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.lit((Object)Float.valueOf(Float.NaN)).isEqual((Object)org.apache.flink.table.api.Expressions.$((String)"field3"))));
        Assertions.assertThat((Optional)actual1).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual1.get());
    }

    @Test
    public void testNotEquals() {
        for (Pair<String, Object> pair : FIELD_VALUE_LIST) {
            UnboundPredicate expected = Expressions.notEqual((String)((String)pair.first()), (Object)pair.second());
            Optional actual = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)((String)pair.first())).isNotEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)pair.second()))));
            Assertions.assertThat((Optional)actual).isPresent();
            this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
            Optional actual1 = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.lit((Object)pair.second()).isNotEqual((Object)org.apache.flink.table.api.Expressions.$((String)((String)pair.first())))));
            Assertions.assertThat((Optional)actual1).isPresent();
            this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual1.get());
        }
    }

    @Test
    public void testNotEqualsNaN() {
        UnboundPredicate expected = Expressions.notNaN((String)"field3");
        Optional actual = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)"field3").isNotEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)Float.valueOf(Float.NaN)))));
        Assertions.assertThat((Optional)actual).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
        Optional actual1 = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.lit((Object)Float.valueOf(Float.NaN)).isNotEqual((Object)org.apache.flink.table.api.Expressions.$((String)"field3"))));
        Assertions.assertThat((Optional)actual1).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual1.get());
    }

    @Test
    public void testGreaterThan() {
        UnboundPredicate expected = Expressions.greaterThan((String)"field1", (Object)1);
        Optional actual = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)"field1").isGreater((Object)org.apache.flink.table.api.Expressions.lit((Object)1))));
        Assertions.assertThat((Optional)actual).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
        Optional actual1 = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.lit((Object)1).isLess((Object)org.apache.flink.table.api.Expressions.$((String)"field1"))));
        Assertions.assertThat((Optional)actual1).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual1.get());
    }

    @Test
    public void testGreaterThanEquals() {
        UnboundPredicate expected = Expressions.greaterThanOrEqual((String)"field1", (Object)1);
        Optional actual = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)"field1").isGreaterOrEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)1))));
        Assertions.assertThat((Optional)actual).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
        Optional actual1 = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.lit((Object)1).isLessOrEqual((Object)org.apache.flink.table.api.Expressions.$((String)"field1"))));
        Assertions.assertThat((Optional)actual1).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual1.get());
    }

    @Test
    public void testLessThan() {
        UnboundPredicate expected = Expressions.lessThan((String)"field1", (Object)1);
        Optional actual = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)"field1").isLess((Object)org.apache.flink.table.api.Expressions.lit((Object)1))));
        Assertions.assertThat((Optional)actual).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
        Optional actual1 = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.lit((Object)1).isGreater((Object)org.apache.flink.table.api.Expressions.$((String)"field1"))));
        Assertions.assertThat((Optional)actual1).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual1.get());
    }

    @Test
    public void testLessThanEquals() {
        UnboundPredicate expected = Expressions.lessThanOrEqual((String)"field1", (Object)1);
        Optional actual = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)"field1").isLessOrEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)1))));
        Assertions.assertThat((Optional)actual).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
        Optional actual1 = FlinkFilters.convert((Expression)TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.lit((Object)1).isGreaterOrEqual((Object)org.apache.flink.table.api.Expressions.$((String)"field1"))));
        Assertions.assertThat((Optional)actual1).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual1.get());
    }

    @Test
    public void testIsNull() {
        Expression expr = TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)"field1").isNull());
        Optional actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isPresent();
        UnboundPredicate expected = Expressions.isNull((String)"field1");
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
    }

    @Test
    public void testIsNotNull() {
        Expression expr = TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)"field1").isNotNull());
        Optional actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isPresent();
        UnboundPredicate expected = Expressions.notNull((String)"field1");
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
    }

    @Test
    public void testAnd() {
        Expression expr = TestFlinkFilters.resolve((Expression)((ApiExpression)org.apache.flink.table.api.Expressions.$((String)"field1").isEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)1))).and(org.apache.flink.table.api.Expressions.$((String)"field2").isEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)2L))));
        Optional actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isPresent();
        And and = (And)actual.get();
        And expected = (And)Expressions.and((org.apache.iceberg.expressions.Expression)Expressions.equal((String)"field1", (Object)1), (org.apache.iceberg.expressions.Expression)Expressions.equal((String)"field2", (Object)2L));
        this.assertPredicatesMatch(expected.left(), and.left());
        this.assertPredicatesMatch(expected.right(), and.right());
    }

    @Test
    public void testOr() {
        Expression expr = TestFlinkFilters.resolve((Expression)((ApiExpression)org.apache.flink.table.api.Expressions.$((String)"field1").isEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)1))).or(org.apache.flink.table.api.Expressions.$((String)"field2").isEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)2L))));
        Optional actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isPresent();
        Or or = (Or)actual.get();
        Or expected = (Or)Expressions.or((org.apache.iceberg.expressions.Expression)Expressions.equal((String)"field1", (Object)1), (org.apache.iceberg.expressions.Expression)Expressions.equal((String)"field2", (Object)2L));
        this.assertPredicatesMatch(expected.left(), or.left());
        this.assertPredicatesMatch(expected.right(), or.right());
    }

    @Test
    public void testNot() {
        Expression expr = TestFlinkFilters.resolve((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.NOT, (Expression[])new Expression[]{(Expression)org.apache.flink.table.api.Expressions.$((String)"field1").isEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)1))}));
        Optional actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isPresent();
        Not not = (Not)actual.get();
        Not expected = (Not)Expressions.not((org.apache.iceberg.expressions.Expression)Expressions.equal((String)"field1", (Object)1));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)not.op()).as("Predicate operation should match", new Object[0])).isEqualTo((Object)expected.op());
        this.assertPredicatesMatch(expected.child(), not.child());
    }

    @Test
    public void testLike() {
        UnboundPredicate expected = Expressions.startsWith((String)"field5", (String)"abc");
        Expression expr = TestFlinkFilters.resolve((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, (Expression[])new Expression[]{org.apache.flink.table.api.Expressions.$((String)"field5"), org.apache.flink.table.api.Expressions.lit((Object)"abc%")}));
        Optional actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isPresent();
        this.assertPredicatesMatch((org.apache.iceberg.expressions.Expression)expected, (org.apache.iceberg.expressions.Expression)actual.get());
        expr = TestFlinkFilters.resolve((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, (Expression[])new Expression[]{org.apache.flink.table.api.Expressions.$((String)"field5"), org.apache.flink.table.api.Expressions.lit((Object)"%abc")}));
        actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isNotPresent();
        expr = TestFlinkFilters.resolve((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, (Expression[])new Expression[]{org.apache.flink.table.api.Expressions.$((String)"field5"), org.apache.flink.table.api.Expressions.lit((Object)"%abc%")}));
        actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isNotPresent();
        expr = TestFlinkFilters.resolve((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, (Expression[])new Expression[]{org.apache.flink.table.api.Expressions.$((String)"field5"), org.apache.flink.table.api.Expressions.lit((Object)"abc%d")}));
        actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isNotPresent();
        expr = TestFlinkFilters.resolve((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, (Expression[])new Expression[]{org.apache.flink.table.api.Expressions.$((String)"field5"), org.apache.flink.table.api.Expressions.lit((Object)"%")}));
        actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isNotPresent();
        expr = TestFlinkFilters.resolve((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, (Expression[])new Expression[]{org.apache.flink.table.api.Expressions.$((String)"field5"), org.apache.flink.table.api.Expressions.lit((Object)"a_")}));
        actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isNotPresent();
        expr = TestFlinkFilters.resolve((Expression)ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, (Expression[])new Expression[]{org.apache.flink.table.api.Expressions.$((String)"field5"), org.apache.flink.table.api.Expressions.lit((Object)"a%b")}));
        actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isNotPresent();
    }

    private <T> void matchLiteral(String fieldName, Object flinkLiteral, T icebergLiteral) {
        Expression expr = TestFlinkFilters.resolve((Expression)org.apache.flink.table.api.Expressions.$((String)fieldName).isEqual((Object)org.apache.flink.table.api.Expressions.lit((Object)flinkLiteral)));
        Optional actual = FlinkFilters.convert((Expression)expr);
        Assertions.assertThat((Optional)actual).isPresent();
        org.apache.iceberg.expressions.Expression expression = (org.apache.iceberg.expressions.Expression)actual.get();
        ((ObjectAssert)Assertions.assertThat((Object)expression).as("The expression should be a UnboundPredicate", new Object[0])).isInstanceOf(UnboundPredicate.class);
        UnboundPredicate unboundPredicate = (UnboundPredicate)expression;
        org.apache.iceberg.expressions.Expression expression1 = unboundPredicate.bind(FlinkSchemaUtil.convert((TableSchema)TABLE_SCHEMA).asStruct(), false);
        ((ObjectAssert)Assertions.assertThat((Object)expression1).as("The expression should be a BoundLiteralPredicate", new Object[0])).isInstanceOf(BoundLiteralPredicate.class);
        BoundLiteralPredicate predicate = (BoundLiteralPredicate)expression1;
        Assertions.assertThat((boolean)predicate.test(icebergLiteral)).isTrue();
    }

    private static Expression resolve(Expression originalExpression) {
        return (Expression)originalExpression.accept((ExpressionVisitor)new ApiExpressionDefaultVisitor<Expression>(){

            public Expression visit(UnresolvedReferenceExpression unresolvedReference) {
                String name = unresolvedReference.getName();
                Optional field = TABLE_SCHEMA.getTableColumn(name);
                if (field.isPresent()) {
                    int index = TABLE_SCHEMA.getTableColumns().indexOf(field.get());
                    return new FieldReferenceExpression(name, ((TableColumn)field.get()).getType(), 0, index);
                }
                return null;
            }

            public Expression visit(UnresolvedCallExpression unresolvedCall) {
                List children = unresolvedCall.getChildren().stream().map(e -> (ResolvedExpression)e.accept((ExpressionVisitor)this)).collect(Collectors.toList());
                return new CallExpression(unresolvedCall.getFunctionDefinition(), children, DataTypes.STRING());
            }

            public Expression visit(ValueLiteralExpression valueLiteral) {
                return valueLiteral;
            }

            protected Expression defaultMethod(Expression expression) {
                throw new UnsupportedOperationException(String.format("unsupported expression: %s", expression));
            }
        });
    }

    private void assertPredicatesMatch(org.apache.iceberg.expressions.Expression expected, org.apache.iceberg.expressions.Expression actual) {
        ((ObjectAssert)Assertions.assertThat((Object)expected).as("The expected expression should be a UnboundPredicate", new Object[0])).isInstanceOf(UnboundPredicate.class);
        ((ObjectAssert)Assertions.assertThat((Object)actual).as("The actual expression should be a UnboundPredicate", new Object[0])).isInstanceOf(UnboundPredicate.class);
        UnboundPredicate predicateExpected = (UnboundPredicate)expected;
        UnboundPredicate predicateActual = (UnboundPredicate)actual;
        Assertions.assertThat((Comparable)predicateActual.op()).isEqualTo((Object)predicateExpected.op());
        Assertions.assertThat((Object)predicateActual.literal()).isEqualTo((Object)predicateExpected.literal());
        Assertions.assertThat((String)predicateActual.ref().name()).isEqualTo(predicateExpected.ref().name());
    }
}

