/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.types.Row;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.flink.CatalogTestBase;
import org.apache.iceberg.flink.FlinkCatalogFactory;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.TestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.thrift.TException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestIcebergConnector
extends TestBase {
    private static final String TABLE_NAME = "test_table";
    @Parameter(index=0)
    private String catalogName;
    @Parameter(index=1)
    private Map<String, String> properties;
    @Parameter(index=2)
    private boolean isStreaming;
    private volatile TableEnvironment tEnv;

    @Parameters(name="catalogName = {0}, properties = {1}, isStreaming = {2}")
    public static Iterable<Object[]> parameters() {
        return Lists.newArrayList((Object[])new Object[][]{{"testhadoop", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hadoop"), true}, {"testhadoop", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hadoop", (Object)"catalog-table", (Object)"not_existing_table"), true}, {"testhadoop", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hadoop"), false}, {"testhadoop", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hadoop", (Object)"catalog-database", (Object)"not_existing_db"), true}, {"testhadoop", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hadoop", (Object)"catalog-database", (Object)"not_existing_db", (Object)"catalog-table", (Object)"not_existing_table"), true}, {"testhadoop", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hadoop", (Object)"catalog-database", (Object)"not_existing_db"), false}, {"testhive", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hive"), true}, {"testhive", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hive", (Object)"catalog-table", (Object)"not_existing_table"), true}, {"testhive", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hive"), false}, {"testhive", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hive", (Object)"catalog-database", (Object)"not_existing_db"), true}, {"testhive", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hive", (Object)"catalog-database", (Object)"not_existing_db", (Object)"catalog-table", (Object)"not_existing_table"), true}, {"testhive", ImmutableMap.of((Object)"connector", (Object)"iceberg", (Object)"catalog-type", (Object)"hive", (Object)"catalog-database", (Object)"not_existing_db"), false}});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableEnvironment getTableEnv() {
        if (this.tEnv == null) {
            TestIcebergConnector testIcebergConnector = this;
            synchronized (testIcebergConnector) {
                if (this.tEnv == null) {
                    EnvironmentSettings.Builder settingsBuilder = EnvironmentSettings.newInstance();
                    if (this.isStreaming) {
                        settingsBuilder.inStreamingMode();
                        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)MiniClusterResource.DISABLE_CLASSLOADER_CHECK_CONFIG);
                        env.enableCheckpointing(400L);
                        env.setMaxParallelism(2);
                        env.setParallelism(2);
                        this.tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env, (EnvironmentSettings)settingsBuilder.build());
                    } else {
                        settingsBuilder.inBatchMode();
                        this.tEnv = TableEnvironment.create((EnvironmentSettings)settingsBuilder.build());
                    }
                    this.tEnv.getConfig().getConfiguration().set(CoreOptions.DEFAULT_PARALLELISM, (Object)1).set(FlinkConfigOptions.TABLE_EXEC_ICEBERG_INFER_SOURCE_PARALLELISM, (Object)false);
                }
            }
        }
        return this.tEnv;
    }

    @AfterEach
    public void after() throws TException {
        this.sql("DROP TABLE IF EXISTS %s", TABLE_NAME);
        if (this.isHiveCatalog()) {
            try (HiveMetaStoreClient metaStoreClient = new HiveMetaStoreClient(hiveConf);){
                metaStoreClient.dropTable(this.databaseName(), this.tableName());
                if (!this.isDefaultDatabaseName()) {
                    try {
                        metaStoreClient.dropDatabase(this.databaseName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void testCreateConnectorTable() {
        Map<String, String> tableProps = this.createTableProps();
        this.sql("CREATE TABLE %s (id BIGINT, data STRING) WITH %s", TABLE_NAME, this.toWithClause(tableProps));
        this.sql("INSERT INTO %s VALUES (1, 'AAA'), (2, 'BBB'), (3, 'CCC')", TABLE_NAME);
        Assertions.assertThat(this.sql("SELECT * FROM %s", TABLE_NAME)).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1L, "AAA"}), Row.of((Object[])new Object[]{2L, "BBB"}), Row.of((Object[])new Object[]{3L, "CCC"})});
        FlinkCatalogFactory factory = new FlinkCatalogFactory();
        Catalog flinkCatalog = factory.createCatalog(this.catalogName, tableProps, new org.apache.hadoop.conf.Configuration());
        Assertions.assertThat((boolean)flinkCatalog.databaseExists(this.databaseName())).isTrue();
        Assertions.assertThat((boolean)flinkCatalog.tableExists(new ObjectPath(this.databaseName(), this.tableName()))).isTrue();
        this.sql("DROP TABLE %s", TABLE_NAME);
        this.sql("CREATE TABLE %s (id BIGINT, data STRING) WITH %s", TABLE_NAME, this.toWithClause(tableProps));
        Assertions.assertThat(this.sql("SELECT * FROM %s", TABLE_NAME)).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1L, "AAA"}), Row.of((Object[])new Object[]{2L, "BBB"}), Row.of((Object[])new Object[]{3L, "CCC"})});
    }

    @TestTemplate
    public void testCreateTableUnderDefaultDatabase() {
        this.testCreateConnectorTable();
    }

    @TestTemplate
    public void testCatalogDatabaseConflictWithFlinkDatabase() {
        this.sql("CREATE DATABASE IF NOT EXISTS `%s`", this.databaseName());
        this.sql("USE `%s`", this.databaseName());
        try {
            this.testCreateConnectorTable();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE TABLE `default_catalog`.`%s`.`%s`", this.databaseName(), TABLE_NAME)).isInstanceOf(TableException.class)).hasMessageStartingWith("Could not execute CreateTable in path");
        }
        catch (Throwable throwable) {
            this.sql("DROP TABLE IF EXISTS `%s`.`%s`", this.databaseName(), TABLE_NAME);
            if (!this.isDefaultDatabaseName()) {
                this.sql("DROP DATABASE `%s`", this.databaseName());
            }
            throw throwable;
        }
        this.sql("DROP TABLE IF EXISTS `%s`.`%s`", this.databaseName(), TABLE_NAME);
        if (!this.isDefaultDatabaseName()) {
            this.sql("DROP DATABASE `%s`", this.databaseName());
        }
    }

    @TestTemplate
    public void testConnectorTableInIcebergCatalog() {
        HashMap catalogProps = Maps.newHashMap();
        catalogProps.put("type", "iceberg");
        if (this.isHiveCatalog()) {
            catalogProps.put("catalog-type", "hive");
            catalogProps.put("uri", CatalogTestBase.getURI(hiveConf));
        } else {
            catalogProps.put("catalog-type", "hadoop");
        }
        catalogProps.put("warehouse", this.createWarehouse());
        Map<String, String> tableProps = this.createTableProps();
        this.sql("CREATE CATALOG `test_catalog` WITH %s", this.toWithClause(catalogProps));
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE TABLE `test_catalog`.`%s`.`%s` (id BIGINT, data STRING) WITH %s", "default", TABLE_NAME, this.toWithClause(tableProps))).cause().isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot create the table with 'connector'='iceberg' table property in an iceberg catalog, Please create table with 'connector'='iceberg' property in a non-iceberg catalog or create table without 'connector'='iceberg' related properties in an iceberg table.");
        }
        finally {
            this.sql("DROP CATALOG IF EXISTS `test_catalog`", new Object[0]);
        }
    }

    private Map<String, String> createTableProps() {
        HashMap tableProps = Maps.newHashMap(this.properties);
        tableProps.put("catalog-name", this.catalogName);
        tableProps.put("warehouse", this.createWarehouse());
        if (this.isHiveCatalog()) {
            tableProps.put("uri", CatalogTestBase.getURI(hiveConf));
        }
        return tableProps;
    }

    private boolean isHiveCatalog() {
        return "testhive".equalsIgnoreCase(this.catalogName);
    }

    private boolean isDefaultDatabaseName() {
        return "default".equalsIgnoreCase(this.databaseName());
    }

    private String tableName() {
        return this.properties.getOrDefault("catalog-table", TABLE_NAME);
    }

    private String databaseName() {
        return this.properties.getOrDefault("catalog-database", "default_database");
    }

    private String toWithClause(Map<String, String> props) {
        return CatalogTestBase.toWithClause(props);
    }

    private String createWarehouse() {
        try {
            return String.format("file://%s", Files.createTempDirectory(this.temporaryDirectory, "junit", new FileAttribute[0]).toFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

