/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestManifestFileSerialization {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.required((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("double").build();
    private static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-1.parquet").withFileSizeInBytes(0L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{1.0})).withPartitionPath("double=1").withMetrics(new Metrics(Long.valueOf(5L), null, (Map)ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)3L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)2L), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(4L)))).build();
    private static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-2.parquet").withFileSizeInBytes(0L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{Double.NaN})).withPartitionPath("double=NaN").withMetrics(new Metrics(Long.valueOf(1L), null, (Map)ImmutableMap.of((Object)1, (Object)1L, (Object)4, (Object)1L), (Map)ImmutableMap.of((Object)1, (Object)0L, (Object)2, (Object)0L), (Map)ImmutableMap.of((Object)4, (Object)1L), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(0L)), (Map)ImmutableMap.of((Object)1, (Object)TestManifestFileSerialization.longToBuffer(1L)))).build();
    private static final FileIO FILE_IO = new HadoopFileIO(new Configuration());
    @TempDir
    private Path temp;

    @Test
    public void testKryoSerialization() throws IOException {
        KryoSerializer kryo = new KryoSerializer(ManifestFile.class, new ExecutionConfig());
        DataOutputSerializer outputView = new DataOutputSerializer(1024);
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        kryo.serialize((Object)manifest, (DataOutputView)outputView);
        kryo.serialize((Object)manifest.copy(), (DataOutputView)outputView);
        kryo.serialize((Object)GenericManifestFile.copyOf((ManifestFile)manifest).build(), (DataOutputView)outputView);
        DataInputDeserializer inputView = new DataInputDeserializer(outputView.getCopyOfBuffer());
        ManifestFile m1 = (ManifestFile)kryo.deserialize((DataInputView)inputView);
        ManifestFile m2 = (ManifestFile)kryo.deserialize((DataInputView)inputView);
        ManifestFile m3 = (ManifestFile)kryo.deserialize((DataInputView)inputView);
        TestHelpers.assertEquals(manifest, m1);
        TestHelpers.assertEquals(manifest, m2);
        TestHelpers.assertEquals(manifest, m3);
    }

    @Test
    public void testJavaSerialization() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ManifestFile manifest = this.writeManifest(FILE_A, FILE_B);
        try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
            out.writeObject(manifest);
            out.writeObject(manifest.copy());
            out.writeObject(GenericManifestFile.copyOf((ManifestFile)manifest).build());
        }
        var4_4 = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));){
            for (int i = 0; i < 3; ++i) {
                Object obj = in.readObject();
                ((ObjectAssert)Assertions.assertThat((Object)obj).as("Should be a ManifestFile", new Object[0])).isInstanceOf(ManifestFile.class);
                TestHelpers.assertEquals(manifest, (ManifestFile)obj);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile writeManifest(DataFile ... files) throws IOException {
        File manifestFile = File.createTempFile("input", "m0.avro", this.temp.toFile());
        Assertions.assertThat((boolean)manifestFile.delete()).isTrue();
        OutputFile outputFile = FILE_IO.newOutputFile(manifestFile.getCanonicalPath());
        try (ManifestWriter writer = ManifestFiles.write((PartitionSpec)SPEC, (OutputFile)outputFile);){
            for (DataFile file : files) {
                writer.add((ContentFile)file);
            }
        }
        return writer.toManifestFile();
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }
}

