/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.data.FlinkOrcReader;
import org.apache.iceberg.flink.data.FlinkOrcWriter;
import org.apache.iceberg.flink.data.RandomRowData;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.orc.TypeDescription;
import org.assertj.core.api.Assertions;

public class TestFlinkOrcReaderWriter
extends DataTest {
    private static final int NUM_RECORDS = 100;

    protected void writeAndValidate(Schema schema) throws IOException {
        RowType flinkSchema = FlinkSchemaUtil.convert((Schema)schema);
        List expectedRecords = RandomGenericData.generate((Schema)schema, (int)100, (long)1990L);
        ArrayList expectedRows = Lists.newArrayList(RandomRowData.convert(schema, expectedRecords));
        File recordsFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)recordsFile.delete()).isTrue();
        try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)recordsFile)).schema(schema).createWriterFunc(GenericOrcWriter::buildWriter).build();){
            writer.addAll((Iterable)expectedRecords);
        }
        var7_7 = null;
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)recordsFile)).project(schema).createReaderFunc(type -> new FlinkOrcReader(schema, type)).build();){
            Iterator expected = expectedRecords.iterator();
            CloseableIterator rows = reader.iterator();
            for (int i = 0; i < 100; ++i) {
                Assertions.assertThat((boolean)rows.hasNext()).isTrue();
                TestHelpers.assertRowData(schema.asStruct(), (LogicalType)flinkSchema, (StructLike)expected.next(), (RowData)rows.next());
            }
            Assertions.assertThat((Iterator)rows).isExhausted();
        }
        catch (Throwable expected) {
            var7_7 = expected;
            throw expected;
        }
        File rowDataFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)rowDataFile.delete()).isTrue();
        RowType rowType = FlinkSchemaUtil.convert((Schema)schema);
        try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)rowDataFile)).schema(schema).createWriterFunc((iSchema, typeDesc) -> FlinkOrcWriter.buildWriter((RowType)rowType, (Schema)iSchema)).build();){
            writer.addAll((Iterable)expectedRows);
        }
        var9_12 = null;
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)rowDataFile)).project(schema).createReaderFunc(type -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)type)).build();){
            Iterator expected = expectedRows.iterator();
            CloseableIterator records = reader.iterator();
            for (int i = 0; i < 100; ++i) {
                Assertions.assertThat((Iterator)records).hasNext();
                TestHelpers.assertRowData(schema.asStruct(), (LogicalType)flinkSchema, (StructLike)records.next(), (RowData)expected.next());
            }
            Assertions.assertThat((Iterator)records).isExhausted();
        }
        catch (Throwable throwable) {
            var9_12 = throwable;
            throw throwable;
        }
    }
}

