/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.TestHelpers;
import org.apache.iceberg.flink.data.FlinkParquetReaders;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFlinkParquetReader
extends DataTest {
    private static final int NUM_RECORDS = 100;

    @Test
    public void testBuildReader() {
        MessageType fileSchema = new MessageType("test", new org.apache.parquet.schema.Type[]{(org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).id(100)).named("id"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).id(101)).named("data"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)Type.Repetition.REQUIRED).id(102)).named("b"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).id(103)).named("i"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).id(104)).named("l"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)Type.Repetition.OPTIONAL).id(105)).named("f"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).id(106)).named("d"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).id(107)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named("date"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).id(108)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("ts_tz"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).id(109)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("ts"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).id(110)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("s"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)Type.Repetition.REQUIRED).id(112)).length(7)).named("f"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).id(113)).named("bytes"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).id(114)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)0, (int)9))).named("dec_9_0"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).id(115)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)11))).named("dec_11_2"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)Type.Repetition.REQUIRED).id(116)).length(16)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)10, (int)38))).named("dec_38_10"), (org.apache.parquet.schema.Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.OPTIONAL).id(117)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("time")});
        ParquetValueReader reader = FlinkParquetReaders.buildReader((Schema)new Schema(SUPPORTED_PRIMITIVES.fields()), (MessageType)fileSchema);
        Assertions.assertThat((int)reader.columns().size()).isEqualTo(SUPPORTED_PRIMITIVES.fields().size());
    }

    @Test
    public void testTwoLevelList() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"arraybytes", (Type)Types.ListType.ofRequired((int)3, (Type)Types.BinaryType.get())), Types.NestedField.optional((int)2, (String)"topbytes", (Type)Types.BinaryType.get())});
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)testFile.delete()).isTrue();
        ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)new Path(testFile.toURI())).withDataModel(GenericData.get()).withSchema(avroSchema).config("parquet.avro.add-list-element-records", "true")).config("parquet.avro.write-old-list-structure", "true")).build();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(avroSchema);
        ArrayList expectedByteList = Lists.newArrayList();
        byte[] expectedByte = new byte[]{0, 1};
        ByteBuffer expectedBinary = ByteBuffer.wrap(expectedByte);
        expectedByteList.add(expectedBinary);
        recordBuilder.set("arraybytes", (Object)expectedByteList);
        recordBuilder.set("topbytes", (Object)expectedBinary);
        GenericData.Record expectedRecord = recordBuilder.build();
        writer.write((Object)expectedRecord);
        writer.close();
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(type -> FlinkParquetReaders.buildReader((Schema)schema, (MessageType)type)).build();){
            CloseableIterator rows = reader.iterator();
            Assertions.assertThat((Iterator)rows).hasNext();
            RowData rowData = (RowData)rows.next();
            Assertions.assertThat((byte[])rowData.getArray(0).getBinary(0)).isEqualTo((Object)expectedByte);
            Assertions.assertThat((byte[])rowData.getBinary(1)).isEqualTo((Object)expectedByte);
            Assertions.assertThat((Iterator)rows).isExhausted();
        }
    }

    private void writeAndValidate(Iterable<Record> iterable, Schema schema) throws IOException {
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)testFile.delete()).isTrue();
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).createWriterFunc(GenericParquetWriter::buildWriter).build();){
            writer.addAll(iterable);
        }
        var5_5 = null;
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(type -> FlinkParquetReaders.buildReader((Schema)schema, (MessageType)type)).build();){
            Iterator<Record> expected = iterable.iterator();
            CloseableIterator rows = reader.iterator();
            RowType rowType = FlinkSchemaUtil.convert((Schema)schema);
            for (int i = 0; i < 100; ++i) {
                Assertions.assertThat((Iterator)rows).hasNext();
                TestHelpers.assertRowData(schema.asStruct(), (LogicalType)rowType, (StructLike)expected.next(), (RowData)rows.next());
            }
            Assertions.assertThat((Iterator)rows).isExhausted();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    protected void writeAndValidate(Schema schema) throws IOException {
        this.writeAndValidate(RandomGenericData.generate((Schema)schema, (int)100, (long)19981L), schema);
        this.writeAndValidate(RandomGenericData.generateDictionaryEncodableRecords((Schema)schema, (int)100, (long)21124L), schema);
        this.writeAndValidate(RandomGenericData.generateFallbackRecords((Schema)schema, (int)100, (long)21124L, (long)5L), schema);
    }
}

