/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.flink.sink.BucketPartitioner;
import org.apache.iceberg.flink.sink.TestBucketPartitionerUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class TestBucketPartitioner {
    static final int DEFAULT_NUM_BUCKETS = 60;

    @ParameterizedTest
    @CsvSource(value={"ONE_BUCKET,50", "IDENTITY_AND_BUCKET,50", "ONE_BUCKET,60", "IDENTITY_AND_BUCKET,60"})
    public void testPartitioningParallelismGreaterThanBuckets(String schemaTypeStr, String numBucketsStr) {
        int numPartitions = 500;
        TestBucketPartitionerUtil.TableSchemaType tableSchemaType = TestBucketPartitionerUtil.TableSchemaType.valueOf(schemaTypeStr);
        int numBuckets = Integer.parseInt(numBucketsStr);
        PartitionSpec partitionSpec = tableSchemaType.getPartitionSpec(numBuckets);
        BucketPartitioner bucketPartitioner = new BucketPartitioner(partitionSpec);
        int bucketId = 0;
        for (int expectedIndex = 0; expectedIndex < numPartitions; ++expectedIndex) {
            int actualPartitionIndex = bucketPartitioner.partition(Integer.valueOf(bucketId), numPartitions);
            Assertions.assertThat((int)actualPartitionIndex).isEqualTo(expectedIndex);
            if (++bucketId != numBuckets) continue;
            bucketId = 0;
        }
    }

    @ParameterizedTest
    @CsvSource(value={"ONE_BUCKET,50", "IDENTITY_AND_BUCKET,50", "ONE_BUCKET,60", "IDENTITY_AND_BUCKET,60"})
    public void testPartitioningParallelismEqualLessThanBuckets(String schemaTypeStr, String numBucketsStr) {
        int numPartitions = 30;
        TestBucketPartitionerUtil.TableSchemaType tableSchemaType = TestBucketPartitionerUtil.TableSchemaType.valueOf(schemaTypeStr);
        int numBuckets = Integer.parseInt(numBucketsStr);
        PartitionSpec partitionSpec = tableSchemaType.getPartitionSpec(numBuckets);
        BucketPartitioner bucketPartitioner = new BucketPartitioner(partitionSpec);
        for (int bucketId = 0; bucketId < numBuckets; ++bucketId) {
            int actualPartitionIndex = bucketPartitioner.partition(Integer.valueOf(bucketId), numPartitions);
            Assertions.assertThat((int)actualPartitionIndex).isEqualTo(bucketId % numPartitions);
        }
    }

    @Test
    public void testPartitionerBucketIdNullFail() {
        PartitionSpec partitionSpec = TestBucketPartitionerUtil.TableSchemaType.ONE_BUCKET.getPartitionSpec(60);
        BucketPartitioner bucketPartitioner = new BucketPartitioner(partitionSpec);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> bucketPartitioner.partition(null, 60)).withMessage("bucketId cannot be null");
    }

    @Test
    public void testPartitionerMultipleBucketsFail() {
        PartitionSpec partitionSpec = TestBucketPartitionerUtil.TableSchemaType.TWO_BUCKETS.getPartitionSpec(60);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> new BucketPartitioner(partitionSpec)).withMessage("Invalid number of buckets: %s (must be 1)", new Object[]{2});
    }

    @Test
    public void testPartitionerBucketIdOutOfRangeFail() {
        PartitionSpec partitionSpec = TestBucketPartitionerUtil.TableSchemaType.ONE_BUCKET.getPartitionSpec(60);
        BucketPartitioner bucketPartitioner = new BucketPartitioner(partitionSpec);
        int negativeBucketId = -1;
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> bucketPartitioner.partition(Integer.valueOf(negativeBucketId), 1)).withMessage("Invalid bucket ID %s: must be non-negative.", new Object[]{negativeBucketId});
        int tooBigBucketId = 60;
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> bucketPartitioner.partition(Integer.valueOf(tooBigBucketId), 1)).withMessage("Invalid bucket ID %s: must be less than bucket limit: %s.", new Object[]{tooBigBucketId, 60});
    }
}

