/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.flink.HadoopCatalogExtension;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.sink.TestFlinkIcebergSinkV2Base;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestFlinkIcebergSinkV2Branch
extends TestFlinkIcebergSinkV2Base {
    @RegisterExtension
    private static final HadoopCatalogExtension CATALOG_EXTENSION = new HadoopCatalogExtension("default", "t");
    @Parameter(index=0)
    private String branch;

    @Parameters(name="branch = {0}")
    public static Object[][] parameters() {
        return new Object[][]{{"main"}, {"testBranch"}};
    }

    @BeforeEach
    public void before() throws IOException {
        this.table = CATALOG_EXTENSION.catalog().createTable(TestFixtures.TABLE_IDENTIFIER, SimpleDataUtil.SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)FileFormat.AVRO.name(), (Object)"format-version", (Object)"2"));
        this.env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)MiniClusterResource.DISABLE_CLASSLOADER_CHECK_CONFIG).enableCheckpointing(100L);
        this.tableLoader = CATALOG_EXTENSION.tableLoader();
    }

    @TestTemplate
    public void testChangeLogOnIdKey() throws Exception {
        this.testChangeLogOnIdKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @TestTemplate
    public void testChangeLogOnDataKey() throws Exception {
        this.testChangeLogOnDataKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @TestTemplate
    public void testChangeLogOnIdDataKey() throws Exception {
        this.testChangeLogOnIdDataKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @TestTemplate
    public void testUpsertOnIdKey() throws Exception {
        this.testUpsertOnIdKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @TestTemplate
    public void testUpsertOnDataKey() throws Exception {
        this.testUpsertOnDataKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    @TestTemplate
    public void testUpsertOnIdDataKey() throws Exception {
        this.testUpsertOnIdDataKey(this.branch);
        this.verifyOtherBranchUnmodified();
    }

    private void verifyOtherBranchUnmodified() {
        String otherBranch;
        String string = otherBranch = this.branch.equals("main") ? "test-branch" : "main";
        if (otherBranch.equals("main")) {
            Assertions.assertThat((Object)this.table.currentSnapshot()).isNull();
        }
        Assertions.assertThat((Object)this.table.snapshot(otherBranch)).isNull();
    }
}

