/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatistics;
import org.apache.iceberg.flink.sink.shuffle.AggregatedStatisticsTracker;
import org.apache.iceberg.flink.sink.shuffle.DataStatistics;
import org.apache.iceberg.flink.sink.shuffle.DataStatisticsEvent;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatisticsSerializer;
import org.apache.iceberg.flink.sink.shuffle.SortKeySerializer;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class TestAggregatedStatisticsTracker {
    private static final int NUM_SUBTASKS = 2;
    private final Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"str", (Type)Types.StringType.get())});
    private final SortOrder sortOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)this.schema).asc("str")).build();
    private final SortKey sortKey = new SortKey(this.schema, this.sortOrder);
    private final MapDataStatisticsSerializer statisticsSerializer = MapDataStatisticsSerializer.fromSortKeySerializer((TypeSerializer)new SortKeySerializer(this.schema, this.sortOrder));
    private final SortKey keyA = this.sortKey.copy();
    private final SortKey keyB = this.sortKey.copy();
    private AggregatedStatisticsTracker<MapDataStatistics, Map<SortKey, Long>> aggregatedStatisticsTracker;

    public TestAggregatedStatisticsTracker() {
        this.keyA.set(0, (Object)"a");
        this.keyB.set(0, (Object)"b");
    }

    @Before
    public void before() throws Exception {
        this.aggregatedStatisticsTracker = new AggregatedStatisticsTracker("testOperator", (TypeSerializer)this.statisticsSerializer, 2);
    }

    @Test
    public void receiveNewerDataStatisticEvent() {
        MapDataStatistics checkpoint1Subtask0DataStatistic = new MapDataStatistics();
        checkpoint1Subtask0DataStatistic.add(this.keyA);
        DataStatisticsEvent checkpoint1Subtask0DataStatisticEvent = DataStatisticsEvent.create((long)1L, (DataStatistics)checkpoint1Subtask0DataStatistic, (TypeSerializer)this.statisticsSerializer);
        Assertions.assertThat((Object)this.aggregatedStatisticsTracker.updateAndCheckCompletion(0, checkpoint1Subtask0DataStatisticEvent)).isNull();
        Assertions.assertThat((long)this.aggregatedStatisticsTracker.inProgressStatistics().checkpointId()).isEqualTo(1L);
        MapDataStatistics checkpoint2Subtask0DataStatistic = new MapDataStatistics();
        checkpoint2Subtask0DataStatistic.add(this.keyA);
        DataStatisticsEvent checkpoint2Subtask0DataStatisticEvent = DataStatisticsEvent.create((long)2L, (DataStatistics)checkpoint2Subtask0DataStatistic, (TypeSerializer)this.statisticsSerializer);
        Assertions.assertThat((Object)this.aggregatedStatisticsTracker.updateAndCheckCompletion(0, checkpoint2Subtask0DataStatisticEvent)).isNull();
        Assertions.assertThat((long)this.aggregatedStatisticsTracker.inProgressStatistics().checkpointId()).isEqualTo(2L);
    }

    @Test
    public void receiveOlderDataStatisticEventTest() {
        MapDataStatistics checkpoint2Subtask0DataStatistic = new MapDataStatistics();
        checkpoint2Subtask0DataStatistic.add(this.keyA);
        checkpoint2Subtask0DataStatistic.add(this.keyB);
        checkpoint2Subtask0DataStatistic.add(this.keyB);
        DataStatisticsEvent checkpoint3Subtask0DataStatisticEvent = DataStatisticsEvent.create((long)2L, (DataStatistics)checkpoint2Subtask0DataStatistic, (TypeSerializer)this.statisticsSerializer);
        Assertions.assertThat((Object)this.aggregatedStatisticsTracker.updateAndCheckCompletion(0, checkpoint3Subtask0DataStatisticEvent)).isNull();
        MapDataStatistics checkpoint1Subtask1DataStatistic = new MapDataStatistics();
        checkpoint1Subtask1DataStatistic.add(this.keyB);
        DataStatisticsEvent checkpoint1Subtask1DataStatisticEvent = DataStatisticsEvent.create((long)1L, (DataStatistics)checkpoint1Subtask1DataStatistic, (TypeSerializer)this.statisticsSerializer);
        Assertions.assertThat((Object)this.aggregatedStatisticsTracker.updateAndCheckCompletion(1, checkpoint1Subtask1DataStatisticEvent)).isNull();
        Assertions.assertThat((long)this.aggregatedStatisticsTracker.inProgressStatistics().checkpointId()).isEqualTo(2L);
    }

    @Test
    public void receiveCompletedDataStatisticEvent() {
        MapDataStatistics checkpoint1Subtask0DataStatistic = new MapDataStatistics();
        checkpoint1Subtask0DataStatistic.add(this.keyA);
        checkpoint1Subtask0DataStatistic.add(this.keyB);
        checkpoint1Subtask0DataStatistic.add(this.keyB);
        DataStatisticsEvent checkpoint1Subtask0DataStatisticEvent = DataStatisticsEvent.create((long)1L, (DataStatistics)checkpoint1Subtask0DataStatistic, (TypeSerializer)this.statisticsSerializer);
        Assertions.assertThat((Object)this.aggregatedStatisticsTracker.updateAndCheckCompletion(0, checkpoint1Subtask0DataStatisticEvent)).isNull();
        MapDataStatistics checkpoint1Subtask1DataStatistic = new MapDataStatistics();
        checkpoint1Subtask1DataStatistic.add(this.keyA);
        checkpoint1Subtask1DataStatistic.add(this.keyA);
        checkpoint1Subtask1DataStatistic.add(this.keyB);
        DataStatisticsEvent checkpoint1Subtask1DataStatisticEvent = DataStatisticsEvent.create((long)1L, (DataStatistics)checkpoint1Subtask1DataStatistic, (TypeSerializer)this.statisticsSerializer);
        AggregatedStatistics completedStatistics = this.aggregatedStatisticsTracker.updateAndCheckCompletion(1, checkpoint1Subtask1DataStatisticEvent);
        Assertions.assertThat((Object)completedStatistics).isNotNull();
        Assertions.assertThat((long)completedStatistics.checkpointId()).isEqualTo(1L);
        MapDataStatistics globalDataStatistics = (MapDataStatistics)completedStatistics.dataStatistics();
        Assertions.assertThat((long)((Long)globalDataStatistics.statistics().get(this.keyA))).isEqualTo((Long)checkpoint1Subtask0DataStatistic.statistics().get(this.keyA) + (Long)checkpoint1Subtask1DataStatistic.statistics().get(this.keyA));
        Assertions.assertThat((long)((Long)globalDataStatistics.statistics().get(this.keyB))).isEqualTo((Long)checkpoint1Subtask0DataStatistic.statistics().get(this.keyB) + (Long)checkpoint1Subtask1DataStatistic.statistics().get(this.keyB));
        Assertions.assertThat((long)this.aggregatedStatisticsTracker.inProgressStatistics().checkpointId()).isEqualTo(completedStatistics.checkpointId() + 1L);
        MapDataStatistics checkpoint2Subtask0DataStatistic = new MapDataStatistics();
        checkpoint2Subtask0DataStatistic.add(this.keyA);
        DataStatisticsEvent checkpoint2Subtask0DataStatisticEvent = DataStatisticsEvent.create((long)2L, (DataStatistics)checkpoint2Subtask0DataStatistic, (TypeSerializer)this.statisticsSerializer);
        Assertions.assertThat((Object)this.aggregatedStatisticsTracker.updateAndCheckCompletion(0, checkpoint2Subtask0DataStatisticEvent)).isNull();
        Assertions.assertThat((long)completedStatistics.checkpointId()).isEqualTo(1L);
        MapDataStatistics checkpoint2Subtask1DataStatistic = new MapDataStatistics();
        checkpoint2Subtask1DataStatistic.add(this.keyB);
        DataStatisticsEvent checkpoint2Subtask1DataStatisticEvent = DataStatisticsEvent.create((long)2L, (DataStatistics)checkpoint2Subtask1DataStatistic, (TypeSerializer)this.statisticsSerializer);
        completedStatistics = this.aggregatedStatisticsTracker.updateAndCheckCompletion(1, checkpoint2Subtask1DataStatisticEvent);
        Assertions.assertThat((Object)completedStatistics).isNotNull();
        Assertions.assertThat((long)completedStatistics.checkpointId()).isEqualTo(2L);
        Assertions.assertThat((long)this.aggregatedStatisticsTracker.inProgressStatistics().checkpointId()).isEqualTo(completedStatistics.checkpointId() + 1L);
    }
}

