/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.flink.FlinkSchemaUtil;
import org.apache.iceberg.flink.RowDataWrapper;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.sink.shuffle.MapDataStatistics;
import org.apache.iceberg.flink.sink.shuffle.MapRangePartitioner;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.Pair;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestMapRangePartitioner {
    private static final SortOrder SORT_ORDER = ((SortOrder.Builder)SortOrder.builderFor((Schema)TestFixtures.SCHEMA).asc("data")).build();
    private static final SortKey SORT_KEY = new SortKey(TestFixtures.SCHEMA, SORT_ORDER);
    private static final RowType ROW_TYPE = FlinkSchemaUtil.convert((Schema)TestFixtures.SCHEMA);
    private static final SortKey[] SORT_KEYS = TestMapRangePartitioner.initSortKeys();
    private final MapDataStatistics mapDataStatistics = new MapDataStatistics((Map)ImmutableMap.of((Object)SORT_KEYS[0], (Object)350L, (Object)SORT_KEYS[1], (Object)230L, (Object)SORT_KEYS[2], (Object)120L, (Object)SORT_KEYS[3], (Object)40L, (Object)SORT_KEYS[4], (Object)10L, (Object)SORT_KEYS[5], (Object)10L, (Object)SORT_KEYS[6], (Object)10L, (Object)SORT_KEYS[7], (Object)10L, (Object)SORT_KEYS[8], (Object)10L, (Object)SORT_KEYS[9], (Object)10L));

    private static SortKey[] initSortKeys() {
        SortKey[] sortKeys = new SortKey[10];
        for (int i = 0; i < 10; ++i) {
            GenericRowData rowData = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)("k" + i)), i, StringData.fromString((String)"2023-06-20")});
            RowDataWrapper keyWrapper = new RowDataWrapper(ROW_TYPE, TestFixtures.SCHEMA.asStruct());
            keyWrapper.wrap((RowData)rowData);
            SortKey sortKey = SORT_KEY.copy();
            sortKey.wrap((StructLike)keyWrapper);
            sortKeys[i] = sortKey;
        }
        return sortKeys;
    }

    @Test
    public void testEvenlyDividableNoClosingFileCost() {
        MapRangePartitioner partitioner = new MapRangePartitioner(TestFixtures.SCHEMA, SORT_ORDER, this.mapDataStatistics, 0.0);
        int numPartitions = 8;
        ImmutableMap expectedAssignment = ImmutableMap.of((Object)SORT_KEYS[0], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3), (List)ImmutableList.of((Object)100L, (Object)100L, (Object)100L, (Object)50L), 0L), (Object)SORT_KEYS[1], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)3, (Object)4, (Object)5), (List)ImmutableList.of((Object)50L, (Object)100L, (Object)80L), 0L), (Object)SORT_KEYS[2], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)5, (Object)6), (List)ImmutableList.of((Object)20L, (Object)100L), 0L), (Object)SORT_KEYS[3], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)40L), 0L), (Object)SORT_KEYS[4], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[5], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[6], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[7], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[8], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[9], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)10L), 0L));
        Map actualAssignment = partitioner.assignment(numPartitions);
        Assertions.assertThat((Map)actualAssignment).isEqualTo((Object)expectedAssignment);
        ImmutableMap expectedAssignmentInfo = ImmutableMap.of((Object)0, (Object)Pair.of((Object)100L, (Object)1), (Object)1, (Object)Pair.of((Object)100L, (Object)1), (Object)2, (Object)Pair.of((Object)100L, (Object)1), (Object)3, (Object)Pair.of((Object)100L, (Object)2), (Object)4, (Object)Pair.of((Object)100L, (Object)1), (Object)5, (Object)Pair.of((Object)100L, (Object)2), (Object)6, (Object)Pair.of((Object)100L, (Object)1), (Object)7, (Object)Pair.of((Object)100L, (Object)7));
        Map actualAssignmentInfo = partitioner.assignmentInfo();
        Assertions.assertThat((Map)actualAssignmentInfo).isEqualTo((Object)expectedAssignmentInfo);
        Map<Integer, Pair<AtomicLong, Set<RowData>>> partitionResults = TestMapRangePartitioner.runPartitioner(partitioner, numPartitions);
        this.validatePartitionResults((Map<Integer, Pair<Long, Integer>>)expectedAssignmentInfo, partitionResults, 5.0);
    }

    @Test
    public void testEvenlyDividableWithClosingFileCost() {
        MapRangePartitioner partitioner = new MapRangePartitioner(TestFixtures.SCHEMA, SORT_ORDER, this.mapDataStatistics, 5.0);
        int numPartitions = 8;
        ImmutableMap expectedAssignment = ImmutableMap.of((Object)SORT_KEYS[0], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3), (List)ImmutableList.of((Object)110L, (Object)110L, (Object)110L, (Object)40L), 5L), (Object)SORT_KEYS[1], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)3, (Object)4, (Object)5), (List)ImmutableList.of((Object)70L, (Object)110L, (Object)65L), 5L), (Object)SORT_KEYS[2], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)5, (Object)6), (List)ImmutableList.of((Object)45L, (Object)85L), 5L), (Object)SORT_KEYS[3], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)6, (Object)7), (List)ImmutableList.of((Object)25L, (Object)20L), 5L), (Object)SORT_KEYS[4], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[5], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[6], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[7], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[8], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[9], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7), (List)ImmutableList.of((Object)15L), 5L));
        Map actualAssignment = partitioner.assignment(numPartitions);
        Assertions.assertThat((Map)actualAssignment).isEqualTo((Object)expectedAssignment);
        ImmutableMap expectedAssignmentInfo = ImmutableMap.of((Object)0, (Object)Pair.of((Object)105L, (Object)1), (Object)1, (Object)Pair.of((Object)105L, (Object)1), (Object)2, (Object)Pair.of((Object)105L, (Object)1), (Object)3, (Object)Pair.of((Object)100L, (Object)2), (Object)4, (Object)Pair.of((Object)105L, (Object)1), (Object)5, (Object)Pair.of((Object)100L, (Object)2), (Object)6, (Object)Pair.of((Object)100L, (Object)2), (Object)7, (Object)Pair.of((Object)75L, (Object)7));
        Map actualAssignmentInfo = partitioner.assignmentInfo();
        Assertions.assertThat((Map)actualAssignmentInfo).isEqualTo((Object)expectedAssignmentInfo);
        Map<Integer, Pair<AtomicLong, Set<RowData>>> partitionResults = TestMapRangePartitioner.runPartitioner(partitioner, numPartitions);
        this.validatePartitionResults((Map<Integer, Pair<Long, Integer>>)expectedAssignmentInfo, partitionResults, 5.0);
    }

    @Test
    public void testNonDividableNoClosingFileCost() {
        MapRangePartitioner partitioner = new MapRangePartitioner(TestFixtures.SCHEMA, SORT_ORDER, this.mapDataStatistics, 0.0);
        int numPartitions = 9;
        ImmutableMap expectedAssignment = ImmutableMap.of((Object)SORT_KEYS[0], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3), (List)ImmutableList.of((Object)89L, (Object)89L, (Object)89L, (Object)83L), 0L), (Object)SORT_KEYS[1], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)3, (Object)4, (Object)5, (Object)6), (List)ImmutableList.of((Object)6L, (Object)89L, (Object)89L, (Object)46L), 0L), (Object)SORT_KEYS[2], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)6, (Object)7), (List)ImmutableList.of((Object)43L, (Object)77L), 0L), (Object)SORT_KEYS[3], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7, (Object)8), (List)ImmutableList.of((Object)12L, (Object)28L), 0L), (Object)SORT_KEYS[4], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[5], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[6], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[7], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[8], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)10L), 0L), (Object)SORT_KEYS[9], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)10L), 0L));
        Map actualAssignment = partitioner.assignment(numPartitions);
        Assertions.assertThat((Map)actualAssignment).isEqualTo((Object)expectedAssignment);
        ImmutableMap expectedAssignmentInfo = ImmutableMap.of((Object)0, (Object)Pair.of((Object)89L, (Object)1), (Object)1, (Object)Pair.of((Object)89L, (Object)1), (Object)2, (Object)Pair.of((Object)89L, (Object)1), (Object)3, (Object)Pair.of((Object)89L, (Object)2), (Object)4, (Object)Pair.of((Object)89L, (Object)1), (Object)5, (Object)Pair.of((Object)89L, (Object)1), (Object)6, (Object)Pair.of((Object)89L, (Object)2), (Object)7, (Object)Pair.of((Object)89L, (Object)2), (Object)8, (Object)Pair.of((Object)88L, (Object)7));
        Map actualAssignmentInfo = partitioner.assignmentInfo();
        Assertions.assertThat((Map)actualAssignmentInfo).isEqualTo((Object)expectedAssignmentInfo);
        Map<Integer, Pair<AtomicLong, Set<RowData>>> partitionResults = TestMapRangePartitioner.runPartitioner(partitioner, numPartitions);
        this.validatePartitionResults((Map<Integer, Pair<Long, Integer>>)expectedAssignmentInfo, partitionResults, 5.0);
    }

    @Test
    public void testNonDividableWithClosingFileCost() {
        MapRangePartitioner partitioner = new MapRangePartitioner(TestFixtures.SCHEMA, SORT_ORDER, this.mapDataStatistics, 5.0);
        int numPartitions = 9;
        ImmutableMap expectedAssignment = ImmutableMap.of((Object)SORT_KEYS[0], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3), (List)ImmutableList.of((Object)98L, (Object)98L, (Object)98L, (Object)76L), 5L), (Object)SORT_KEYS[1], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)3, (Object)4, (Object)5, (Object)6), (List)ImmutableList.of((Object)22L, (Object)98L, (Object)98L, (Object)27L), 5L), (Object)SORT_KEYS[2], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)6, (Object)7), (List)ImmutableList.of((Object)71L, (Object)59L), 5L), (Object)SORT_KEYS[3], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)7, (Object)8), (List)ImmutableList.of((Object)39L, (Object)6L), 5L), (Object)SORT_KEYS[4], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[5], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[6], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[7], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[8], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)15L), 5L), (Object)SORT_KEYS[9], (Object)new MapRangePartitioner.KeyAssignment((List)ImmutableList.of((Object)8), (List)ImmutableList.of((Object)15L), 5L));
        Map actualAssignment = partitioner.assignment(numPartitions);
        Assertions.assertThat((Map)actualAssignment).isEqualTo((Object)expectedAssignment);
        ImmutableMap expectedAssignmentInfo = ImmutableMap.of((Object)0, (Object)Pair.of((Object)93L, (Object)1), (Object)1, (Object)Pair.of((Object)93L, (Object)1), (Object)2, (Object)Pair.of((Object)93L, (Object)1), (Object)3, (Object)Pair.of((Object)88L, (Object)2), (Object)4, (Object)Pair.of((Object)93L, (Object)1), (Object)5, (Object)Pair.of((Object)93L, (Object)1), (Object)6, (Object)Pair.of((Object)88L, (Object)2), (Object)7, (Object)Pair.of((Object)88L, (Object)2), (Object)8, (Object)Pair.of((Object)61L, (Object)7));
        Map actualAssignmentInfo = partitioner.assignmentInfo();
        Assertions.assertThat((Map)actualAssignmentInfo).isEqualTo((Object)expectedAssignmentInfo);
        Map<Integer, Pair<AtomicLong, Set<RowData>>> partitionResults = TestMapRangePartitioner.runPartitioner(partitioner, numPartitions);
        this.validatePartitionResults((Map<Integer, Pair<Long, Integer>>)expectedAssignmentInfo, partitionResults, 10.0);
    }

    private static Map<Integer, Pair<AtomicLong, Set<RowData>>> runPartitioner(MapRangePartitioner partitioner, int numPartitions) {
        HashMap partitionResults = Maps.newHashMap();
        partitioner.mapStatistics().forEach((sortKey, weight) -> {
            String key = (String)sortKey.get(0, String.class);
            long iterations = weight * 100L;
            int i = 0;
            while ((long)i < iterations) {
                GenericRowData rowData = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)key), 1, StringData.fromString((String)"2023-06-20")});
                int subtaskId = partitioner.partition((RowData)rowData, numPartitions);
                partitionResults.computeIfAbsent(subtaskId, k -> Pair.of((Object)new AtomicLong(0L), (Object)Sets.newHashSet()));
                Pair pair = (Pair)partitionResults.get(subtaskId);
                ((AtomicLong)pair.first()).incrementAndGet();
                ((Set)pair.second()).add(rowData);
                ++i;
            }
        });
        return partitionResults;
    }

    private void validatePartitionResults(Map<Integer, Pair<Long, Integer>> expectedAssignmentInfo, Map<Integer, Pair<AtomicLong, Set<RowData>>> partitionResults, double maxDriftPercentage) {
        Assertions.assertThat((int)partitionResults.size()).isEqualTo(expectedAssignmentInfo.size());
        ArrayList expectedAssignedKeyCounts = Lists.newArrayListWithExpectedSize((int)expectedAssignmentInfo.size());
        ArrayList actualAssignedKeyCounts = Lists.newArrayListWithExpectedSize((int)partitionResults.size());
        ArrayList expectedNormalizedWeights = Lists.newArrayListWithExpectedSize((int)expectedAssignmentInfo.size());
        ArrayList actualNormalizedWeights = Lists.newArrayListWithExpectedSize((int)partitionResults.size());
        long expectedTotalWeight = expectedAssignmentInfo.values().stream().mapToLong(Pair::first).sum();
        expectedAssignmentInfo.forEach((subtaskId, pair) -> {
            expectedAssignedKeyCounts.add((Integer)pair.second());
            expectedNormalizedWeights.add(((Long)pair.first()).doubleValue() / (double)expectedTotalWeight);
        });
        long actualTotalWeight = partitionResults.values().stream().mapToLong(pair -> ((AtomicLong)pair.first()).longValue()).sum();
        partitionResults.forEach((subtaskId, pair) -> {
            actualAssignedKeyCounts.add(((Set)pair.second()).size());
            actualNormalizedWeights.add(((AtomicLong)pair.first()).doubleValue() / (double)actualTotalWeight);
        });
        ((ListAssert)Assertions.assertThat((List)actualAssignedKeyCounts).as("the number of assigned keys should match for every subtask", new Object[0])).isEqualTo((Object)expectedAssignedKeyCounts);
        for (int subtaskId2 = 0; subtaskId2 < expectedNormalizedWeights.size(); ++subtaskId2) {
            double expectedWeight = (Double)expectedNormalizedWeights.get(subtaskId2);
            double min = expectedWeight * (1.0 - maxDriftPercentage / 100.0);
            double max = expectedWeight * (1.0 + maxDriftPercentage / 100.0);
            ((AbstractDoubleAssert)Assertions.assertThat((Double)((Double)actualNormalizedWeights.get(subtaskId2))).as("Subtask %d weight should within %.1f percent of the expected range %s", new Object[]{subtaskId2, maxDriftPercentage, expectedWeight})).isBetween(Double.valueOf(min), Double.valueOf(max));
        }
    }
}

