/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.iceberg.flink.MiniClusterResource;
import org.apache.iceberg.flink.TestBase;
import org.apache.iceberg.flink.source.BoundedTableFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public class ChangeLogTableTestBase
extends TestBase {
    private volatile TableEnvironment tEnv = null;
    protected String tableName;

    @BeforeEach
    public void setup(TestInfo testInfo) {
        Assertions.assertThat((Optional)testInfo.getTestMethod()).isPresent();
        this.tableName = ((Method)testInfo.getTestMethod().get()).getName();
    }

    @AfterEach
    public void clean() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        BoundedTableFactory.clearDataSets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TableEnvironment getTableEnv() {
        if (this.tEnv == null) {
            ChangeLogTableTestBase changeLogTableTestBase = this;
            synchronized (changeLogTableTestBase) {
                if (this.tEnv == null) {
                    EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
                    StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)MiniClusterResource.DISABLE_CLASSLOADER_CHECK_CONFIG).enableCheckpointing(400L).setMaxParallelism(1).setParallelism(1);
                    this.tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env, (EnvironmentSettings)settings);
                }
            }
        }
        return this.tEnv;
    }

    protected static Row insertRow(Object ... values) {
        return Row.ofKind((RowKind)RowKind.INSERT, (Object[])values);
    }

    protected static Row deleteRow(Object ... values) {
        return Row.ofKind((RowKind)RowKind.DELETE, (Object[])values);
    }

    protected static Row updateBeforeRow(Object ... values) {
        return Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])values);
    }

    protected static Row updateAfterRow(Object ... values) {
        return Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])values);
    }

    protected static <T> List<T> listJoin(List<List<T>> lists) {
        return lists.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

