/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.source.FlinkSplitPlanner;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.ThreadPools;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;

public class SplitHelpers {
    private SplitHelpers() {
    }

    public static List<IcebergSourceSplit> createSplitsFromTransientHadoopTable(Path temporaryFolder, int fileCount, int filesPerSplit) throws Exception {
        return SplitHelpers.createSplitsFromTransientHadoopTable(temporaryFolder, fileCount, filesPerSplit, "1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IcebergSourceSplit> createSplitsFromTransientHadoopTable(Path temporaryFolder, int fileCount, int filesPerSplit, String version) throws Exception {
        File warehouseFile = File.createTempFile("junit", null, temporaryFolder.toFile());
        Assertions.assertThat((boolean)warehouseFile.delete()).isTrue();
        String warehouse = "file:" + warehouseFile;
        Configuration hadoopConf = new Configuration();
        HadoopCatalog catalog = new HadoopCatalog(hadoopConf, warehouse);
        ImmutableMap properties = ImmutableMap.of((Object)"format-version", (Object)version);
        try {
            Table table = catalog.createTable(TestFixtures.TABLE_IDENTIFIER, TestFixtures.SCHEMA, PartitionSpec.unpartitioned(), null, (Map)properties);
            GenericAppenderHelper dataAppender = new GenericAppenderHelper(table, FileFormat.PARQUET, temporaryFolder);
            for (int i = 0; i < fileCount; ++i) {
                List records = RandomGenericData.generate((Schema)TestFixtures.SCHEMA, (int)2, (long)i);
                dataAppender.appendToTable(records);
            }
            ScanContext scanContext = ScanContext.builder().build();
            List splits = FlinkSplitPlanner.planIcebergSourceSplits((Table)table, (ScanContext)scanContext, (ExecutorService)ThreadPools.getWorkerPool());
            List<IcebergSourceSplit> list = splits.stream().flatMap(split -> {
                List filesList = Lists.partition((List)Lists.newArrayList((Iterable)split.task().files()), (int)filesPerSplit);
                return filesList.stream().map(files -> new BaseCombinedScanTask(files)).map(combinedScanTask -> IcebergSourceSplit.fromCombinedScanTask((CombinedScanTask)combinedScanTask));
            }).collect(Collectors.toList());
            return list;
        }
        finally {
            catalog.dropTable(TestFixtures.TABLE_IDENTIFIER);
            catalog.close();
        }
    }

    public static List<IcebergSourceSplit> equipSplitsWithMockDeleteFiles(List<IcebergSourceSplit> icebergSourceSplits, Path temporaryFolder, int deleteFilesPerSplit) throws IOException {
        ArrayList icebergSourceSplitsWithMockDeleteFiles = Lists.newArrayList();
        for (IcebergSourceSplit split : icebergSourceSplits) {
            CombinedScanTask combinedScanTask = (CombinedScanTask)Mockito.spy((Object)split.task());
            ArrayList deleteFiles = Lists.newArrayList();
            PartitionSpec spec = PartitionSpec.builderFor((Schema)TestFixtures.SCHEMA).withSpecId(0).build();
            for (int i = 0; i < deleteFilesPerSplit; ++i) {
                DeleteFile deleteFile = FileMetadata.deleteFileBuilder((PartitionSpec)spec).withFormat(FileFormat.PARQUET).withPath(File.createTempFile("junit", null, temporaryFolder.toFile()).getPath()).ofPositionDeletes().withFileSizeInBytes(1000L).withRecordCount(1000L).build();
                deleteFiles.add(deleteFile);
            }
            ArrayList newFileScanTasks = Lists.newArrayList();
            for (FileScanTask task : combinedScanTask.tasks()) {
                String schemaString = SchemaParser.toJson((Schema)task.schema());
                String specString = PartitionSpecParser.toJson((PartitionSpec)task.spec());
                BaseFileScanTask baseFileScanTask = new BaseFileScanTask((DataFile)task.file(), deleteFiles.toArray(new DeleteFile[0]), schemaString, specString, ResidualEvaluator.unpartitioned((Expression)task.residual()));
                newFileScanTasks.add(baseFileScanTask);
            }
            ((CombinedScanTask)Mockito.doReturn((Object)newFileScanTasks).when((Object)combinedScanTask)).tasks();
            icebergSourceSplitsWithMockDeleteFiles.add(IcebergSourceSplit.fromCombinedScanTask((CombinedScanTask)combinedScanTask, (int)split.fileOffset(), (long)split.recordOffset()));
        }
        return icebergSourceSplitsWithMockDeleteFiles;
    }
}

