/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class SqlHelpers {
    private SqlHelpers() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Row> sql(TableEnvironment tableEnv, String query, Object ... args) {
        TableResult tableResult = tableEnv.executeSql(String.format(query, args));
        try (CloseableIterator iter = tableResult.collect();){
            ArrayList results;
            ArrayList arrayList = results = Lists.newArrayList((Iterator)iter);
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to collect table result", e);
        }
    }

    public static String sqlOptionsToString(Map<String, String> sqlOptions) {
        StringBuilder builder = new StringBuilder();
        sqlOptions.forEach((key, value) -> builder.append(SqlHelpers.optionToKv(key, value)).append(","));
        String optionStr = builder.toString();
        if (optionStr.endsWith(",")) {
            optionStr = optionStr.substring(0, optionStr.length() - 1);
        }
        if (!optionStr.isEmpty()) {
            optionStr = String.format("/*+ OPTIONS(%s)*/", optionStr);
        }
        return optionStr;
    }

    private static String optionToKv(String key, Object value) {
        return "'" + key + "'='" + value + "'";
    }
}

