/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.highavailability.nonha.embedded.HaLeadershipControl;
import org.apache.flink.runtime.jobgraph.SavepointConfigOptions;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderHelper;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.flink.FlinkConfigOptions;
import org.apache.iceberg.flink.HadoopTableResource;
import org.apache.iceberg.flink.SimpleDataUtil;
import org.apache.iceberg.flink.TestFixtures;
import org.apache.iceberg.flink.sink.FlinkSink;
import org.apache.iceberg.flink.source.IcebergSource;
import org.apache.iceberg.flink.source.StreamingStartingStrategy;
import org.apache.iceberg.flink.source.assigner.SimpleSplitAssignerFactory;
import org.apache.iceberg.flink.source.assigner.SplitAssignerFactory;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.Timeout;

public class TestIcebergSourceFailover {
    private static final int PARALLELISM = 2;
    private static final int DO_NOT_FAIL = Integer.MAX_VALUE;
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    @Rule
    public final MiniClusterWithClientResource miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(2).setRpcServiceSharing(RpcServiceSharing.DEDICATED).withHaLeadershipControl().build());
    @Rule
    public final HadoopTableResource sourceTableResource = new HadoopTableResource(TEMPORARY_FOLDER, "default", "t", this.schema());
    @Rule
    public final HadoopTableResource sinkTableResource = new HadoopTableResource(TEMPORARY_FOLDER, "default", "t_sink", this.schema());
    @Rule
    public Timeout globalTimeout = Timeout.seconds((long)120L);

    protected IcebergSource.Builder<RowData> sourceBuilder() {
        Configuration config = new Configuration();
        return IcebergSource.forRowData().tableLoader(this.sourceTableResource.tableLoader()).assignerFactory((SplitAssignerFactory)new SimpleSplitAssignerFactory()).set("split-file-open-cost", Long.toString(0x8000000L)).flinkConfig((ReadableConfig)config);
    }

    protected Schema schema() {
        return TestFixtures.SCHEMA;
    }

    protected List<Record> generateRecords(int numRecords, long seed) {
        return RandomGenericData.generate((Schema)this.schema(), (int)numRecords, (long)seed);
    }

    protected void assertRecords(Table table, List<Record> expectedRecords, Duration timeout) throws Exception {
        SimpleDataUtil.assertTableRecords(table, expectedRecords, timeout);
    }

    @Test
    public void testBoundedWithSavepoint() throws Exception {
        ArrayList expectedRecords = Lists.newArrayList();
        Table sinkTable = this.sinkTableResource.table();
        GenericAppenderHelper dataAppender = new GenericAppenderHelper(this.sourceTableResource.table(), FileFormat.PARQUET, TEMPORARY_FOLDER);
        for (int i = 0; i < 4; ++i) {
            List<Record> records = this.generateRecords(2, i);
            expectedRecords.addAll(records);
            dataAppender.appendToTable(records);
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        this.createBoundedStreams(env, 2);
        JobClient jobClient = env.executeAsync("Bounded Iceberg Source Savepoint Test");
        JobID jobId = jobClient.getJobID();
        RecordCounterToWait.waitForCondition();
        CompletableFuture savepoint = this.miniClusterResource.getClusterClient().stopWithSavepoint(jobId, false, TEMPORARY_FOLDER.newFolder().toPath().toString(), SavepointFormatType.CANONICAL);
        RecordCounterToWait.continueProcessing();
        String savepointPath = (String)savepoint.get();
        Assertions.assertThat(SimpleDataUtil.tableRecords(sinkTable)).hasSizeGreaterThan(0);
        Configuration conf = new Configuration();
        conf.set(SavepointConfigOptions.SAVEPOINT_PATH, (Object)savepointPath);
        env = StreamExecutionEnvironment.getExecutionEnvironment((Configuration)conf);
        this.createBoundedStreams(env, Integer.MAX_VALUE);
        env.execute("Bounded Iceberg Source Savepoint Test");
        this.assertRecords(sinkTable, expectedRecords, Duration.ofSeconds(120L));
    }

    @Test
    public void testBoundedWithTaskManagerFailover() throws Exception {
        this.testBoundedIcebergSource(FailoverType.TM);
    }

    @Test
    public void testBoundedWithJobManagerFailover() throws Exception {
        this.testBoundedIcebergSource(FailoverType.JM);
    }

    private void testBoundedIcebergSource(FailoverType failoverType) throws Exception {
        ArrayList expectedRecords = Lists.newArrayList();
        GenericAppenderHelper dataAppender = new GenericAppenderHelper(this.sourceTableResource.table(), FileFormat.PARQUET, TEMPORARY_FOLDER);
        for (int i = 0; i < 4; ++i) {
            List<Record> records = this.generateRecords(2, i);
            expectedRecords.addAll(records);
            dataAppender.appendToTable(records);
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)1, (long)0L));
        this.createBoundedStreams(env, 2);
        JobClient jobClient = env.executeAsync("Bounded Iceberg Source Failover Test");
        JobID jobId = jobClient.getJobID();
        RecordCounterToWait.waitForCondition();
        TestIcebergSourceFailover.triggerFailover(failoverType, jobId, () -> RecordCounterToWait.continueProcessing(), this.miniClusterResource.getMiniCluster());
        this.assertRecords(this.sinkTableResource.table(), expectedRecords, Duration.ofSeconds(120L));
    }

    @Test
    public void testContinuousWithTaskManagerFailover() throws Exception {
        this.testContinuousIcebergSource(FailoverType.TM);
    }

    @Test
    public void testContinuousWithJobManagerFailover() throws Exception {
        this.testContinuousIcebergSource(FailoverType.JM);
    }

    private void testContinuousIcebergSource(FailoverType failoverType) throws Exception {
        GenericAppenderHelper dataAppender = new GenericAppenderHelper(this.sourceTableResource.table(), FileFormat.PARQUET, TEMPORARY_FOLDER);
        ArrayList expectedRecords = Lists.newArrayList();
        List<Record> batch = this.generateRecords(2, 0L);
        expectedRecords.addAll(batch);
        dataAppender.appendToTable(batch);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(2);
        env.enableCheckpointing(10L);
        Configuration config = new Configuration();
        config.setInteger(FlinkConfigOptions.SOURCE_READER_FETCH_BATCH_RECORD_COUNT, 128);
        DataStreamSource stream = env.fromSource((Source)this.sourceBuilder().streaming(true).monitorInterval(Duration.ofMillis(10L)).streamingStartingStrategy(StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL).build(), WatermarkStrategy.noWatermarks(), "IcebergSource", TypeInformation.of(RowData.class));
        FlinkSink.forRowData((DataStream)stream).table(this.sinkTableResource.table()).tableLoader(this.sinkTableResource.tableLoader()).append();
        JobClient jobClient = env.executeAsync("Continuous Iceberg Source Failover Test");
        JobID jobId = jobClient.getJobID();
        for (int i = 1; i < 5; ++i) {
            Thread.sleep(10L);
            List<Record> records = this.generateRecords(2, i);
            expectedRecords.addAll(records);
            dataAppender.appendToTable(records);
            if (i != 2) continue;
            TestIcebergSourceFailover.triggerFailover(failoverType, jobId, () -> {}, this.miniClusterResource.getMiniCluster());
        }
        this.assertRecords(this.sinkTableResource.table(), expectedRecords, Duration.ofSeconds(120L));
    }

    private void createBoundedStreams(StreamExecutionEnvironment env, int failAfter) {
        env.setParallelism(2);
        DataStreamSource stream = env.fromSource((Source)this.sourceBuilder().build(), WatermarkStrategy.noWatermarks(), "IcebergSource", TypeInformation.of(RowData.class));
        DataStream streamFailingInTheMiddleOfReading = RecordCounterToWait.wrapWithFailureAfter((DataStream)stream, failAfter);
        FlinkSink.forRowData((DataStream)streamFailingInTheMiddleOfReading).table(this.sinkTableResource.table()).tableLoader(this.sinkTableResource.tableLoader()).append();
    }

    private static void triggerFailover(FailoverType type, JobID jobId, Runnable afterFailAction, MiniCluster miniCluster) throws Exception {
        switch (type) {
            case NONE: {
                afterFailAction.run();
                break;
            }
            case TM: {
                TestIcebergSourceFailover.restartTaskManager(afterFailAction, miniCluster);
                break;
            }
            case JM: {
                TestIcebergSourceFailover.triggerJobManagerFailover(jobId, afterFailAction, miniCluster);
            }
        }
    }

    private static void triggerJobManagerFailover(JobID jobId, Runnable afterFailAction, MiniCluster miniCluster) throws Exception {
        HaLeadershipControl haLeadershipControl = (HaLeadershipControl)miniCluster.getHaLeadershipControl().get();
        haLeadershipControl.revokeJobMasterLeadership(jobId).get();
        afterFailAction.run();
        haLeadershipControl.grantJobMasterLeadership(jobId).get();
    }

    private static void restartTaskManager(Runnable afterFailAction, MiniCluster miniCluster) throws Exception {
        miniCluster.terminateTaskManager(0).get();
        afterFailAction.run();
        miniCluster.startTaskManager();
    }

    private static class RecordCounterToWait {
        private static AtomicInteger records;
        private static CountDownLatch countDownLatch;
        private static CompletableFuture<Void> continueProcessing;

        private RecordCounterToWait() {
        }

        private static <T> DataStream<T> wrapWithFailureAfter(DataStream<T> stream, int condition) {
            records = new AtomicInteger();
            continueProcessing = new CompletableFuture();
            countDownLatch = new CountDownLatch(stream.getParallelism());
            return stream.map((MapFunction & Serializable)record -> {
                boolean notFailedYet;
                boolean reachedFailPoint = records.incrementAndGet() > condition;
                boolean bl = notFailedYet = countDownLatch.getCount() != 0L;
                if (notFailedYet && reachedFailPoint) {
                    countDownLatch.countDown();
                    continueProcessing.get();
                }
                return record;
            });
        }

        private static void waitForCondition() throws InterruptedException {
            countDownLatch.await();
        }

        private static void continueProcessing() {
            continueProcessing.complete(null);
        }
    }

    private static enum FailoverType {
        NONE,
        TM,
        JM;

    }
}

